/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.pack;

import java.util.Optional;
import java.util.function.BooleanSupplier;
import kr.toxicity.model.api.BetterModel;
import kr.toxicity.model.api.pack.PackMeta;
import kr.toxicity.model.api.pack.PackPath;
import kr.toxicity.model.api.util.function.BooleanConstantSupplier;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;

public enum PackOverlay {
    DEFAULT("default", null, BooleanConstantSupplier.TRUE){

        @Override
        @NotNull
        public PackPath path(@NotNull String namespace) {
            return PackPath.EMPTY;
        }
    }
    ,
    LEGACY("legacy", new PackMeta.VersionRange(22, 45), BetterModel.config().pack()::generateLegacyModel),
    MODERN("modern", new PackMeta.VersionRange(46, 99), BetterModel.config().pack()::generateModernModel);

    private final String packName;
    private final PackMeta.VersionRange range;
    private final BooleanSupplier predicate;

    @NotNull
    public PackPath path(@NotNull String namespace) {
        return new PackPath(namespace + "_" + this.packName);
    }

    @NotNull
    public Optional<PackMeta.VersionRange> range() {
        return Optional.ofNullable(this.range);
    }

    public boolean test() {
        return this.predicate.getAsBoolean();
    }

    @Generated
    private PackOverlay(String packName, PackMeta.VersionRange range, BooleanSupplier predicate) {
        this.packName = packName;
        this.range = range;
        this.predicate = predicate;
    }
}

