/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.script;

import kr.toxicity.model.api.animation.Timed;
import kr.toxicity.model.api.script.AnimationScript;
import kr.toxicity.model.api.script.ScriptSource;
import org.jetbrains.annotations.NotNull;

public record TimeScript(float time, @NotNull AnimationScript script) implements AnimationScript,
Timed
{
    public static final TimeScript EMPTY = AnimationScript.EMPTY.time(0.0f);

    @Override
    public boolean isSync() {
        return this.script.isSync();
    }

    @Override
    public void accept(@NotNull ScriptSource trigger) {
        this.script.accept(trigger);
    }

    @Override
    @NotNull
    public TimeScript time(float newTime) {
        if (this.time == newTime) {
            return this;
        }
        return new TimeScript(newTime, this.script);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TimeScript)) {
            return false;
        }
        TimeScript that = (TimeScript)o;
        return Float.compare(this.time, that.time) == 0;
    }

    @Override
    public int hashCode() {
        return Float.hashCode(this.time);
    }
}

