/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.tracker;

import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Function;
import kr.toxicity.model.api.BetterModel;
import kr.toxicity.model.api.animation.AnimationIterator;
import kr.toxicity.model.api.animation.AnimationModifier;
import kr.toxicity.model.api.bone.BoneTags;
import kr.toxicity.model.api.data.blueprint.NamedBoundingBox;
import kr.toxicity.model.api.data.renderer.RenderPipeline;
import kr.toxicity.model.api.event.CreateEntityTrackerEvent;
import kr.toxicity.model.api.event.DismountModelEvent;
import kr.toxicity.model.api.event.MountModelEvent;
import kr.toxicity.model.api.nms.EntityAdapter;
import kr.toxicity.model.api.nms.HitBox;
import kr.toxicity.model.api.nms.HitBoxListener;
import kr.toxicity.model.api.nms.ModelDisplay;
import kr.toxicity.model.api.tracker.EntityBodyRotator;
import kr.toxicity.model.api.tracker.EntityHideOption;
import kr.toxicity.model.api.tracker.EntityTrackerRegistry;
import kr.toxicity.model.api.tracker.ModelRotation;
import kr.toxicity.model.api.tracker.Tracker;
import kr.toxicity.model.api.tracker.TrackerData;
import kr.toxicity.model.api.tracker.TrackerModifier;
import kr.toxicity.model.api.util.EventUtil;
import kr.toxicity.model.api.util.FunctionUtil;
import kr.toxicity.model.api.util.MathUtil;
import kr.toxicity.model.api.util.function.BonePredicate;
import kr.toxicity.model.api.util.function.FloatSupplier;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class EntityTracker
extends Tracker {
    private static final BonePredicate CREATE_HITBOX_PREDICATE = BonePredicate.from(b -> b.name().name().equals("hitbox") || b.name().tagged(BoneTags.HITBOX) || b.getGroup().getMountController().canMount());
    private static final BonePredicate CREATE_NAMETAG_PREDICATE = BonePredicate.from(b -> b.name().tagged(BoneTags.TAG, BoneTags.MOB_TAG, BoneTags.PLAYER_TAG));
    private static final BonePredicate HITBOX_REFRESH_PREDICATE = BonePredicate.from(r -> r.getHitBox() != null);
    private final EntityTrackerRegistry registry;
    private final AtomicInteger damageTintValue = new AtomicInteger(0xFF8080);
    private final AtomicLong damageTint = new AtomicLong(-1L);
    private final Set<UUID> markForSpawn = ConcurrentHashMap.newKeySet();
    private final EntityBodyRotator bodyRotator;
    private EntityHideOption hideOption = EntityHideOption.DEFAULT;

    @ApiStatus.Internal
    public EntityTracker(@NotNull EntityTrackerRegistry registry, @NotNull RenderPipeline pipeline, @NotNull TrackerModifier modifier, @NotNull Consumer<EntityTracker> preUpdateConsumer) {
        super(pipeline, modifier);
        this.registry = registry;
        this.bodyRotator = new EntityBodyRotator(registry);
        Entity entity = registry.entity();
        EntityAdapter adapter = registry.adapter();
        FloatSupplier scale2 = FunctionUtil.throttleTickFloat(() -> this.scaler().scale(this));
        Optional.ofNullable(this.bone("shadow")).ifPresent(bone -> {
            NamedBoundingBox box = bone.getGroup().getHitBox();
            if (box == null) {
                return;
            }
            ModelDisplay shadow = BetterModel.plugin().nms().create(entity.getLocation());
            float baseScale = (float)(box.box().x() + box.box().z()) / 4.0f;
            this.tick((t, s) -> {
                Vector3f wPos = bone.hitBoxPosition();
                shadow.shadowRadius(scale2.getAsFloat() * baseScale);
                shadow.syncEntity(adapter);
                shadow.syncPosition(this.location().add((double)wPos.x, (double)wPos.y, (double)wPos.z));
                shadow.sendDirtyEntityData(s.getDataBundler());
                shadow.sendPosition(adapter, s.getTickBundler());
            });
            pipeline.spawnPacketHandler(shadow::spawn);
            pipeline.despawnPacketHandler(shadow::remove);
            pipeline.hidePacketHandler(shadow::remove);
            pipeline.showPacketHandler(shadow::spawn);
        });
        pipeline.hideFilter(p -> !p.canSee(registry.entity()));
        pipeline.defaultPosition(FunctionUtil.throttleTick(() -> adapter.passengerPosition().mul(-1.0f)));
        pipeline.scale(scale2);
        Function<Quaternionf, Quaternionf> headRotator = r -> r.mul((Quaternionfc)MathUtil.toQuaternion(this.bodyRotator.headRotation()));
        pipeline.addRotationModifier(BonePredicate.of(BonePredicate.State.NOT_SET, r -> r.name().tagged(BoneTags.HEAD)), headRotator);
        pipeline.addRotationModifier(BonePredicate.of(BonePredicate.State.TRUE, r -> r.name().tagged(BoneTags.HEAD_WITH_CHILDREN)), headRotator);
        FloatSupplier damageTickProvider = FunctionUtil.throttleTickFloat(adapter::damageTick);
        BooleanSupplier walkSupplier = FunctionUtil.throttleTickBoolean(() -> adapter.onWalk() || (double)damageTickProvider.getAsFloat() > 0.25 || pipeline.bones().stream().anyMatch(e -> {
            HitBox hitBox = e.getHitBox();
            return hitBox != null && hitBox.onWalk();
        }));
        FloatSupplier walkSpeedSupplier = modifier.damageAnimation() ? FunctionUtil.throttleTickFloat(() -> adapter.walkSpeed() + (float)Math.sqrt(damageTickProvider.getAsFloat())) : null;
        this.animate("walk", new AnimationModifier(walkSupplier, 6, 0, AnimationIterator.Type.LOOP, walkSpeedSupplier));
        this.animate("idle_fly", new AnimationModifier(adapter::fly, 6, 0, AnimationIterator.Type.LOOP, null));
        this.animate("walk_fly", new AnimationModifier(() -> adapter.fly() && walkSupplier.getAsBoolean(), 6, 0, AnimationIterator.Type.LOOP, walkSpeedSupplier));
        this.animate("spawn", AnimationModifier.DEFAULT_WITH_PLAY_ONCE);
        this.createNametag(CREATE_NAMETAG_PREDICATE, (bone, tag) -> {
            if (bone.name().tagged(BoneTags.PLAYER_TAG)) {
                tag.alwaysVisible(true);
            } else if (bone.name().tagged(BoneTags.MOB_TAG)) {
                tag.alwaysVisible(false);
            } else {
                tag.alwaysVisible(entity instanceof Player);
            }
            tag.component(adapter.customName());
        });
        BetterModel.plugin().scheduler().task(entity, () -> {
            if (this.isClosed()) {
                return;
            }
            this.createHitBox(CREATE_HITBOX_PREDICATE, HitBoxListener.EMPTY);
        });
        this.tick((t, s) -> this.updateBaseEntity0());
        this.tick((t, s) -> {
            if (this.damageTint.getAndDecrement() == 0L) {
                this.tint(-1);
            }
        });
        this.rotation(this.bodyRotator::bodyRotation);
        preUpdateConsumer.accept(this);
        EventUtil.call(new CreateEntityTrackerEvent(this));
    }

    @Override
    @NotNull
    public ModelRotation rotation() {
        return this.registry.adapter().dead() ? this.pipeline.getRotation() : super.rotation();
    }

    public void updateBaseEntity() {
        BetterModel.plugin().scheduler().asyncTaskLater(1L, () -> {
            this.updateBaseEntity0();
            this.forceUpdate(true);
        });
    }

    private void updateBaseEntity0() {
        Location loc = this.location();
        this.displays().forEach(d -> {
            d.syncEntity(this.registry.adapter());
            d.syncPosition(loc);
        });
    }

    @NotNull
    public EntityTrackerRegistry registry() {
        return this.registry;
    }

    public boolean createHitBox(@NotNull BonePredicate predicate, @Nullable HitBoxListener listener) {
        HitBoxListener.Builder builder = listener != null ? listener.toBuilder() : HitBoxListener.builder();
        return this.createHitBox(this.registry.adapter(), predicate, builder.mount((h, e) -> {
            this.registry.mountedHitBoxCache.put(e.getUniqueId(), new EntityTrackerRegistry.MountedHitBox((Entity)e, (HitBox)h));
            EventUtil.call(new MountModelEvent(this, (HitBox)h, (Entity)e));
        }).dismount((h, e) -> {
            this.registry.mountedHitBoxCache.remove(e.getUniqueId());
            EventUtil.call(new DismountModelEvent(this, (HitBox)h, (Entity)e));
        }).build());
    }

    public int damageTintValue() {
        return this.damageTintValue.get();
    }

    public void damageTintValue(int tint) {
        this.damageTintValue.set(tint);
    }

    public void damageTint() {
        if (!this.modifier().damageTint()) {
            return;
        }
        long get = this.damageTint.get();
        if (get <= 0L && this.damageTint.compareAndSet(get, 10L)) {
            this.task(() -> this.tint(this.damageTintValue()));
        }
    }

    @Override
    public void despawn() {
        if (this.registry.adapter().dead()) {
            this.close(Tracker.CloseReason.DESPAWN);
            return;
        }
        super.despawn();
    }

    @Override
    @NotNull
    public Location location() {
        return this.sourceEntity().getLocation();
    }

    @NotNull
    public Entity sourceEntity() {
        return this.registry.entity();
    }

    public void moveDuration(int duration) {
        this.pipeline.iterateTree(b -> b.moveDuration(duration));
        this.forceUpdate(true);
    }

    public void cancelDamageTint() {
        this.damageTint.set(-1L);
    }

    @ApiStatus.Internal
    public void refresh() {
        this.updateBaseEntity0();
        BetterModel.plugin().scheduler().task(this.registry.entity(), () -> this.createHitBox(HITBOX_REFRESH_PREDICATE, null));
    }

    public boolean markPlayerForSpawn(@NotNull OfflinePlayer player) {
        return this.markForSpawn.add(player.getUniqueId());
    }

    public boolean markPlayerForSpawn(@NotNull Set<UUID> uuids) {
        return this.markForSpawn.addAll(uuids);
    }

    public boolean unmarkPlayerForSpawn(@NotNull OfflinePlayer player) {
        return this.markForSpawn.remove(player.getUniqueId());
    }

    @NotNull
    public TrackerData asTrackerData() {
        return new TrackerData(this.name(), this.scaler, this.rotator, this.modifier, this.bodyRotator.createData(), this.hideOption, this.markForSpawn);
    }

    @NotNull
    public EntityBodyRotator bodyRotator() {
        return this.bodyRotator;
    }

    public boolean canBeSpawnedAt(@NotNull OfflinePlayer player) {
        return this.markForSpawn.isEmpty() || this.markForSpawn.contains(player.getUniqueId());
    }

    @NotNull
    public EntityHideOption hideOption() {
        return this.hideOption;
    }

    public void hideOption(@NotNull EntityHideOption hideOption) {
        this.hideOption = Objects.requireNonNull(hideOption);
    }

    public boolean canBeSaved() {
        return this.pipeline.getParent().type().isCanBeSaved();
    }
}

