/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.tracker;

import com.google.gson.annotations.SerializedName;
import kr.toxicity.model.api.util.EntityUtil;
import org.jetbrains.annotations.NotNull;

public record TrackerModifier(@SerializedName(value="sight-trace") boolean sightTrace, @SerializedName(value="damage-animation") boolean damageAnimation, @SerializedName(value="damage-tint") boolean damageTint, @SerializedName(value="view-range") float viewRange) {
    public static final TrackerModifier DEFAULT = new TrackerModifier(true, true, true, EntityUtil.ENTITY_MODEL_VIEW_RADIUS);

    @NotNull
    public static Builder builder() {
        return DEFAULT.toBuilder();
    }

    @NotNull
    public Builder toBuilder() {
        return new Builder(this);
    }

    public static final class Builder {
        private boolean sightTrace;
        private boolean damageAnimation;
        private boolean damageTint;
        private float viewRange;

        private Builder(@NotNull TrackerModifier modifier) {
            this.sightTrace = modifier.sightTrace;
            this.damageAnimation = modifier.damageAnimation;
            this.damageTint = modifier.damageTint;
            this.viewRange = modifier.viewRange;
        }

        @NotNull
        public Builder sightTrace(boolean sightTrace) {
            this.sightTrace = sightTrace;
            return this;
        }

        @NotNull
        public Builder damageAnimation(boolean damageAnimation) {
            this.damageAnimation = damageAnimation;
            return this;
        }

        @NotNull
        public Builder damageTint(boolean damageTint) {
            this.damageTint = damageTint;
            return this;
        }

        @NotNull
        public Builder viewRange(float viewRange) {
            this.viewRange = viewRange;
            return this;
        }

        @NotNull
        public TrackerModifier build() {
            return new TrackerModifier(this.sightTrace, this.damageAnimation, this.damageTint, this.viewRange);
        }
    }
}

