/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.manager;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.awt.image.BufferedImage;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import kr.toxicity.model.api.animation.AnimationModifier;
import kr.toxicity.model.api.bone.BoneItemMapper;
import kr.toxicity.model.api.bone.BoneName;
import kr.toxicity.model.api.bone.BoneTagRegistry;
import kr.toxicity.model.api.bone.BoneTags;
import kr.toxicity.model.api.config.DebugConfig;
import kr.toxicity.model.api.data.blueprint.BlueprintAnimation;
import kr.toxicity.model.api.data.blueprint.BlueprintChildren;
import kr.toxicity.model.api.data.blueprint.BlueprintImage;
import kr.toxicity.model.api.data.blueprint.BlueprintJson;
import kr.toxicity.model.api.data.blueprint.BlueprintTexture;
import kr.toxicity.model.api.data.blueprint.ModelBlueprint;
import kr.toxicity.model.api.data.blueprint.NamedBoundingBox;
import kr.toxicity.model.api.data.renderer.ModelRenderer;
import kr.toxicity.model.api.data.renderer.RendererGroup;
import kr.toxicity.model.api.event.ModelImportedEvent;
import kr.toxicity.model.api.manager.ModelManager;
import kr.toxicity.model.api.pack.PackBuilder;
import kr.toxicity.model.api.pack.PackZipper;
import kr.toxicity.model.api.tracker.EntityTracker;
import kr.toxicity.model.manager.GlobalManager;
import kr.toxicity.model.manager.ModelManagerImpl;
import kr.toxicity.model.manager.ReloadPipeline;
import kr.toxicity.model.shaded.kotlin.Metadata;
import kr.toxicity.model.shaded.kotlin.Pair;
import kr.toxicity.model.shaded.kotlin.TuplesKt;
import kr.toxicity.model.shaded.kotlin.Unit;
import kr.toxicity.model.shaded.kotlin.collections.CollectionsKt;
import kr.toxicity.model.shaded.kotlin.collections.MapsKt;
import kr.toxicity.model.shaded.kotlin.comparisons.ComparisonsKt;
import kr.toxicity.model.shaded.kotlin.enums.EnumEntries;
import kr.toxicity.model.shaded.kotlin.enums.EnumEntriesKt;
import kr.toxicity.model.shaded.kotlin.io.path.PathsKt;
import kr.toxicity.model.shaded.kotlin.jdk7.AutoCloseableKt;
import kr.toxicity.model.shaded.kotlin.jvm.functions.Function1;
import kr.toxicity.model.shaded.kotlin.jvm.functions.Function2;
import kr.toxicity.model.shaded.kotlin.jvm.internal.Intrinsics;
import kr.toxicity.model.shaded.kotlin.jvm.internal.SourceDebugExtension;
import kr.toxicity.model.shaded.kotlin.ranges.RangesKt;
import kr.toxicity.model.shaded.kotlin.sequences.SequencesKt;
import kr.toxicity.model.util.EventsKt;
import kr.toxicity.model.util.FilesKt;
import kr.toxicity.model.util.GsonsKt;
import kr.toxicity.model.util.ImagesKt;
import kr.toxicity.model.util.PluginsKt;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00b2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u00012\u00020\u0002:\u0002?@B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0011\u001a\u00020\u0012H\u0016J&\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J:\u0010\u001c\u001a\u00020\u00122\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u000b0\u001e2\u0006\u0010\u0016\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0002J\u0018\u0010#\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0018\u0010$\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0012\u0010%\u001a\u00020&*\b\u0012\u0004\u0012\u00020'0\u0014H\u0002J\f\u0010%\u001a\u00020&*\u00020'H\u0002J2\u0010(\u001a\u00020\u000b*\u00020)2\u0006\u0010 \u001a\u00020!2\u0006\u0010*\u001a\u00020+2\u0014\u0010,\u001a\u0010\u0012\u0004\u0012\u00020.\u0012\u0006\u0012\u0004\u0018\u00010/0-H\u0002J\u0012\u0010\"\u001a\u0004\u0018\u00010\u000b2\u0006\u00100\u001a\u00020\u0006H\u0016J\u000e\u00101\u001a\b\u0012\u0004\u0012\u00020\u000b02H\u0016J\u000e\u00103\u001a\b\u0012\u0004\u0012\u00020\u000604H\u0016J\u0012\u00105\u001a\u0004\u0018\u00010\u000b2\u0006\u00100\u001a\u00020\u0006H\u0016J\u000e\u00106\u001a\b\u0012\u0004\u0012\u00020\u000b02H\u0016J\u000e\u00107\u001a\b\u0012\u0004\u0012\u00020\u000604H\u0016J(\u00108\u001a\u0002092\u0006\u0010:\u001a\u00020;2\u0006\u0010\"\u001a\u00020\u00062\u0006\u0010<\u001a\u00020\u00062\u0006\u0010=\u001a\u00020>H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082.\u00a2\u0006\u0002\n\u0000R*\u0010\t\u001a\u001e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u000b0\nj\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u000b`\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u000b0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u000f\u001a\u001e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u000b0\nj\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u000b`\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u000b0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006A"}, d2={"Lkr/toxicity/model/manager/ModelManagerImpl;", "Lkr/toxicity/model/api/manager/ModelManager;", "Lkr/toxicity/model/manager/GlobalManager;", "<init>", "()V", "MODERN_MODEL_ITEM_NAME", "", "itemModelNamespace", "Lorg/bukkit/NamespacedKey;", "generalModelMap", "Ljava/util/HashMap;", "Lkr/toxicity/model/api/data/renderer/ModelRenderer;", "Lkr/toxicity/model/shaded/kotlin/collections/HashMap;", "generalModelView", "", "playerModelMap", "playerModelView", "start", "", "importModels", "", "Lkr/toxicity/model/manager/ModelManagerImpl$ImportedModel;", "pipeline", "Lkr/toxicity/model/manager/ReloadPipeline;", "zipper", "Lkr/toxicity/model/api/pack/PackZipper;", "dir", "Ljava/io/File;", "addModelTo", "targetMap", "", "Lkr/toxicity/model/manager/ModelManagerImpl$ModelPipeline;", "type", "Lkr/toxicity/model/api/data/renderer/ModelRenderer$Type;", "model", "loadModels", "reload", "toModernJson", "Lcom/google/gson/JsonObject;", "Lkr/toxicity/model/api/data/blueprint/BlueprintJson;", "toRenderer", "Lkr/toxicity/model/api/data/blueprint/ModelBlueprint;", "scale", "", "consumer", "Lkr/toxicity/model/shaded/kotlin/Function1;", "Lkr/toxicity/model/api/data/blueprint/BlueprintChildren$BlueprintGroup;", "", "name", "models", "", "modelKeys", "", "limb", "limbs", "limbKeys", "animate", "", "player", "Lorg/bukkit/entity/Player;", "animation", "modifier", "Lkr/toxicity/model/api/animation/AnimationModifier;", "ImportedModel", "ModelPipeline", "core"})
@SourceDebugExtension(value={"SMAP\nModelManagerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModelManagerImpl.kt\nkr/toxicity/model/manager/ModelManagerImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 Plugins.kt\nkr/toxicity/model/util/PluginsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 6 Files.kt\nkr/toxicity/model/util/FilesKt\n*L\n1#1,286:1\n1869#2,2:287\n1869#2:290\n1870#2:293\n1563#2:307\n1634#2,3:308\n1803#2,3:311\n808#2,11:314\n1193#2,2:325\n1267#2,4:327\n1869#2,2:333\n808#2,11:335\n1193#2,2:346\n1267#2,4:348\n608#3:289\n21#4,2:291\n21#4,2:331\n1#5:294\n9#6,6:295\n9#6,6:301\n*S KotlinDebug\n*F\n+ 1 ModelManagerImpl.kt\nkr/toxicity/model/manager/ModelManagerImpl\n*L\n40#1:287,2\n103#1:290\n103#1:293\n226#1:307\n226#1:308,3\n226#1:311,3\n263#1:314,11\n264#1:325,2\n264#1:327,4\n116#1:333,2\n255#1:335,11\n256#1:346,2\n256#1:348,4\n89#1:289\n136#1:291,2\n70#1:331,2\n202#1:295,6\n210#1:301,6\n*E\n"})
public final class ModelManagerImpl
implements ModelManager,
GlobalManager {
    @NotNull
    public static final ModelManagerImpl INSTANCE = new ModelManagerImpl();
    @NotNull
    private static final String MODERN_MODEL_ITEM_NAME = "bm_models";
    private static NamespacedKey itemModelNamespace;
    @NotNull
    private static final HashMap<String, ModelRenderer> generalModelMap;
    @NotNull
    private static final Map<String, ModelRenderer> generalModelView;
    @NotNull
    private static final HashMap<String, ModelRenderer> playerModelMap;
    @NotNull
    private static final Map<String, ModelRenderer> playerModelView;

    private ModelManagerImpl() {
    }

    @Override
    public void start() {
        Iterable $this$forEach$iv = EntriesMappings.entries$0;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            BoneTags it = (BoneTags)element$iv;
            boolean bl = false;
            BoneTagRegistry.addTag(it);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final List<ImportedModel> importModels(ReloadPipeline pipeline, PackZipper zipper, File dir) {
        void $this$sortedBy$iv;
        List<Object> list;
        ConcurrentHashMap modelFileMap = new ConcurrentHashMap();
        PackBuilder packBuilder = zipper.assets().bettermodel().textures();
        Intrinsics.checkNotNullExpressionValue(packBuilder, "textures(...)");
        PackBuilder textures = packBuilder;
        Object object = FilesKt.fileTreeList(dir);
        Throwable throwable = null;
        try {
            Stream stream = (Stream)object;
            boolean bl = false;
            list = stream.filter(arg_0 -> ModelManagerImpl.importModels$lambda$3$lambda$2(ModelManagerImpl::importModels$lambda$3$lambda$1, arg_0)).toList();
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)object, throwable);
        }
        List<Object> targetFolder = list;
        pipeline.setStatus("Importing models...");
        pipeline.goal(targetFolder.size());
        Intrinsics.checkNotNull(targetFolder);
        pipeline.forEachParallel(targetFolder, importModels.1.INSTANCE, arg_0 -> ModelManagerImpl.importModels$lambda$13(modelFileMap, pipeline, textures, arg_0));
        Collection collection = modelFileMap.values();
        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
        object = CollectionsKt.asSequence(collection);
        boolean $i$f$sortedBy = false;
        return SequencesKt.toList(SequencesKt.map(SequencesKt.sortedWith($this$sortedBy$iv, new Comparator(){

            public final int compare(T a, T b) {
                Pair it = (Pair)a;
                boolean bl = false;
                Comparable comparable = (Path)it.getFirst();
                it = (Pair)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues(comparable2, (Comparable)((Path)it.getFirst()));
            }
        }), ModelManagerImpl::importModels$lambda$15));
    }

    /*
     * WARNING - void declaration
     */
    private final void addModelTo(Map<String, ModelRenderer> targetMap, ModelPipeline pipeline, ModelRenderer.Type type, List<ImportedModel> model) {
        long l;
        Float f;
        Iterator iterator2 = ((Iterable)model).iterator();
        if (!iterator2.hasNext()) {
            f = null;
        } else {
            ImportedModel it22 = (ImportedModel)iterator2.next();
            boolean bl = false;
            float it22 = it22.getBlueprint().scale();
            while (iterator2.hasNext()) {
                ImportedModel it32 = (ImportedModel)iterator2.next();
                $i$a$-maxOfOrNull-ModelManagerImpl$addModelTo$maxScale$1 = false;
                float it32 = it32.getBlueprint().scale();
                it22 = Math.max(it22, it32);
            }
            f = Float.valueOf(it22);
        }
        float maxScale = f != null ? f.floatValue() : 1.0f;
        Iterable $this$forEach$iv = model;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ModelRenderer modelRenderer;
            ImportedModel importedModel = (ImportedModel)element$iv;
            boolean bl = false;
            long size = importedModel.getJsonSize();
            ModelBlueprint load = importedModel.getBlueprint();
            Map<String, ModelRenderer> map = targetMap;
            String string = load.name();
            ModelRenderer $this$addModelTo_u24lambda_u2425_u24lambda_u2424 = modelRenderer = INSTANCE.toRenderer(load, type, maxScale, arg_0 -> ModelManagerImpl.addModelTo$lambda$25$lambda$22(load, pipeline, maxScale, size, arg_0));
            boolean bl2 = false;
            boolean $i$f$debugPack = false;
            if (PluginsKt.getCONFIG().debug().has(DebugConfig.DebugOption.PACK)) {
                String[] stringArray = new String[1];
                String string2 = Thread.currentThread().getName();
                int n = 0;
                String[] stringArray2 = stringArray;
                boolean bl3 = false;
                String string3 = "This model was successfully imported: " + load.name();
                stringArray2[n] = "[" + string2 + "] " + string3;
                PluginsKt.info(stringArray);
            }
            EventsKt.call(new ModelImportedEvent($this$addModelTo_u24lambda_u2425_u24lambda_u2424));
            map.put(string, modelRenderer);
        }
        Iterable iterable = model;
        long l2 = pipeline.getEstimatedSize();
        ModelPipeline modelPipeline = pipeline;
        long l3 = 0L;
        for (Object t : iterable) {
            void it;
            ImportedModel bl = (ImportedModel)t;
            l = l3;
            boolean bl4 = false;
            long l4 = it.getJsonSize();
            l3 = l + l4;
        }
        l = l3;
        modelPipeline.setEstimatedSize(l2 + l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void loadModels(ReloadPipeline pipeline, PackZipper zipper) {
        AutoCloseable autoCloseable = new ModelPipeline(zipper);
        Throwable throwable = null;
        try {
            Unit unit;
            File folder;
            ModelManagerImpl modelManagerImpl;
            Map map;
            ModelPipeline modelPipeline;
            ModelRenderer.Type type;
            ModelManagerImpl modelManagerImpl2;
            ReloadPipeline reloadPipeline;
            PackZipper packZipper;
            boolean bl;
            File target$iv;
            File $this$getOrCreateDirectory$iv;
            File file;
            boolean $i$f$getOrCreateDirectory;
            String name$iv;
            ModelPipeline it = (ModelPipeline)autoCloseable;
            boolean bl2 = false;
            if (PluginsKt.getCONFIG().module().model()) {
                ModelManagerImpl modelManagerImpl3 = INSTANCE;
                Map map2 = generalModelMap;
                ModelPipeline modelPipeline2 = it;
                ModelRenderer.Type type2 = ModelRenderer.Type.GENERAL;
                ModelManagerImpl modelManagerImpl4 = INSTANCE;
                ReloadPipeline reloadPipeline2 = pipeline;
                PackZipper packZipper2 = zipper;
                File file2 = PluginsKt.getDATA_FOLDER();
                name$iv = "models";
                $i$f$getOrCreateDirectory = false;
                target$iv = file = new File($this$getOrCreateDirectory$iv, name$iv);
                bl = false;
                if (!target$iv.exists()) {
                    target$iv.mkdirs();
                    File file3 = target$iv;
                    packZipper = packZipper2;
                    reloadPipeline = reloadPipeline2;
                    modelManagerImpl2 = modelManagerImpl4;
                    type = type2;
                    modelPipeline = modelPipeline2;
                    map = map2;
                    modelManagerImpl = modelManagerImpl3;
                    boolean bl3 = false;
                    if (PluginsKt.getPLUGIN().version().useModernResource()) {
                        FilesKt.addResource(folder, "demon_knight.bbmodel");
                    }
                    unit = Unit.INSTANCE;
                    modelManagerImpl3 = modelManagerImpl;
                    map2 = map;
                    modelPipeline2 = modelPipeline;
                    type2 = type;
                    modelManagerImpl4 = modelManagerImpl2;
                    reloadPipeline2 = reloadPipeline;
                    packZipper2 = packZipper;
                }
                modelManagerImpl3.addModelTo(map2, modelPipeline2, type2, modelManagerImpl4.importModels(reloadPipeline2, packZipper2, file));
            }
            if (PluginsKt.getCONFIG().module().playerAnimation()) {
                ModelManagerImpl modelManagerImpl5 = INSTANCE;
                Map map3 = playerModelMap;
                ModelPipeline modelPipeline3 = it;
                ModelRenderer.Type type3 = ModelRenderer.Type.PLAYER;
                ModelManagerImpl modelManagerImpl6 = INSTANCE;
                ReloadPipeline reloadPipeline3 = pipeline;
                PackZipper packZipper3 = zipper;
                $this$getOrCreateDirectory$iv = PluginsKt.getDATA_FOLDER();
                name$iv = "players";
                $i$f$getOrCreateDirectory = false;
                target$iv = file = new File($this$getOrCreateDirectory$iv, name$iv);
                bl = false;
                if (!target$iv.exists()) {
                    target$iv.mkdirs();
                    folder = target$iv;
                    packZipper = packZipper3;
                    reloadPipeline = reloadPipeline3;
                    modelManagerImpl2 = modelManagerImpl6;
                    type = type3;
                    modelPipeline = modelPipeline3;
                    map = map3;
                    modelManagerImpl = modelManagerImpl5;
                    boolean bl4 = false;
                    FilesKt.addResource(folder, "steve.bbmodel");
                    unit = Unit.INSTANCE;
                    modelManagerImpl5 = modelManagerImpl;
                    map3 = map;
                    modelPipeline3 = modelPipeline;
                    type3 = type;
                    modelManagerImpl6 = modelManagerImpl2;
                    reloadPipeline3 = reloadPipeline;
                    packZipper3 = packZipper;
                }
                modelManagerImpl5.addModelTo(map3, modelPipeline3, type3, modelManagerImpl6.importModels(reloadPipeline3, packZipper3, file));
            }
            Unit unit2 = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally(autoCloseable, throwable);
        }
    }

    @Override
    public void reload(@NotNull ReloadPipeline pipeline, @NotNull PackZipper zipper) {
        Intrinsics.checkNotNullParameter(pipeline, "pipeline");
        Intrinsics.checkNotNullParameter(zipper, "zipper");
        itemModelNamespace = new NamespacedKey(PluginsKt.getCONFIG().namespace(), MODERN_MODEL_ITEM_NAME);
        generalModelMap.clear();
        playerModelMap.clear();
        this.loadModels(pipeline, zipper);
    }

    /*
     * WARNING - void declaration
     */
    private final JsonObject toModernJson(List<BlueprintJson> $this$toModernJson) {
        JsonObject jsonObject;
        if ($this$toModernJson.size() == 1) {
            jsonObject = this.toModernJson($this$toModernJson.get(0));
        } else {
            void $this$fold$iv;
            void initial$iv;
            Collection<JsonObject> collection;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            Pair[] pairArray = new Pair[2];
            pairArray[0] = TuplesKt.to("type", "minecraft:composite");
            Iterable iterable = $this$toModernJson;
            String string = "models";
            int n = 1;
            Pair[] pairArray2 = pairArray;
            boolean $i$f$map22 = false;
            void var5_9 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                BlueprintJson blueprintJson = (BlueprintJson)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(INSTANCE.toModernJson((BlueprintJson)it));
            }
            collection = (List)destination$iv$iv;
            $this$map$iv = collection;
            JsonArray $i$f$map22 = new JsonArray($this$toModernJson.size());
            boolean $i$f$fold = false;
            void accumulator$iv = initial$iv;
            for (Object element$iv : $this$fold$iv) {
                void element;
                void var12_19;
                Object item$iv$iv;
                item$iv$iv = (JsonObject)element$iv;
                void array = accumulator$iv;
                boolean bl = false;
                void $this$toModernJson_u24lambda_u2432_u24lambda_u2431 = var12_19 = array;
                boolean bl2 = false;
                $this$toModernJson_u24lambda_u2432_u24lambda_u2431.add((JsonElement)element);
                accumulator$iv = var12_19;
            }
            collection = accumulator$iv;
            pairArray2[n] = TuplesKt.to(string, collection);
            jsonObject = GsonsKt.jsonObjectOf(pairArray);
        }
        return jsonObject;
    }

    private final JsonObject toModernJson(BlueprintJson $this$toModernJson) {
        Pair[] pairArray = new Pair[3];
        pairArray[0] = TuplesKt.to("type", "minecraft:model");
        pairArray[1] = TuplesKt.to("model", PluginsKt.getCONFIG().namespace() + ":modern_item/" + $this$toModernJson.name());
        Object[] objectArray = new Object[1];
        Pair[] pairArray2 = new Pair[]{TuplesKt.to("type", "minecraft:custom_model_data"), TuplesKt.to("default", 0xFFFFFF)};
        objectArray[0] = GsonsKt.jsonObjectOf(pairArray2);
        pairArray[2] = TuplesKt.to("tints", GsonsKt.jsonArrayOf(objectArray));
        return GsonsKt.jsonObjectOf(pairArray);
    }

    /*
     * WARNING - void declaration
     */
    private final ModelRenderer toRenderer(ModelBlueprint $this$toRenderer, ModelRenderer.Type type, float scale2, Function1<? super BlueprintChildren.BlueprintGroup, Integer> consumer) {
        void $this$associateTo$iv$iv;
        void $this$associate$iv;
        void $this$filterIsInstanceTo$iv$iv;
        Iterable $this$filterIsInstance$iv;
        List<BlueprintChildren> list = $this$toRenderer.group();
        Intrinsics.checkNotNullExpressionValue(list, "group(...)");
        Iterable iterable = list;
        ModelBlueprint modelBlueprint = $this$toRenderer;
        ModelRenderer.Type type2 = type;
        boolean $i$f$filterIsInstance = false;
        void var7_9 = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof BlueprintChildren.BlueprintGroup)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Object object = (List)destination$iv$iv;
        $this$filterIsInstance$iv = (Iterable)object;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associate$iv, 10)), 16);
        destination$iv$iv = $this$associate$iv;
        Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv2;
            BlueprintChildren.BlueprintGroup it = (BlueprintChildren.BlueprintGroup)element$iv$iv;
            boolean bl = false;
            Pair<BoneName, RendererGroup> pair = TuplesKt.to(it.name(), ModelManagerImpl.toRenderer$parse(it, scale2, consumer));
            map.put(pair.getFirst(), pair.getSecond());
        }
        object = destination$iv$iv2;
        Map<String, BlueprintAnimation> map = $this$toRenderer.animations();
        Object object2 = object;
        ModelBlueprint modelBlueprint2 = modelBlueprint;
        ModelRenderer.Type type3 = type2;
        return new ModelRenderer(type3, modelBlueprint2, (Map<BoneName, RendererGroup>)object2, map);
    }

    @Override
    @Nullable
    public ModelRenderer model(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        return generalModelView.get(name);
    }

    @Override
    @NotNull
    public Collection<ModelRenderer> models() {
        return generalModelView.values();
    }

    @Override
    @NotNull
    public Set<String> modelKeys() {
        return generalModelView.keySet();
    }

    @Override
    @Nullable
    public ModelRenderer limb(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        return playerModelView.get(name);
    }

    @Override
    @NotNull
    public Collection<ModelRenderer> limbs() {
        return playerModelView.values();
    }

    @Override
    @NotNull
    public Set<String> limbKeys() {
        return playerModelView.keySet();
    }

    @Override
    public boolean animate(@NotNull Player player, @NotNull String model, @NotNull String animation, @NotNull AnimationModifier modifier) {
        boolean bl;
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(model, "model");
        Intrinsics.checkNotNullParameter(animation, "animation");
        Intrinsics.checkNotNullParameter(modifier, "modifier");
        ModelRenderer modelRenderer = playerModelView.get(model);
        if (modelRenderer != null) {
            ModelRenderer it = modelRenderer;
            boolean bl2 = false;
            EntityTracker entityTracker = it.getOrCreate((Entity)player);
            Intrinsics.checkNotNullExpressionValue(entityTracker, "getOrCreate(...)");
            EntityTracker create2 = entityTracker;
            boolean success = create2.animate(animation, modifier, () -> ModelManagerImpl.animate$lambda$39$lambda$38(create2));
            if (!success) {
                create2.close();
            }
            bl = success;
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    public void end() {
        GlobalManager.super.end();
    }

    private static final boolean importModels$lambda$3$lambda$1(Path it) {
        Intrinsics.checkNotNull(it);
        return Intrinsics.areEqual(PathsKt.getExtension(it), "bbmodel");
    }

    private static final boolean importModels$lambda$3$lambda$2(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final byte[] importModels$lambda$13$lambda$11$lambda$10$lambda$8$lambda$5(BlueprintImage $image) {
        BufferedImage bufferedImage = $image.image();
        Intrinsics.checkNotNullExpressionValue(bufferedImage, "image(...)");
        return ImagesKt.toByteArray(bufferedImage);
    }

    private static final byte[] importModels$lambda$13$lambda$11$lambda$10$lambda$8$lambda$7$lambda$6(JsonObject $meta) {
        return GsonsKt.toByteArray((JsonElement)$meta);
    }

    private static final Unit importModels$lambda$13$lambda$11$lambda$10$lambda$8(PackBuilder $textures, BlueprintImage image) {
        block0: {
            $textures.add(image.name() + ".png", image.estimatedSize(), () -> ModelManagerImpl.importModels$lambda$13$lambda$11$lambda$10$lambda$8$lambda$5(image));
            JsonObject jsonObject = image.mcmeta();
            if (jsonObject == null) break block0;
            JsonObject meta = jsonObject;
            boolean bl = false;
            $textures.add(image.name() + ".png.mcmeta", -1L, () -> ModelManagerImpl.importModels$lambda$13$lambda$11$lambda$10$lambda$8$lambda$7$lambda$6(meta));
        }
        return Unit.INSTANCE;
    }

    private static final void importModels$lambda$13$lambda$11$lambda$10$lambda$9(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    /*
     * WARNING - void declaration
     */
    private static final Pair importModels$lambda$13$lambda$11(ReloadPipeline $pipeline, ModelBlueprint $load, Path $it, PackBuilder $textures, String string, Pair v) {
        void $this$importModels_u24lambda_u2413_u24lambda_u2411_u24lambda_u2410;
        String[] stringArray;
        String[] stringArray2;
        Intrinsics.checkNotNullParameter(string, "<unused var>");
        $pipeline.progress();
        if (v != null) {
            String[] stringArray3 = new String[]{"Duplicate model name '" + $load.name() + "'.", "Duplicated file: " + (Path)$it, "And: " + v.getFirst()};
            PluginsKt.warn(stringArray3);
            return v;
        }
        boolean $i$f$debugPack = false;
        if (PluginsKt.getCONFIG().debug().has(DebugConfig.DebugOption.PACK)) {
            stringArray2 = new String[1];
            String string2 = Thread.currentThread().getName();
            int n = 0;
            stringArray = stringArray2;
            boolean bl = false;
            String string3 = "Model file successfully loaded: " + (Path)$it;
            stringArray[n] = "[" + string2 + "] " + string3;
            PluginsKt.info(stringArray2);
        }
        ModelBlueprint modelBlueprint = $load;
        stringArray2 = modelBlueprint;
        stringArray = $it;
        boolean bl = false;
        $this$importModels_u24lambda_u2413_u24lambda_u2411_u24lambda_u2410.buildImage().forEach(arg_0 -> ModelManagerImpl.importModels$lambda$13$lambda$11$lambda$10$lambda$9(arg_0 -> ModelManagerImpl.importModels$lambda$13$lambda$11$lambda$10$lambda$8($textures, arg_0), arg_0));
        return TuplesKt.to(stringArray, modelBlueprint);
    }

    private static final Pair importModels$lambda$13$lambda$12(Function2 $tmp0, Object p0, Object p1) {
        return (Pair)$tmp0.invoke(p0, p1);
    }

    private static final Unit importModels$lambda$13(ConcurrentHashMap $modelFileMap, ReloadPipeline $pipeline, PackBuilder $textures, Path it) {
        File file = it.toFile();
        Intrinsics.checkNotNullExpressionValue(file, "toFile(...)");
        ModelBlueprint modelBlueprint = GsonsKt.toTexturedModel(file);
        if (modelBlueprint == null) {
            String[] stringArray = new String[]{"This model file has unsupported element type (e.g., mesh): " + it};
            PluginsKt.warn(stringArray);
            return Unit.INSTANCE;
        }
        ModelBlueprint load = modelBlueprint;
        $modelFileMap.compute(load.name(), (arg_0, arg_1) -> ModelManagerImpl.importModels$lambda$13$lambda$12((arg_0, arg_1) -> ModelManagerImpl.importModels$lambda$13$lambda$11($pipeline, load, it, $textures, arg_0, arg_1), arg_0, arg_1));
        return Unit.INSTANCE;
    }

    private static final ImportedModel importModels$lambda$15(Pair it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return new ImportedModel(Files.size((Path)it.getFirst()), (ModelBlueprint)it.getSecond());
    }

    private static final byte[] addModelTo$lambda$25$lambda$22$lambda$19$lambda$18$lambda$17(BlueprintJson $json) {
        JsonElement jsonElement = $json.element();
        Intrinsics.checkNotNullExpressionValue(jsonElement, "element(...)");
        return GsonsKt.toByteArray(jsonElement);
    }

    private static final byte[] addModelTo$lambda$25$lambda$22$lambda$21$lambda$20(BlueprintJson $blueprint) {
        JsonElement jsonElement = $blueprint.element();
        Intrinsics.checkNotNullExpressionValue(jsonElement, "element(...)");
        return GsonsKt.toByteArray(jsonElement);
    }

    private static final Integer addModelTo$lambda$25$lambda$22(ModelBlueprint $load, ModelPipeline $pipeline, float $maxScale, long $size, BlueprintChildren.BlueprintGroup blueprintGroup) {
        boolean success;
        block3: {
            Pair[] pairArray;
            Intrinsics.checkNotNullParameter(blueprintGroup, "blueprintGroup");
            if (!$load.hasTexture()) {
                return null;
            }
            success = false;
            int index = $pipeline.getIndexer().get();
            List<BlueprintJson> list = blueprintGroup.buildModernJson($maxScale, $load);
            if (list != null) {
                List<BlueprintJson> modernBlueprint = list;
                boolean bl = false;
                pairArray = new Pair[]{TuplesKt.to("threshold", index), TuplesKt.to("model", INSTANCE.toModernJson(modernBlueprint))};
                $pipeline.getModernModel().getEntries().add((JsonElement)GsonsKt.jsonObjectOf(pairArray));
                Iterable $this$forEach$iv = modernBlueprint;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    BlueprintJson json = (BlueprintJson)element$iv;
                    boolean bl2 = false;
                    $pipeline.getModernModel().getPack().add(json.name() + ".json", $size / (long)modernBlueprint.size(), () -> ModelManagerImpl.addModelTo$lambda$25$lambda$22$lambda$19$lambda$18$lambda$17(json));
                }
                success = true;
            }
            BlueprintJson blueprintJson = blueprintGroup.buildLegacyJson(PluginsKt.getPLUGIN().version().useModernResource(), $maxScale, $load);
            if (blueprintJson == null) break block3;
            BlueprintJson blueprint = blueprintJson;
            boolean bl = false;
            pairArray = new Pair[2];
            Pair[] pairArray2 = new Pair[]{TuplesKt.to("custom_model_data", index)};
            pairArray[0] = TuplesKt.to("predicate", GsonsKt.jsonObjectOf(pairArray2));
            pairArray[1] = TuplesKt.to("model", PluginsKt.getCONFIG().namespace() + ":item/" + blueprint.name());
            $pipeline.getLegacyModel().getEntries().add((JsonElement)GsonsKt.jsonObjectOf(pairArray));
            $pipeline.getLegacyModel().getPack().add(blueprint.name() + ".json", $size, () -> ModelManagerImpl.addModelTo$lambda$25$lambda$22$lambda$21$lambda$20(blueprint));
            success = true;
        }
        return success ? Integer.valueOf($pipeline.getIndexer().getAndIncrement()) : null;
    }

    /*
     * WARNING - void declaration
     */
    private static final RendererGroup toRenderer$parse(BlueprintChildren.BlueprintGroup $this$toRenderer_u24parse, float $scale, Function1<? super BlueprintChildren.BlueprintGroup, Integer> $consumer) {
        void $this$associateTo$iv$iv;
        void $this$associate$iv;
        void $this$filterIsInstanceTo$iv$iv;
        Iterable $this$filterIsInstance$iv;
        ItemStack itemStack;
        Object object;
        Object object2;
        BoneName boneName;
        float f;
        ItemStack itemStack2;
        BoneName boneName2 = $this$toRenderer_u24parse.name();
        float f2 = $scale;
        if ($this$toRenderer_u24parse.name().toItemMapper() != BoneItemMapper.EMPTY) {
            itemStack2 = null;
        } else {
            Integer n = $consumer.invoke($this$toRenderer_u24parse);
            if (n != null) {
                void i;
                void $this$toRenderer_u24parse_u24lambda_u2435_u24lambda_u2434_u24lambda_u2433;
                int n2 = ((Number)n).intValue();
                f = f2;
                boneName = boneName2;
                boolean bl = false;
                ItemStack itemStack3 = new ItemStack(PluginsKt.getCONFIG().item());
                ItemStack $this$toRenderer_u24parse_u24lambda_u2435_u24lambda_u2434 = itemStack3;
                boolean bl2 = false;
                ItemMeta itemMeta = $this$toRenderer_u24parse_u24lambda_u2435_u24lambda_u2434.getItemMeta();
                object2 = itemMeta;
                object = $this$toRenderer_u24parse_u24lambda_u2435_u24lambda_u2434;
                boolean bl3 = false;
                $this$toRenderer_u24parse_u24lambda_u2435_u24lambda_u2434_u24lambda_u2433.setCustomModelData(Integer.valueOf((int)i));
                if (PluginsKt.getPLUGIN().version().useItemModelName()) {
                    NamespacedKey namespacedKey = itemModelNamespace;
                    if (namespacedKey == null) {
                        Intrinsics.throwUninitializedPropertyAccessException("itemModelNamespace");
                        namespacedKey = null;
                    }
                    $this$toRenderer_u24parse_u24lambda_u2435_u24lambda_u2434_u24lambda_u2433.setItemModel(namespacedKey);
                }
                object.setItemMeta(itemMeta);
                itemStack = itemStack3;
                boneName2 = boneName;
                f2 = f;
                itemStack2 = itemStack;
            } else {
                itemStack2 = null;
            }
        }
        List<BlueprintChildren> list = $this$toRenderer_u24parse.children();
        Intrinsics.checkNotNullExpressionValue(list, "children(...)");
        Iterable iterable = list;
        BlueprintChildren.BlueprintGroup blueprintGroup = $this$toRenderer_u24parse;
        itemStack = itemStack2;
        f = f2;
        boneName = boneName2;
        boolean $i$f$filterIsInstance = false;
        void i = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof BlueprintChildren.BlueprintGroup)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Object object3 = (List)destination$iv$iv;
        $this$filterIsInstance$iv = (Iterable)object3;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associate$iv, 10)), 16);
        destination$iv$iv = $this$associate$iv;
        Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            object2 = destination$iv$iv2;
            BlueprintChildren.BlueprintGroup it = (BlueprintChildren.BlueprintGroup)element$iv$iv;
            boolean bl = false;
            object = TuplesKt.to(it.name(), ModelManagerImpl.toRenderer$parse(it, $scale, $consumer));
            object2.put(((Pair)object).getFirst(), ((Pair)object).getSecond());
        }
        object3 = destination$iv$iv2;
        NamedBoundingBox namedBoundingBox = $this$toRenderer_u24parse.hitBox();
        Object object4 = object3;
        BlueprintChildren.BlueprintGroup blueprintGroup2 = blueprintGroup;
        ItemStack itemStack4 = itemStack;
        float f3 = f;
        BoneName boneName3 = boneName;
        return new RendererGroup(boneName3, f3, itemStack4, blueprintGroup2, (Map<BoneName, RendererGroup>)object4, namedBoundingBox);
    }

    private static final void animate$lambda$39$lambda$38(EntityTracker $create) {
        $create.close();
    }

    static {
        generalModelMap = new HashMap();
        generalModelView = kr.toxicity.model.util.CollectionsKt.toImmutableView(generalModelMap);
        playerModelMap = new HashMap();
        playerModelView = kr.toxicity.model.util.CollectionsKt.toImmutableView(playerModelMap);
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class EntriesMappings {
        public static final /* synthetic */ EnumEntries<BoneTags> entries$0;

        static {
            entries$0 = EnumEntriesKt.enumEntries((Enum[])BoneTags.values());
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\t\u00a8\u0006\u0018"}, d2={"Lkr/toxicity/model/manager/ModelManagerImpl$ImportedModel;", "", "size", "", "blueprint", "Lkr/toxicity/model/api/data/blueprint/ModelBlueprint;", "<init>", "(JLkr/toxicity/model/api/data/blueprint/ModelBlueprint;)V", "getSize", "()J", "getBlueprint", "()Lkr/toxicity/model/api/data/blueprint/ModelBlueprint;", "jsonSize", "getJsonSize", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "core"})
    private static final class ImportedModel {
        private final long size;
        @NotNull
        private final ModelBlueprint blueprint;
        private final long jsonSize;

        /*
         * WARNING - void declaration
         */
        public ImportedModel(long size, @NotNull ModelBlueprint blueprint) {
            int n;
            Intrinsics.checkNotNullParameter(blueprint, "blueprint");
            this.size = size;
            this.blueprint = blueprint;
            List<BlueprintTexture> list = this.blueprint.textures();
            Intrinsics.checkNotNullExpressionValue(list, "textures(...)");
            Iterable iterable = list;
            long l = this.size;
            ImportedModel importedModel = this;
            int n2 = 0;
            for (Object t : iterable) {
                void it;
                BlueprintTexture blueprintTexture = (BlueprintTexture)t;
                n = n2;
                boolean bl = false;
                int n3 = it.image().getHeight() * it.image().getWidth() * 4;
                n2 = n + n3;
            }
            n = n2;
            importedModel.jsonSize = l - (long)n;
        }

        public final long getSize() {
            return this.size;
        }

        @NotNull
        public final ModelBlueprint getBlueprint() {
            return this.blueprint;
        }

        public final long getJsonSize() {
            return this.jsonSize;
        }

        public final long component1() {
            return this.size;
        }

        @NotNull
        public final ModelBlueprint component2() {
            return this.blueprint;
        }

        @NotNull
        public final ImportedModel copy(long size, @NotNull ModelBlueprint blueprint) {
            Intrinsics.checkNotNullParameter(blueprint, "blueprint");
            return new ImportedModel(size, blueprint);
        }

        public static /* synthetic */ ImportedModel copy$default(ImportedModel importedModel, long l, ModelBlueprint modelBlueprint, int n, Object object) {
            if ((n & 1) != 0) {
                l = importedModel.size;
            }
            if ((n & 2) != 0) {
                modelBlueprint = importedModel.blueprint;
            }
            return importedModel.copy(l, modelBlueprint);
        }

        @NotNull
        public String toString() {
            return "ImportedModel(size=" + this.size + ", blueprint=" + this.blueprint + ")";
        }

        public int hashCode() {
            int result = Long.hashCode(this.size);
            result = result * 31 + this.blueprint.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ImportedModel)) {
                return false;
            }
            ImportedModel importedModel = (ImportedModel)other;
            if (this.size != importedModel.size) {
                return false;
            }
            return Intrinsics.areEqual(this.blueprint, importedModel.blueprint);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00060\u0001j\u0002`\u0002:\u0001\u0019B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u0017\u001a\u00020\u0018H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000eR\u001a\u0010\u0011\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016\u00a8\u0006\u001a"}, d2={"Lkr/toxicity/model/manager/ModelManagerImpl$ModelPipeline;", "Ljava/lang/AutoCloseable;", "Lkr/toxicity/model/shaded/kotlin/AutoCloseable;", "zipper", "Lkr/toxicity/model/api/pack/PackZipper;", "<init>", "(Lkr/toxicity/model/api/pack/PackZipper;)V", "indexer", "Ljava/util/concurrent/atomic/AtomicInteger;", "getIndexer", "()Ljava/util/concurrent/atomic/AtomicInteger;", "legacyModel", "Lkr/toxicity/model/manager/ModelManagerImpl$ModelPipeline$ModelBuilder;", "getLegacyModel", "()Lkr/toxicity/model/manager/ModelManagerImpl$ModelPipeline$ModelBuilder;", "modernModel", "getModernModel", "estimatedSize", "", "getEstimatedSize", "()J", "setEstimatedSize", "(J)V", "close", "", "ModelBuilder", "core"})
    private static final class ModelPipeline
    implements AutoCloseable {
        @NotNull
        private final PackZipper zipper;
        @NotNull
        private final AtomicInteger indexer;
        @NotNull
        private final ModelBuilder legacyModel;
        @NotNull
        private final ModelBuilder modernModel;
        private long estimatedSize;

        public ModelPipeline(@NotNull PackZipper zipper) {
            Intrinsics.checkNotNullParameter(zipper, "zipper");
            this.zipper = zipper;
            this.indexer = new AtomicInteger(1);
            String[] stringArray = new String[]{"item"};
            PackBuilder packBuilder = this.zipper.legacy().bettermodel().models().resolve(stringArray);
            Intrinsics.checkNotNullExpressionValue(packBuilder, "resolve(...)");
            this.legacyModel = new ModelBuilder(packBuilder);
            stringArray = new String[]{"modern_item"};
            PackBuilder packBuilder2 = this.zipper.modern().bettermodel().models().resolve(stringArray);
            Intrinsics.checkNotNullExpressionValue(packBuilder2, "resolve(...)");
            this.modernModel = new ModelBuilder(packBuilder2);
        }

        @NotNull
        public final AtomicInteger getIndexer() {
            return this.indexer;
        }

        @NotNull
        public final ModelBuilder getLegacyModel() {
            return this.legacyModel;
        }

        @NotNull
        public final ModelBuilder getModernModel() {
            return this.modernModel;
        }

        public final long getEstimatedSize() {
            return this.estimatedSize;
        }

        public final void setEstimatedSize(long l) {
            this.estimatedSize = l;
        }

        @Override
        public void close() {
            String string = PluginsKt.getCONFIG().item().name().toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue(string, "toLowerCase(...)");
            String itemName = string;
            Pair[] pairArray = new Pair[1];
            Pair[] pairArray2 = new Pair[4];
            pairArray2[0] = TuplesKt.to("type", "range_dispatch");
            pairArray2[1] = TuplesKt.to("property", "custom_model_data");
            Pair[] pairArray3 = new Pair[]{TuplesKt.to("type", "minecraft:model"), TuplesKt.to("model", "minecraft:item/" + itemName)};
            pairArray2[2] = TuplesKt.to("fallback", GsonsKt.jsonObjectOf(pairArray3));
            pairArray2[3] = TuplesKt.to("entries", this.modernModel.getEntries());
            pairArray[0] = TuplesKt.to("model", GsonsKt.jsonObjectOf(pairArray2));
            Pair[] $this$close_u24lambda_u241 = GsonsKt.jsonObjectOf(pairArray);
            boolean bl = false;
            this.zipper.modern().bettermodel().items().add("bm_models.json", this.estimatedSize, () -> ModelPipeline.close$lambda$1$lambda$0((JsonObject)$this$close_u24lambda_u241));
            pairArray = new Pair[3];
            pairArray[0] = TuplesKt.to("parent", "minecraft:item/generated");
            $this$close_u24lambda_u241 = new Pair[]{TuplesKt.to("layer0", "minecraft:item/" + itemName)};
            pairArray[1] = TuplesKt.to("textures", GsonsKt.jsonObjectOf($this$close_u24lambda_u241));
            pairArray[2] = TuplesKt.to("overrides", this.legacyModel.getEntries());
            JsonObject $this$close_u24lambda_u244 = GsonsKt.jsonObjectOf(pairArray);
            boolean bl2 = false;
            byte[] byteArray = GsonsKt.toByteArray((JsonElement)$this$close_u24lambda_u244);
            long estimatedSize = byteArray.length;
            this.legacyModel.getPack().add("bm_models.json", estimatedSize, () -> ModelPipeline.close$lambda$4$lambda$2(byteArray));
            String[] stringArray = new String[]{"item"};
            this.zipper.legacy().minecraft().models().resolve(stringArray).add(itemName + ".json", estimatedSize, () -> ModelPipeline.close$lambda$4$lambda$3(byteArray));
        }

        private static final byte[] close$lambda$1$lambda$0(JsonObject $this_run) {
            return GsonsKt.toByteArray((JsonElement)$this_run);
        }

        private static final byte[] close$lambda$4$lambda$2(byte[] $byteArray) {
            return $byteArray;
        }

        private static final byte[] close$lambda$4$lambda$3(byte[] $byteArray) {
            return $byteArray;
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lkr/toxicity/model/manager/ModelManagerImpl$ModelPipeline$ModelBuilder;", "", "pack", "Lkr/toxicity/model/api/pack/PackBuilder;", "<init>", "(Lkr/toxicity/model/api/pack/PackBuilder;)V", "getPack", "()Lkr/toxicity/model/api/pack/PackBuilder;", "entries", "Lcom/google/gson/JsonArray;", "getEntries", "()Lcom/google/gson/JsonArray;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "", "core"})
        public static final class ModelBuilder {
            @NotNull
            private final PackBuilder pack;
            @NotNull
            private final JsonArray entries;

            public ModelBuilder(@NotNull PackBuilder pack) {
                Intrinsics.checkNotNullParameter(pack, "pack");
                this.pack = pack;
                this.entries = GsonsKt.jsonArrayOf(new Object[0]);
            }

            @NotNull
            public final PackBuilder getPack() {
                return this.pack;
            }

            @NotNull
            public final JsonArray getEntries() {
                return this.entries;
            }

            @NotNull
            public final PackBuilder component1() {
                return this.pack;
            }

            @NotNull
            public final ModelBuilder copy(@NotNull PackBuilder pack) {
                Intrinsics.checkNotNullParameter(pack, "pack");
                return new ModelBuilder(pack);
            }

            public static /* synthetic */ ModelBuilder copy$default(ModelBuilder modelBuilder, PackBuilder packBuilder, int n, Object object) {
                if ((n & 1) != 0) {
                    packBuilder = modelBuilder.pack;
                }
                return modelBuilder.copy(packBuilder);
            }

            @NotNull
            public String toString() {
                return "ModelBuilder(pack=" + this.pack + ")";
            }

            public int hashCode() {
                return this.pack.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof ModelBuilder)) {
                    return false;
                }
                ModelBuilder modelBuilder = (ModelBuilder)other;
                return Intrinsics.areEqual(this.pack, modelBuilder.pack);
            }
        }
    }
}

