/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.data.raw;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.annotations.SerializedName;
import java.util.Collections;
import java.util.List;
import kr.toxicity.model.api.BetterModel;
import kr.toxicity.model.api.data.blueprint.BlueprintAnimation;
import kr.toxicity.model.api.data.blueprint.BlueprintElement;
import kr.toxicity.model.api.data.blueprint.ModelBlueprint;
import kr.toxicity.model.api.data.raw.Float3;
import kr.toxicity.model.api.data.raw.Float4;
import kr.toxicity.model.api.data.raw.ModelAnimation;
import kr.toxicity.model.api.data.raw.ModelChildren;
import kr.toxicity.model.api.data.raw.ModelElement;
import kr.toxicity.model.api.data.raw.ModelGroup;
import kr.toxicity.model.api.data.raw.ModelLoadContext;
import kr.toxicity.model.api.data.raw.ModelLoadResult;
import kr.toxicity.model.api.data.raw.ModelMeta;
import kr.toxicity.model.api.data.raw.ModelPlaceholder;
import kr.toxicity.model.api.data.raw.ModelResolution;
import kr.toxicity.model.api.data.raw.ModelTexture;
import kr.toxicity.model.api.util.CollectionUtil;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public record ModelData(@NotNull ModelMeta meta, @NotNull ModelResolution resolution, @NotNull List<ModelElement> elements, @NotNull List<ModelChildren> outliner, @NotNull List<ModelTexture> textures, @Nullable List<ModelAnimation> animations, @Nullable List<ModelGroup> groups, @SerializedName(value="animation_variable_placeholders") @Nullable ModelPlaceholder placeholder) {
    @Nullable
    private final List<ModelAnimation> animations;
    @Nullable
    private final List<ModelGroup> groups;
    @SerializedName(value="animation_variable_placeholders")
    @Nullable
    private final ModelPlaceholder placeholder;
    public static final Gson GSON = new GsonBuilder().registerTypeAdapter(Float3.class, Float3.PARSER).registerTypeAdapter(Float4.class, Float4.PARSER).registerTypeAdapter(ModelMeta.class, ModelMeta.PARSER).registerTypeAdapter(ModelChildren.class, ModelChildren.PARSER).registerTypeAdapter(ModelPlaceholder.class, ModelPlaceholder.PARSER).registerTypeAdapter(ModelElement.class, ModelElement.PARSER).create();

    @NotNull
    public ModelLoadResult loadBlueprint(@NotNull String name) {
        return this.loadBlueprint(name, BetterModel.config().enableStrictLoading());
    }

    @NotNull
    public ModelLoadResult loadBlueprint(@NotNull String name, boolean strict) {
        ModelLoadContext context = new ModelLoadContext(this.placeholder(), this.meta(), CollectionUtil.associate(this.elements(), ModelElement::uuid), CollectionUtil.associate(this.groups(), ModelGroup::uuid), CollectionUtil.mapToSet(this.outliner().stream().flatMap(ModelChildren::flatten), ModelChildren::uuid), strict);
        List<BlueprintElement> group = CollectionUtil.mapToList(this.outliner(), children -> children.toBlueprint(context));
        return new ModelLoadResult(new ModelBlueprint(name, this.resolution(), CollectionUtil.mapToList(this.textures(), ModelTexture::toBlueprint), group, CollectionUtil.associate(this.animations().stream().map(raw -> raw.toBlueprint(context, group)), BlueprintAnimation::name)), context.errors);
    }

    public void assertSupported() {
        this.elements().stream().filter(e -> !e.isSupported()).findFirst().ifPresent(e -> {
            throw new RuntimeException("This model file has unsupported element type: " + e.type());
        });
    }

    @NotNull
    public ModelPlaceholder placeholder() {
        return this.placeholder != null ? this.placeholder : ModelPlaceholder.EMPTY;
    }

    @NotNull
    public List<ModelAnimation> animations() {
        return this.animations != null ? this.animations : Collections.emptyList();
    }

    @NotNull
    public List<ModelGroup> groups() {
        return this.groups != null ? this.groups : Collections.emptyList();
    }
}

