/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.tracker;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.stream.Stream;
import kr.toxicity.model.api.BetterModel;
import kr.toxicity.model.api.config.DebugConfig;
import kr.toxicity.model.api.nms.EntityAdapter;
import kr.toxicity.model.api.nms.ModelDisplay;
import kr.toxicity.model.api.nms.PacketBundler;
import kr.toxicity.model.api.nms.PlayerChannelHandler;
import kr.toxicity.model.api.tracker.EntityHideOption;
import kr.toxicity.model.api.tracker.EntityTracker;
import kr.toxicity.model.api.tracker.Tracker;
import kr.toxicity.model.api.tracker.TrackerData;
import kr.toxicity.model.api.util.LogUtil;
import kr.toxicity.model.api.util.entity.EntityId;
import lombok.Generated;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.persistence.PersistentDataType;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public final class EntityTrackerRegistry {
    private static final Map<UUID, EntityTrackerRegistry> UUID_REGISTRY_MAP = new ConcurrentHashMap<UUID, EntityTrackerRegistry>();
    private static final Map<EntityId, EntityTrackerRegistry> ID_REGISTRY_MAP = new ConcurrentHashMap<EntityId, EntityTrackerRegistry>();
    public static final NamespacedKey TRACKING_ID = Objects.requireNonNull(NamespacedKey.fromString((String)"bettermodel_tracker"));
    public static final Collection<EntityTrackerRegistry> REGISTRIES = Collections.unmodifiableCollection(UUID_REGISTRY_MAP.values());
    private final AtomicBoolean closed = new AtomicBoolean();
    private final Entity entity;
    private final EntityId id;
    private final EntityAdapter adapter;
    private final ConcurrentNavigableMap<String, EntityTracker> trackerMap = new ConcurrentSkipListMap<String, EntityTracker>();
    private final Collection<EntityTracker> trackers = Collections.unmodifiableCollection(this.trackerMap.values());
    private final Map<UUID, PlayerChannelCache> viewedPlayerMap = new ConcurrentHashMap<UUID, PlayerChannelCache>();

    @Nullable
    public static EntityTrackerRegistry registry(@NotNull UUID uuid) {
        return UUID_REGISTRY_MAP.get(uuid);
    }

    @Nullable
    public static EntityTrackerRegistry registry(@NotNull EntityId id) {
        return ID_REGISTRY_MAP.get(id);
    }

    @ApiStatus.Internal
    @NotNull
    public static EntityTrackerRegistry registry(@NotNull Entity entity) {
        EntityTrackerRegistry get = EntityTrackerRegistry.registry(entity.getUniqueId());
        if (get != null) {
            return get;
        }
        EntityTrackerRegistry registry = new EntityTrackerRegistry(entity);
        EntityTrackerRegistry put = UUID_REGISTRY_MAP.putIfAbsent(entity.getUniqueId(), registry);
        if (put != null) {
            return put;
        }
        ID_REGISTRY_MAP.put(registry.id, registry);
        registry.load();
        registry.refreshPlayer();
        return registry;
    }

    @NotNull
    private static Collection<JsonElement> deserialize(@Nullable String raw) {
        if (raw == null) {
            return Collections.emptyList();
        }
        JsonElement json = JsonParser.parseString((String)raw);
        return json.isJsonArray() ? json.getAsJsonArray().asList() : Collections.singletonList(json);
    }

    public static boolean hasModelData(@NotNull Entity entity) {
        return entity.getPersistentDataContainer().has(TRACKING_ID);
    }

    private EntityTrackerRegistry(@NotNull Entity entity) {
        this.entity = entity;
        this.adapter = BetterModel.plugin().nms().adapt(entity);
        this.id = new EntityId(entity.getWorld().getUID(), this.adapter.id());
    }

    @NotNull
    public Entity entity() {
        return this.entity;
    }

    @NotNull
    public UUID uuid() {
        return this.entity().getUniqueId();
    }

    @NotNull
    public EntityId id() {
        return this.id;
    }

    @NotNull
    public EntityAdapter adapter() {
        return this.adapter;
    }

    @NotNull
    public @Unmodifiable Collection<EntityTracker> trackers() {
        return this.trackers;
    }

    @Nullable
    public EntityTracker tracker(@Nullable String key) {
        return key == null ? this.first() : (EntityTracker)this.trackerMap.get(key);
    }

    @Nullable
    public EntityTracker first() {
        Map.Entry entry = this.trackerMap.firstEntry();
        return entry != null ? (EntityTracker)entry.getValue() : null;
    }

    @ApiStatus.Internal
    @NotNull
    public EntityTracker create(@NotNull String key, @NotNull Function<EntityTrackerRegistry, EntityTracker> supplier) {
        EntityTracker created = supplier.apply(this);
        if (this.putTracker(key, created)) {
            this.refreshSpawn();
            this.save();
        }
        return created;
    }

    @NotNull
    public EntityTracker getOrCreate(@NotNull String key, @NotNull Function<EntityTrackerRegistry, EntityTracker> supplier) {
        EntityTracker get = (EntityTracker)this.trackerMap.get(key);
        return get != null ? get : this.create(key, supplier);
    }

    private boolean putTracker(@NotNull String key, @NotNull EntityTracker created) {
        if (created.isClosed()) {
            return false;
        }
        created.handleCloseEvent((t, r) -> {
            if (this.isClosed()) {
                return;
            }
            if (this.trackerMap.compute(key, (k, v) -> v == created ? null : v) == null) {
                LogUtil.debug(DebugConfig.DebugOption.TRACKER, () -> String.valueOf(this.entity.getUniqueId()) + "'s tracker " + key + " has been removed. (" + this.trackerMap.size() + ")");
            }
            if (this.trackerMap.isEmpty() && this.close((Tracker.CloseReason)((Object)r))) {
                LogUtil.debug(DebugConfig.DebugOption.TRACKER, () -> String.valueOf(this.entity.getUniqueId()) + "'s tracker registry has been removed. (" + REGISTRIES.size() + ")");
            } else {
                this.refreshRemove();
            }
        });
        EntityTracker previous = this.trackerMap.put(key, created);
        if (previous != null) {
            previous.close();
        }
        return true;
    }

    private void refreshSpawn() {
        this.viewedPlayer().forEach(value -> this.spawn(value.player(), true));
    }

    private void refreshRemove() {
        for (PlayerChannelCache value : this.viewedPlayerMap.values()) {
            value.hide();
        }
    }

    private void refreshPlayer() {
        Stream<Player> stream = this.adapter.trackedPlayer().stream();
        Entity entity = this.entity;
        if (entity instanceof Player) {
            Player player = (Player)entity;
            stream = Stream.concat(Stream.of(player), stream);
        }
        stream.map(p -> BetterModel.player(p.getUniqueId()).orElse(null)).filter(Objects::nonNull).forEach(this::registerPlayer);
    }

    public boolean remove(@NotNull String key) {
        try (EntityTracker removed = (EntityTracker)this.trackerMap.remove(key);){
            this.save();
            boolean bl = removed != null;
            return bl;
        }
    }

    public boolean isClosed() {
        return this.closed.get();
    }

    public boolean close() {
        return this.close(Tracker.CloseReason.REMOVE);
    }

    private boolean close(@NotNull Tracker.CloseReason reason) {
        if (!this.closed.compareAndSet(false, true)) {
            return false;
        }
        this.viewedPlayer().forEach(value -> value.sendEntityData(this));
        this.viewedPlayerMap.clear();
        for (EntityTracker value2 : this.trackerMap.values()) {
            value2.close(reason);
        }
        if (!reason.shouldBeSave()) {
            this.entity.getPersistentDataContainer().remove(TRACKING_ID);
        }
        if (UUID_REGISTRY_MAP.remove(this.entity.getUniqueId()) != null) {
            ID_REGISTRY_MAP.remove(this.id);
        }
        return true;
    }

    public void reload() {
        this.closed.set(true);
        ArrayList<TrackerData> data = new ArrayList<TrackerData>(this.trackerMap.size());
        for (EntityTracker value : this.trackerMap.values()) {
            data.add(value.asTrackerData());
            value.close();
        }
        this.trackerMap.clear();
        this.closed.set(false);
        this.load(data.stream());
    }

    public void refresh() {
        if (this.adapter.dead()) {
            return;
        }
        for (EntityTracker value : this.trackerMap.values()) {
            value.refresh();
        }
        this.refreshPlayer();
        this.refreshSpawn();
    }

    public void despawn() {
        for (EntityTracker value : this.trackerMap.values()) {
            if (value.forRemoval()) continue;
            value.despawn();
        }
        this.viewedPlayerMap.clear();
    }

    public void load(@NotNull Stream<TrackerData> stream) {
        stream.forEach(parsed -> BetterModel.model(parsed.id()).ifPresent(model -> model.create(this.entity, parsed.modifier(), parsed::applyAs)));
        this.save();
    }

    public void load() {
        this.load(EntityTrackerRegistry.deserialize((String)this.entity.getPersistentDataContainer().get(TRACKING_ID, PersistentDataType.STRING)).stream().map(TrackerData::deserialize));
    }

    public void save() {
        this.entity.getPersistentDataContainer().set(TRACKING_ID, PersistentDataType.STRING, (Object)this.serialize().toString());
    }

    @NotNull
    public Stream<ModelDisplay> displays() {
        return this.trackerMap.values().stream().flatMap(Tracker::displays);
    }

    @NotNull
    public JsonArray serialize() {
        JsonArray array = new JsonArray(this.trackerMap.size());
        for (EntityTracker value : this.trackerMap.values()) {
            array.add(value.asTrackerData().serialize());
        }
        return array;
    }

    public boolean isSpawned(@NotNull Player player) {
        return this.isSpawned(player.getUniqueId());
    }

    public boolean isSpawned(@NotNull UUID uuid) {
        return this.viewedPlayerMap.containsKey(uuid) && this.trackerMap.values().stream().anyMatch(t -> t.pipeline.isSpawned(uuid));
    }

    public boolean spawn(@NotNull Player player) {
        return this.spawn(player, false);
    }

    private boolean spawn(@NotNull Player player, boolean shouldNotSpawned) {
        PlayerChannelHandler handler = BetterModel.plugin().playerManager().player(player.getUniqueId());
        if (handler == null) {
            return false;
        }
        PlayerChannelCache cache = this.registerPlayer(handler);
        if (this.trackerMap.isEmpty()) {
            return false;
        }
        PacketBundler bundler = BetterModel.plugin().nms().createBundler(10);
        for (EntityTracker value : this.trackerMap.values()) {
            if (shouldNotSpawned && value.pipeline.isSpawned(player.getUniqueId()) || !value.canBeSpawnedAt((OfflinePlayer)player)) continue;
            value.spawn(player, bundler);
        }
        if (bundler.isEmpty()) {
            return false;
        }
        BetterModel.plugin().nms().mount(this, bundler);
        cache.spawn(bundler);
        return true;
    }

    @NotNull
    private PlayerChannelCache registerPlayer(@NotNull PlayerChannelHandler handler) {
        return this.viewedPlayerMap.computeIfAbsent(handler.uuid(), u -> new PlayerChannelCache(handler));
    }

    @NotNull
    public Stream<PlayerChannelHandler> viewedPlayer() {
        return this.viewedPlayerMap.values().stream().map(c2 -> c2.channelHandler);
    }

    public boolean remove(@NotNull Player player) {
        PlayerChannelCache cache = this.viewedPlayerMap.remove(player.getUniqueId());
        if (cache == null) {
            return false;
        }
        PlayerChannelHandler handler = cache.channelHandler;
        handler.sendEntityData(this);
        for (EntityTracker value : this.trackerMap.values()) {
            if (value.forRemoval() || !value.pipeline.isSpawned(player.getUniqueId())) continue;
            value.remove(handler.player());
        }
        return true;
    }

    @NotNull
    public EntityHideOption hideOption(@NotNull UUID uuid) {
        PlayerChannelCache cache = this.viewedPlayerMap.get(uuid);
        return cache != null ? cache.hideOption : EntityHideOption.FALSE;
    }

    private class PlayerChannelCache {
        private final PlayerChannelHandler channelHandler;
        private volatile EntityHideOption hideOption = EntityHideOption.DEFAULT;

        private void hide() {
            this.reapplyHideOption();
            BetterModel.plugin().nms().hide(this.channelHandler, EntityTrackerRegistry.this);
        }

        private void spawn(@NotNull PacketBundler bundler) {
            this.reapplyHideOption();
            bundler.send(this.channelHandler.player(), () -> BetterModel.plugin().nms().hide(this.channelHandler, EntityTrackerRegistry.this, () -> EntityTrackerRegistry.this.viewedPlayerMap.containsKey(this.channelHandler.uuid())));
        }

        private synchronized void reapplyHideOption() {
            this.hideOption = EntityHideOption.composite(EntityTrackerRegistry.this.trackerMap.values().stream().filter(t -> t.pipeline.isSpawned(this.channelHandler.uuid())).map(EntityTracker::hideOption));
        }

        @Generated
        public PlayerChannelCache(PlayerChannelHandler channelHandler) {
            this.channelHandler = channelHandler;
        }
    }
}

