/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.shaded.dev.jorel.commandapi.arguments;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.LongArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import kr.toxicity.model.shaded.dev.jorel.commandapi.arguments.CommandAPIArgumentType;
import kr.toxicity.model.shaded.dev.jorel.commandapi.arguments.SafeOverrideableArgument;
import kr.toxicity.model.shaded.dev.jorel.commandapi.exceptions.InvalidRangeException;
import kr.toxicity.model.shaded.dev.jorel.commandapi.executors.CommandArguments;

public class LongArgument
extends SafeOverrideableArgument<Long, Long> {
    public LongArgument(String nodeName) {
        super(nodeName, (ArgumentType<?>)LongArgumentType.longArg(), String::valueOf);
    }

    public LongArgument(String nodeName, long min) {
        super(nodeName, (ArgumentType<?>)LongArgumentType.longArg((long)min), String::valueOf);
    }

    public LongArgument(String nodeName, long min, long max) {
        super(nodeName, (ArgumentType<?>)LongArgumentType.longArg((long)min, (long)max), String::valueOf);
        if (max < min) {
            throw new InvalidRangeException();
        }
    }

    @Override
    public Class<Long> getPrimitiveType() {
        return Long.TYPE;
    }

    @Override
    public CommandAPIArgumentType getArgumentType() {
        return CommandAPIArgumentType.PRIMITIVE_LONG;
    }

    @Override
    public <Source> Long parseArgument(CommandContext<Source> cmdCtx, String key, CommandArguments previousArgs) throws CommandSyntaxException {
        return (Long)cmdCtx.getArgument(key, this.getPrimitiveType());
    }
}

