/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.bone;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kr.toxicity.model.api.bone.BoneMovement;
import kr.toxicity.model.api.bone.RenderedBone;
import kr.toxicity.model.api.util.InterpolationUtil;
import kr.toxicity.model.api.util.MathUtil;
import lombok.Generated;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

@ApiStatus.Internal
public final class BoneIKSolver {
    private static final int MAX_IK_ITERATION = 20;
    private final Map<UUID, RenderedBone> boneMap;
    private final Map<RenderedBone, IKTree> locators = new LinkedHashMap<RenderedBone, IKTree>();

    public void addLocator(@Nullable UUID ikSource, @NotNull UUID ikTarget, @NotNull RenderedBone locator) {
        RenderedBone target = this.boneMap.get(ikTarget);
        if (target == null) {
            return;
        }
        RenderedBone source = ikSource == null ? target.root : this.boneMap.getOrDefault(ikSource, target.root);
        List<RenderedBone> list = source.flatten().filter(bone -> !bone.flattenBones().contains(locator) && bone.flattenBones().contains(target)).toList();
        if (list.size() < 2) {
            return;
        }
        this.locators.put(locator, new IKTree(source, list, new float[list.size() - 1]));
    }

    public void solve() {
        this.solve(null);
    }

    public void solve(@Nullable UUID uuid) {
        for (Map.Entry<RenderedBone, IKTree> entry : this.locators.entrySet()) {
            RenderedBone locator = entry.getKey();
            IKTree value = entry.getValue();
            RenderedBone root = value.bones.getFirst();
            BoneIKSolver.fabrik(value.bones.stream().map(bone -> bone.state(uuid).after()).toList(), value.source.state(uuid).after().rotation().invert(new Quaternionf()), value.buffer, locator.state(uuid).after().position().get(new Vector3f()).add((Vector3fc)locator.root.group.getPosition()).sub((Vector3fc)root.state(uuid).after().position()).sub((Vector3fc)root.root.group.getPosition()));
        }
    }

    private static void fabrik(@NotNull List<BoneMovement> bones, @NotNull Quaternionf parentRot, float[] lengths, @NotNull Vector3f target) {
        int i2;
        Vector3f first = bones.getFirst().position();
        Vector3f last = bones.getLast().position();
        Vector3f rootPos = new Vector3f((Vector3fc)first);
        for (i2 = 0; i2 < bones.size() - 1; ++i2) {
            BoneMovement before = bones.get(i2);
            BoneMovement after = bones.get(i2 + 1);
            lengths[i2] = before.position().distance((Vector3fc)after.position());
        }
        for (int iter = 0; iter < 20; ++iter) {
            float dist;
            Vector3f next;
            Vector3f current;
            int i3;
            last.set((Vector3fc)target);
            for (i3 = bones.size() - 2; i3 >= 0; --i3) {
                current = bones.get(i3).position();
                dist = current.distance((Vector3fc)(next = bones.get(i3 + 1).position()));
                if (dist < 1.0E-5f) continue;
                InterpolationUtil.lerp(next, current, lengths[i3] / dist, current);
            }
            first.set((Vector3fc)rootPos);
            for (i3 = 0; i3 < bones.size() - 1; ++i3) {
                current = bones.get(i3).position();
                dist = current.distance((Vector3fc)(next = bones.get(i3 + 1).position()));
                if (dist < 1.0E-5f) continue;
                InterpolationUtil.lerp(current, next, lengths[i3] / dist, next);
            }
            if (last.distance((Vector3fc)target) < 0.001f) break;
        }
        for (i2 = 0; i2 < bones.size() - 1; ++i2) {
            BoneMovement current = bones.get(i2);
            BoneMovement next = bones.get(i2 + 1);
            Vector3f dir = next.position().sub((Vector3fc)current.position(), new Vector3f());
            current.rotation().set((Quaternionfc)MathUtil.fromToRotation(dir).mul((Quaternionfc)parentRot).mul((Quaternionfc)current.rotation()));
        }
    }

    @Generated
    public BoneIKSolver(Map<UUID, RenderedBone> boneMap) {
        this.boneMap = boneMap;
    }

    private record IKTree(@NotNull RenderedBone source, @NotNull List<RenderedBone> bones, float[] buffer) {
    }
}

