/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.shaded.dev.jorel.commandapi;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kr.toxicity.model.shaded.dev.jorel.commandapi.AbstractArgumentTree;
import kr.toxicity.model.shaded.dev.jorel.commandapi.ExecutableCommand;
import kr.toxicity.model.shaded.dev.jorel.commandapi.Execution;
import kr.toxicity.model.shaded.dev.jorel.commandapi.arguments.AbstractArgument;

public abstract class AbstractCommandTree<Impl extends AbstractCommandTree<Impl, Argument, CommandSender>, Argument extends AbstractArgument<?, ?, Argument, CommandSender>, CommandSender>
extends ExecutableCommand<Impl, CommandSender> {
    private final List<AbstractArgumentTree<?, Argument, CommandSender>> arguments = new ArrayList();

    protected AbstractCommandTree(String commandName) {
        super(commandName);
    }

    public Impl then(AbstractArgumentTree<?, Argument, CommandSender> tree) {
        this.arguments.add(tree);
        return (Impl)((AbstractCommandTree)this.instance());
    }

    public final Impl thenNested(List<AbstractArgumentTree<?, Argument, CommandSender>> trees) {
        int length = trees.size();
        if (length == 0) {
            return (Impl)((AbstractCommandTree)this.instance());
        }
        AbstractArgumentTree<Object, Argument, CommandSender> combined = trees.get(length - 1);
        for (int i = length - 2; i >= 0; --i) {
            combined = trees.get(i).then(combined);
        }
        return this.then(combined);
    }

    @SafeVarargs
    public final Impl thenNested(AbstractArgumentTree<?, Argument, CommandSender> ... trees) {
        return this.thenNested(Arrays.asList(trees));
    }

    @Override
    public void register(String namespace) {
        if (namespace == null) {
            throw new NullPointerException("Parameter 'namespace' was null when registering command /" + this.meta.commandName + "!");
        }
        ArrayList<Execution<CommandSender, Argument>> executions = new ArrayList<Execution<CommandSender, Argument>>();
        if (this.executor.hasAnyExecutors()) {
            executions.add(new Execution(List.of(), this.executor));
        }
        for (AbstractArgumentTree<?, Argument, CommandSender> abstractArgumentTree : this.arguments) {
            executions.addAll(abstractArgumentTree.getExecutions());
        }
        for (Execution execution : executions) {
            execution.register(this.meta, namespace);
        }
    }
}

