/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.data.blueprint;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.lang.runtime.SwitchBootstraps;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import kr.toxicity.model.api.bone.BoneName;
import kr.toxicity.model.api.bone.BoneTagRegistry;
import kr.toxicity.model.api.data.blueprint.BlueprintJson;
import kr.toxicity.model.api.data.blueprint.BlueprintTexture;
import kr.toxicity.model.api.data.blueprint.ModelBlueprint;
import kr.toxicity.model.api.data.blueprint.ModelBoundingBox;
import kr.toxicity.model.api.data.blueprint.NamedBoundingBox;
import kr.toxicity.model.api.data.raw.Float3;
import kr.toxicity.model.api.data.raw.ModelChildren;
import kr.toxicity.model.api.data.raw.ModelElement;
import kr.toxicity.model.api.util.CollectionUtil;
import kr.toxicity.model.api.util.MathUtil;
import kr.toxicity.model.api.util.PackUtil;
import kr.toxicity.model.api.util.json.JsonObjectBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public sealed interface BlueprintChildren {
    @NotNull
    public static BlueprintChildren from(@NotNull ModelChildren children, @NotNull @Unmodifiable Map<String, ModelElement> elementMap) {
        ModelChildren modelChildren = children;
        Objects.requireNonNull(modelChildren);
        ModelChildren modelChildren2 = modelChildren;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ModelChildren.ModelGroup.class, ModelChildren.ModelUUID.class}, (Object)modelChildren2, n)) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                ModelChildren.ModelGroup modelGroup = (ModelChildren.ModelGroup)modelChildren2;
                List<BlueprintChildren> child = CollectionUtil.mapToList(modelGroup.children(), c2 -> BlueprintChildren.from(c2, elementMap));
                yield new BlueprintGroup(BoneTagRegistry.parse(modelGroup.name()), modelGroup.origin(), modelGroup.rotation().invertXZ(), child, CollectionUtil.filterIsInstance(child, BlueprintElement.class).anyMatch(element -> element.element.visibility()));
            }
            case 1 -> {
                ModelChildren.ModelUUID modelUUID = (ModelChildren.ModelUUID)modelChildren2;
                yield new BlueprintElement(Objects.requireNonNull(elementMap.get(modelUUID.uuid())));
            }
        };
    }

    public record BlueprintGroup(@NotNull BoneName name, @NotNull Float3 origin, @NotNull Float3 rotation, @NotNull List<BlueprintChildren> children, boolean visibility) implements BlueprintChildren
    {
        @NotNull
        private final Float3 origin;
        private static final JsonArray MAX_SCALE_ARRAY = new JsonArray(3);

        @NotNull
        public Float3 origin() {
            return this.origin.invertXZ();
        }

        @NotNull
        public String jsonName(@NotNull ModelBlueprint parent) {
            return PackUtil.toPackName(parent.name() + "_" + this.name.rawName());
        }

        @Nullable
        public BlueprintJson buildLegacyJson(boolean skipLog, float scale, @NotNull ModelBlueprint parent) {
            Predicate<BlueprintElement> filter = element -> MathUtil.checkValidDegree(element.identifierDegree());
            if (!skipLog) {
                filter = CollectionUtil.filterWithWarning(filter, element -> "The model " + parent.name() + "'s cube \"" + element.element.name() + "\" has an invalid rotation which does not supported in legacy client (<=1.21.3) " + String.valueOf(element.element.rotation()));
            }
            return this.buildJson(-2, 1, scale, parent, Float3.ZERO, CollectionUtil.filterIsInstance(this.children, BlueprintElement.class).filter(filter));
        }

        @Nullable
        public @Unmodifiable List<BlueprintJson> buildModernJson(float scale, @NotNull ModelBlueprint parent) {
            List<BlueprintJson> list = CollectionUtil.mapIndexed(CollectionUtil.group(CollectionUtil.filterIsInstance(this.children, BlueprintElement.class), BlueprintElement::identifierDegree), (i, entry) -> this.buildJson(0, i + 1, scale, parent, (Float3)entry.getKey(), ((List)entry.getValue()).stream())).filter(Objects::nonNull).toList();
            return list.isEmpty() ? null : list;
        }

        @Nullable
        private BlueprintJson buildJson(int tint, int number, float scale, @NotNull ModelBlueprint parent, @NotNull Float3 identifier, @NotNull Stream<BlueprintElement> cubes) {
            if (parent.textures().isEmpty()) {
                return null;
            }
            List<BlueprintElement> cubeElement = cubes.filter(c2 -> c2.element.hasTexture()).toList();
            if (cubeElement.isEmpty()) {
                return null;
            }
            return new BlueprintJson(this.jsonName(parent) + "_" + number, () -> JsonObjectBuilder.builder().jsonObject("textures", textures -> {
                int index = 0;
                for (BlueprintTexture texture : parent.textures()) {
                    textures.property(Integer.toString(index++), texture.packName(parent.name()));
                }
                textures.property("particle", parent.textures().getFirst().packName(parent.name()));
            }).jsonArray("elements", CollectionUtil.mapToJson(cubeElement, cube -> cube.buildJson(tint, scale, parent, this, identifier))).jsonObject("display", display -> display.jsonObject("fixed", fixed -> {
                fixed.jsonArray("scale", MAX_SCALE_ARRAY);
                if (!identifier.equals(Float3.ZERO)) {
                    fixed.jsonArray("rotation", identifier.convertToMinecraftDegree().toJson());
                }
            })).build());
        }

        @Nullable
        public NamedBoundingBox hitBox() {
            return CollectionUtil.filterIsInstance(this.children, BlueprintElement.class).map(be -> {
                ModelElement element = be.element;
                Vector3f from = element.from().minus(this.origin).toBlockScale().toVector();
                Vector3f to = element.to().minus(this.origin).toBlockScale().toVector();
                return ModelBoundingBox.of(from.x, from.y, from.z, to.x, to.y, to.z).invert();
            }).max(Comparator.comparingDouble(ModelBoundingBox::length)).map(max -> new NamedBoundingBox(this.name, (ModelBoundingBox)max)).orElse(null);
        }

        static {
            MAX_SCALE_ARRAY.add((Number)4);
            MAX_SCALE_ARRAY.add((Number)4);
            MAX_SCALE_ARRAY.add((Number)4);
        }
    }

    public record BlueprintElement(@NotNull ModelElement element) implements BlueprintChildren
    {
        @NotNull
        private Float3 identifierDegree() {
            Float3 rot = this.element.rotation();
            return rot == null ? Float3.ZERO : MathUtil.identifier(rot);
        }

        @NotNull
        private static Float3 centralize(@NotNull Float3 target, @NotNull Float3 groupOrigin, float scale) {
            return target.minus(groupOrigin).div(scale);
        }

        @NotNull
        private JsonObject buildJson(int tint, float scale, @NotNull ModelBlueprint parent, @NotNull BlueprintGroup group, @NotNull Float3 identifier) {
            Float3 centerOrigin = BlueprintElement.centralize(this.element.origin(), group.origin, scale);
            Quaternionf qua = MathUtil.toQuaternion(identifier.toVector()).invert();
            Float3 rotOrigin = centerOrigin.rotate(qua).minus(centerOrigin);
            Float3 inflate = new Float3(this.element.inflate() / scale);
            return JsonObjectBuilder.builder().jsonArray("from", BlueprintElement.centralize(this.element.from(), group.origin, scale).plus(rotOrigin).plus(Float3.CENTER).minus(inflate).toJson()).jsonArray("to", BlueprintElement.centralize(this.element.to(), group.origin, scale).plus(rotOrigin).plus(Float3.CENTER).plus(inflate).toJson()).jsonObject("faces", this.element.faces().toJson(parent, tint)).jsonObject("rotation", (JsonObject)Optional.ofNullable(this.element.rotation()).map(r -> r.minus(identifier)).filter(r -> !Float3.ZERO.equals(r)).map(rot -> {
                JsonObject rotation = this.getRotation((Float3)rot);
                rotation.add("origin", (JsonElement)centerOrigin.plus(rotOrigin).plus(Float3.CENTER).toJson());
                return rotation;
            }).orElse(null)).build();
        }

        @NotNull
        private JsonObject getRotation(@NotNull Float3 rot) {
            JsonObject rotation = new JsonObject();
            if (Math.abs(rot.x()) > 0.0f) {
                rotation.addProperty("angle", (Number)Float.valueOf(rot.x()));
                rotation.addProperty("axis", "x");
            } else if (Math.abs(rot.y()) > 0.0f) {
                rotation.addProperty("angle", (Number)Float.valueOf(rot.y()));
                rotation.addProperty("axis", "y");
            } else if (Math.abs(rot.z()) > 0.0f) {
                rotation.addProperty("angle", (Number)Float.valueOf(rot.z()));
                rotation.addProperty("axis", "z");
            }
            return rotation;
        }
    }
}

