/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.data.raw;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.function.Function;
import kr.toxicity.model.api.data.raw.ModelResolution;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public record Float4(float dx, float dz, float tx, float tz) {
    public static final Parser PARSER = new Parser();

    @NotNull
    public Float4 div(@NotNull ModelResolution resolution) {
        return this.div((float)resolution.width() / 16.0f, (float)resolution.height() / 16.0f);
    }

    @NotNull
    public Float4 div(float width, float height) {
        return new Float4(this.dx / width, this.dz / height, this.tx / width, this.tz / height);
    }

    @NotNull
    public JsonArray toJson() {
        JsonArray array = new JsonArray(4);
        array.add((Number)Float.valueOf(this.dx));
        array.add((Number)Float.valueOf(this.dz));
        array.add((Number)Float.valueOf(this.tx));
        array.add((Number)Float.valueOf(this.tz));
        return array;
    }

    public static final class Parser
    implements Function<JsonElement, Float4>,
    JsonDeserializer<Float4> {
        private Parser() {
        }

        public Float4 deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return this.apply(json);
        }

        @Override
        public Float4 apply(JsonElement element) {
            JsonArray array = element.getAsJsonArray();
            return new Float4(array.get(0).getAsFloat(), array.get(1).getAsFloat(), array.get(2).getAsFloat(), array.get(3).getAsFloat());
        }
    }
}

