/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.entity;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.SequencedMap;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import kr.toxicity.model.api.BetterModel;
import kr.toxicity.model.api.data.blueprint.AnimationMovement;
import kr.toxicity.model.api.data.blueprint.BlueprintAnimation;
import kr.toxicity.model.api.data.blueprint.BlueprintAnimator;
import kr.toxicity.model.api.data.blueprint.NamedBoundingBox;
import kr.toxicity.model.api.data.renderer.AnimationModifier;
import kr.toxicity.model.api.data.renderer.RendererGroup;
import kr.toxicity.model.api.entity.EntityMovement;
import kr.toxicity.model.api.entity.TrackerMovement;
import kr.toxicity.model.api.nms.EntityAdapter;
import kr.toxicity.model.api.nms.HitBox;
import kr.toxicity.model.api.nms.HitBoxListener;
import kr.toxicity.model.api.nms.HitBoxSource;
import kr.toxicity.model.api.nms.ModelDisplay;
import kr.toxicity.model.api.nms.PacketBundler;
import kr.toxicity.model.api.tracker.ModelRotation;
import kr.toxicity.model.api.util.MathUtil;
import kr.toxicity.model.api.util.TransformedItemStack;
import kr.toxicity.model.api.util.VectorUtil;
import lombok.Generated;
import org.bukkit.Location;
import org.bukkit.entity.ItemDisplay;
import org.bukkit.util.Transformation;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public final class RenderedEntity
implements HitBoxSource,
AutoCloseable {
    private final RendererGroup group;
    private ModelDisplay display;
    private final EntityMovement defaultFrame;
    @Nullable
    private final RenderedEntity parent;
    private Map<String, RenderedEntity> children = Collections.emptyMap();
    private final SequencedMap<String, TreeIterator> animators = new LinkedHashMap<String, TreeIterator>();
    private final Collection<TreeIterator> reversedView = this.animators.sequencedValues().reversed();
    private AnimationMovement keyFrame = null;
    private long delay = 0L;
    private TransformedItemStack itemStack;
    private TransformedItemStack cachedStack;
    private final List<Consumer<AnimationMovement>> movementModifier = new ArrayList<Consumer<AnimationMovement>>();
    private HitBox hitBox;
    private int tint;
    private TreeIterator currentIterator = null;
    private EntityMovement beforeTransform;
    private EntityMovement afterTransform;
    private EntityMovement relativeOffsetCache;
    private Vector3f defaultPosition = new Vector3f();
    private ModelRotation rotation = ModelRotation.EMPTY;

    public RenderedEntity(@NotNull RendererGroup group, @Nullable RenderedEntity parent, @NotNull TransformedItemStack itemStack, @NotNull ItemDisplay.ItemDisplayTransform transform, @NotNull Location firstLocation, @NotNull EntityMovement movement) {
        this.group = group;
        this.parent = parent;
        boolean visible = group.getLimb() != null || group.getParent().visibility();
        this.cachedStack = visible ? itemStack : TransformedItemStack.EMPTY;
        this.itemStack = this.cachedStack;
        if (!itemStack.isEmpty()) {
            this.display = BetterModel.inst().nms().create(firstLocation);
            this.display.display(transform);
            if (visible) {
                this.display.item(itemStack.itemStack());
            }
        }
        this.defaultFrame = movement;
    }

    @ApiStatus.Internal
    public void createHitBox(@NotNull EntityAdapter entity, @NotNull Predicate<RenderedEntity> predicate, @Nullable HitBoxListener listener) {
        NamedBoundingBox h = this.group.getHitBox();
        if (h != null && predicate.test(this)) {
            HitBoxListener l = listener;
            if (this.hitBox != null) {
                this.hitBox.removeHitBox();
                if (l == null) {
                    l = this.hitBox.listener();
                }
            }
            this.hitBox = BetterModel.inst().nms().createHitBox(entity, this, h, this.group.getMountController(), l != null ? l : HitBoxListener.EMPTY);
        }
        this.forEachChildren(e -> e.createHitBox(entity, predicate, listener));
    }

    @ApiStatus.Internal
    public void itemStack(@NotNull Predicate<RenderedEntity> predicate, @NotNull TransformedItemStack itemStack) {
        if (predicate.test(this)) {
            this.itemStack = this.cachedStack = itemStack;
            this.applyItem();
        }
        this.forEachChildren(e -> e.itemStack(predicate, itemStack));
    }

    public void brightness(@NotNull Predicate<RenderedEntity> predicate, int block, int sky) {
        if (predicate.test(this) && this.display != null) {
            this.display.brightness(block, sky);
        }
        this.forEachChildren(e -> e.brightness(predicate, block, sky));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addAnimationMovementModifier(@NotNull Predicate<RenderedEntity> predicate, @NotNull Consumer<AnimationMovement> consumer) {
        if (predicate.test(this)) {
            List<Consumer<AnimationMovement>> list = this.movementModifier;
            synchronized (list) {
                this.movementModifier.add(consumer);
            }
            return true;
        }
        boolean ret = false;
        for (RenderedEntity value : this.children.values()) {
            if (!value.addAnimationMovementModifier(predicate, consumer)) continue;
            ret = true;
        }
        return ret;
    }

    @ApiStatus.Internal
    public void renderers(List<RenderedEntity> renderers) {
        renderers.add(this);
        this.forEachChildren(e -> e.renderers(renderers));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateAnimation() {
        SequencedMap<String, TreeIterator> sequencedMap = this.animators;
        synchronized (sequencedMap) {
            Iterator<TreeIterator> iterator2 = this.reversedView.iterator();
            boolean check = true;
            while (iterator2.hasNext()) {
                TreeIterator next = iterator2.next();
                if (!next.get().booleanValue()) continue;
                if (this.currentIterator == null) {
                    if (!this.updateKeyframe(iterator2, next)) continue;
                    this.currentIterator = next;
                    check = false;
                    break;
                }
                if (this.currentIterator != next) {
                    if (!this.updateKeyframe(iterator2, next)) continue;
                    this.currentIterator.clear();
                    this.currentIterator = next;
                    this.delay = 0L;
                    check = false;
                    break;
                }
                if (this.delay <= 0L) {
                    if (!this.updateKeyframe(iterator2, next)) continue;
                    check = false;
                    break;
                }
                check = false;
                break;
            }
            if (check) {
                this.keyFrame = null;
            }
        }
    }

    private boolean updateKeyframe(Iterator<TreeIterator> iterator2, TreeIterator next) {
        if (!next.hasNext()) {
            next.run();
            iterator2.remove();
            return false;
        }
        this.relativeOffsetCache = null;
        this.keyFrame = next.next();
        return true;
    }

    public void move(@Nullable ModelRotation rotation, @NotNull TrackerMovement movement, @NotNull PacketBundler bundler) {
        ModelDisplay d = this.display;
        if (rotation != null) {
            this.rotation = rotation;
            if (d != null) {
                d.rotate(rotation, bundler);
            }
        }
        --this.delay;
        this.updateAnimation();
        if (this.delay <= 0L) {
            int f = this.frame();
            this.delay = f;
            this.beforeTransform = this.afterTransform;
            this.afterTransform = movement.plus(this.relativeOffset());
            EntityMovement entityMovement = this.afterTransform.plus(this.defaultPosition);
            if (d != null) {
                d.frame(f <= 0 ? 0 : RenderedEntity.toInterpolationDuration(f));
                this.setup(entityMovement);
                d.send(bundler);
            }
        }
        this.forEachChildren(e -> e.move(rotation, movement, bundler));
    }

    public void forceUpdate(@NotNull PacketBundler bundler) {
        this.forceUpdate0(bundler);
        this.forEachChildren(e -> e.forceUpdate(bundler));
    }

    private void forceUpdate0(@NotNull PacketBundler bundler) {
        ModelDisplay d = this.display;
        if (d != null && this.delay > 0L) {
            float speed = this.currentIterator != null ? this.currentIterator.deltaSpeed() : 1.0f;
            this.delay = Math.round((float)this.delay / speed);
            d.frame(RenderedEntity.toInterpolationDuration(this.delay));
            d.send(bundler);
        }
    }

    private static int toInterpolationDuration(long delay) {
        return (int)Math.floor((float)delay / 5.0f) + 1;
    }

    @NotNull
    public Vector3f worldPosition() {
        return this.worldPosition(new Vector3f());
    }

    @NotNull
    public Vector3f worldPosition(@NotNull Vector3f offset) {
        if (this.afterTransform != null) {
            float progress = 1.0f - this.progress();
            EntityMovement before = this.beforeTransform != null ? this.beforeTransform : EntityMovement.EMPTY;
            Vector3f vec = VectorUtil.linear(before.transform(), this.afterTransform.transform(), progress).add((Vector3fc)offset).add((Vector3fc)this.itemStack.offset()).mul((Vector3fc)VectorUtil.linear(before.scale(), this.afterTransform.scale(), progress)).rotate((Quaternionfc)MathUtil.toQuaternion(MathUtil.blockBenchToDisplay(VectorUtil.linear(before.rawRotation(), this.afterTransform.rawRotation(), progress)))).add((Vector3fc)this.defaultPosition).rotateX((float)(-Math.toRadians(this.rotation.x()))).rotateY((float)(-Math.toRadians(this.rotation.y())));
            return vec.isFinite() ? vec : new Vector3f();
        }
        return new Vector3f();
    }

    private void setup(@NotNull EntityMovement entityMovement) {
        if (this.display != null) {
            this.display.transform(new Transformation(new Vector3f((Vector3fc)entityMovement.transform()).add((Vector3fc)new Vector3f((Vector3fc)this.itemStack.offset()).rotate((Quaternionfc)entityMovement.rotation())), entityMovement.rotation(), new Vector3f((Vector3fc)entityMovement.scale()).mul((Vector3fc)this.itemStack.scale()), new Quaternionf()));
        }
    }

    public void defaultPosition(@NotNull Vector3f movement) {
        this.defaultPosition = this.group.getLimb() != null ? new Vector3f((Vector3fc)movement).add((Vector3fc)this.group.getLimb().getPosition()) : movement;
        this.forEachChildren(e -> e.defaultPosition(movement));
    }

    private int frame() {
        return this.keyFrame != null ? Math.round(this.keyFrame.time() * 100.0f) : (this.parent != null ? this.parent.frame() : 5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EntityMovement defaultFrame() {
        AnimationMovement k = this.keyFrame != null ? this.keyFrame.copyNotNull() : new AnimationMovement(0.0f, new Vector3f(), new Vector3f(), new Vector3f());
        List<Consumer<AnimationMovement>> list = this.movementModifier;
        synchronized (list) {
            for (Consumer<AnimationMovement> consumer : this.movementModifier) {
                consumer.accept(k);
            }
        }
        return this.defaultFrame.plus(k);
    }

    private float progress() {
        return (float)this.delay / (float)this.frame();
    }

    private EntityMovement relativeOffset() {
        if (this.relativeOffsetCache != null) {
            return this.relativeOffsetCache;
        }
        EntityMovement def = this.defaultFrame();
        if (this.parent != null) {
            EntityMovement p = this.parent.relativeOffset();
            this.relativeOffsetCache = new EntityMovement(new Vector3f((Vector3fc)p.transform()).add((Vector3fc)new Vector3f((Vector3fc)def.transform()).mul((Vector3fc)p.scale()).rotate((Quaternionfc)p.rotation())), new Vector3f((Vector3fc)def.scale()).mul((Vector3fc)p.scale()), new Quaternionf((Quaternionfc)p.rotation()).mul((Quaternionfc)def.rotation()), def.rawRotation());
            return this.relativeOffsetCache;
        }
        this.relativeOffsetCache = def;
        return this.relativeOffsetCache;
    }

    public void tint(@NotNull Predicate<RenderedEntity> predicate, int tint, @NotNull PacketBundler bundler) {
        if (predicate.test(this)) {
            this.tint = tint;
            if (this.applyItem()) {
                this.forceUpdate0(bundler);
            }
        }
        this.forEachChildren(e -> e.tint(predicate, tint, bundler));
    }

    private boolean applyItem() {
        if (this.display != null) {
            this.display.item(BetterModel.inst().nms().tint(this.itemStack.itemStack().clone(), this.tint));
            return true;
        }
        return false;
    }

    @NotNull
    public String getName() {
        return this.getGroup().getName();
    }

    public void teleport(@NotNull Location location, @NotNull PacketBundler bundler) {
        if (this.display != null) {
            this.display.teleport(location, bundler);
        }
        this.forEachChildren(e -> e.teleport(location, bundler));
    }

    public void spawn(@NotNull PacketBundler bundler) {
        if (this.display != null) {
            this.display.spawn(bundler);
        }
        this.forEachChildren(e -> e.spawn(bundler));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLoop(@NotNull Predicate<RenderedEntity> filter, @NotNull String parent, @NotNull BlueprintAnimation animator, AnimationModifier modifier, Runnable removeTask) {
        if (filter.test(this)) {
            BlueprintAnimator get = animator.animator().get(this.getName());
            TreeIterator iterator2 = get != null ? new TreeIterator(parent, get.loopIterator(), modifier, removeTask) : new TreeIterator(parent, animator.emptyLoopIterator(), modifier, removeTask);
            SequencedMap<String, TreeIterator> sequencedMap = this.animators;
            synchronized (sequencedMap) {
                this.animators.putLast(parent, iterator2);
            }
        }
        this.forEachChildren(e -> e.addLoop(filter, parent, animator, modifier, () -> {}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSingle(@NotNull Predicate<RenderedEntity> filter, @NotNull String parent, @NotNull BlueprintAnimation animator, AnimationModifier modifier, Runnable removeTask) {
        if (filter.test(this)) {
            BlueprintAnimator get = animator.animator().get(this.getName());
            TreeIterator iterator2 = get != null ? new TreeIterator(parent, get.singleIterator(), modifier, removeTask) : new TreeIterator(parent, animator.emptySingleIterator(), modifier, removeTask);
            SequencedMap<String, TreeIterator> sequencedMap = this.animators;
            synchronized (sequencedMap) {
                this.animators.putLast(parent, iterator2);
            }
        }
        this.forEachChildren(e -> e.addSingle(filter, parent, animator, modifier, () -> {}));
    }

    public void replaceModifier(@NotNull Predicate<RenderedEntity> filter, @NotNull Function<AnimationModifier, AnimationModifier> function) {
        TreeIterator get;
        if (filter.test(this) && (get = (TreeIterator)this.animators.get(this.getName())) != null) {
            get.modifier = Objects.requireNonNull(function.apply(get.modifier));
        }
        this.forEachChildren(e -> e.replaceModifier(filter, function));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replaceLoop(@NotNull Predicate<RenderedEntity> filter, @NotNull String target, @NotNull String parent, @NotNull BlueprintAnimation animator) {
        if (filter.test(this)) {
            BlueprintAnimator get = animator.animator().get(this.getName());
            SequencedMap<String, TreeIterator> sequencedMap = this.animators;
            synchronized (sequencedMap) {
                TreeIterator v = (TreeIterator)this.animators.get(target);
                if (v != null) {
                    this.animators.replace(target, get != null ? new TreeIterator(parent, get.loopIterator(), v.modifier, v.removeTask) : new TreeIterator(parent, animator.emptyLoopIterator(), v.modifier, v.removeTask));
                } else {
                    this.animators.replace(target, get != null ? new TreeIterator(parent, get.loopIterator(), AnimationModifier.DEFAULT_LOOP, () -> {}) : new TreeIterator(parent, animator.emptyLoopIterator(), AnimationModifier.DEFAULT_LOOP, () -> {}));
                }
            }
        }
        this.forEachChildren(e -> e.replaceLoop(filter, target, parent, animator));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replaceSingle(@NotNull Predicate<RenderedEntity> filter, @NotNull String target, @NotNull String parent, @NotNull BlueprintAnimation animator) {
        if (filter.test(this)) {
            BlueprintAnimator get = animator.animator().get(this.getName());
            SequencedMap<String, TreeIterator> sequencedMap = this.animators;
            synchronized (sequencedMap) {
                TreeIterator v = (TreeIterator)this.animators.get(target);
                if (v != null) {
                    this.animators.replace(target, get != null ? new TreeIterator(parent, get.singleIterator(), v.modifier, v.removeTask) : new TreeIterator(parent, animator.emptySingleIterator(), v.modifier, v.removeTask));
                } else {
                    this.animators.replace(target, get != null ? new TreeIterator(parent, get.singleIterator(), AnimationModifier.DEFAULT, () -> {}) : new TreeIterator(parent, animator.emptySingleIterator(), AnimationModifier.DEFAULT, () -> {}));
                }
            }
        }
        this.forEachChildren(e -> e.replaceSingle(filter, target, parent, animator));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopAnimation(@NotNull Predicate<RenderedEntity> filter, @NotNull String parent) {
        if (filter.test(this)) {
            SequencedMap<String, TreeIterator> sequencedMap = this.animators;
            synchronized (sequencedMap) {
                this.animators.remove(parent);
            }
        }
        this.forEachChildren(e -> e.stopAnimation(filter, parent));
    }

    public void remove(@NotNull PacketBundler bundler) {
        if (this.display != null) {
            this.display.remove(bundler);
        }
        this.forEachChildren(e -> e.remove(bundler));
    }

    public void togglePart(@NotNull PacketBundler bundler, @NotNull Predicate<RenderedEntity> predicate, boolean toggle) {
        if (predicate.test(this)) {
            TransformedItemStack transformedItemStack = this.itemStack = toggle ? this.cachedStack : TransformedItemStack.EMPTY;
            if (this.applyItem()) {
                this.forceUpdate0(bundler);
            }
        }
        this.forEachChildren(e -> e.togglePart(bundler, predicate, toggle));
    }

    private void forEachChildren(@NotNull Consumer<RenderedEntity> consumer) {
        this.children.values().forEach(consumer);
    }

    @Override
    @NotNull
    public Vector3f hitBoxPosition() {
        NamedBoundingBox hitBox = this.group.getHitBox();
        return this.worldPosition(hitBox != null ? hitBox.centerVector() : new Vector3f());
    }

    @Override
    @NotNull
    public ModelRotation hitBoxRotation() {
        return this.rotation;
    }

    @Override
    public void close() throws Exception {
        if (this.hitBox != null) {
            this.hitBox.removeHitBox();
        }
        for (RenderedEntity value : this.children.values()) {
            value.close();
        }
    }

    @Generated
    public RendererGroup getGroup() {
        return this.group;
    }

    @Generated
    public ModelDisplay getDisplay() {
        return this.display;
    }

    @Generated
    public void setChildren(Map<String, RenderedEntity> children) {
        this.children = children;
    }

    @Generated
    public HitBox getHitBox() {
        return this.hitBox;
    }

    private static class TreeIterator
    implements BlueprintAnimator.AnimatorIterator,
    Supplier<Boolean>,
    Runnable {
        private final String name;
        private final BlueprintAnimator.AnimatorIterator iterator;
        private AnimationModifier modifier;
        private final Runnable removeTask;
        private boolean started = false;
        private boolean ended = false;
        private float cachedSpeed = 1.0f;

        public TreeIterator(String name, BlueprintAnimator.AnimatorIterator iterator2, AnimationModifier modifier, Runnable removeTask) {
            this.name = name;
            this.iterator = iterator2;
            this.modifier = modifier;
            this.removeTask = removeTask;
        }

        @Override
        @NotNull
        public AnimationMovement first() {
            return this.iterator.first();
        }

        @Override
        public int index() {
            return this.iterator.index();
        }

        @Override
        public int lastIndex() {
            return this.iterator.lastIndex();
        }

        @Override
        public void run() {
            this.removeTask.run();
        }

        @Override
        public Boolean get() {
            return this.modifier.predicate().get();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext() || this.modifier.end() > 0 && !this.ended;
        }

        public float deltaSpeed() {
            float previous = this.cachedSpeed;
            this.cachedSpeed = this.modifier.speedValue();
            return this.cachedSpeed / previous;
        }

        @Override
        public AnimationMovement next() {
            if (!this.started) {
                this.started = true;
                return this.first().time((float)this.modifier.start() / 20.0f);
            }
            if (!this.iterator.hasNext()) {
                this.ended = true;
                return new AnimationMovement((float)this.modifier.end() / 20.0f, null, null, null);
            }
            AnimationMovement nxt = (AnimationMovement)this.iterator.next();
            this.cachedSpeed = this.modifier.speedValue();
            nxt = nxt.time(Math.max(nxt.time() / this.cachedSpeed, 0.01f));
            return nxt;
        }

        @Override
        public void clear() {
            this.iterator.clear();
            this.ended = !this.iterator.hasNext();
            this.started = this.ended;
        }

        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TreeIterator that = (TreeIterator)o;
            return Objects.equals(this.name, that.name);
        }

        public int hashCode() {
            return Objects.hashCode(this.name);
        }
    }
}

