/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.data.raw;

import com.google.gson.JsonDeserializer;
import com.vdurmont.semver4j.Semver;
import java.util.Arrays;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;

public record ModelMeta(@NotNull FormatVersion formatVersion) {
    public static final JsonDeserializer<ModelMeta> PARSER = (json, type, context) -> new ModelMeta(FormatVersion.find(new Semver(json.getAsJsonObject().getAsJsonPrimitive("format_version").getAsString(), Semver.SemverType.LOOSE).getMajor()));

    public static enum FormatVersion {
        BLOCKBENCH_5(5){

            @Override
            @NotNull
            public Vector3f convertAnimationRotation(@NotNull Vector3f vector) {
                vector.x = -vector.x;
                vector.z = -vector.z;
                return vector;
            }

            @Override
            @NotNull
            public Vector3f convertAnimationPosition(@NotNull Vector3f vector) {
                vector.x = -vector.x;
                vector.z = -vector.z;
                return vector.div(16.0f);
            }
        }
        ,
        BLOCKBENCH_LEGACY(0){

            @Override
            @NotNull
            public Vector3f convertAnimationRotation(@NotNull Vector3f vector) {
                vector.y = -vector.y;
                vector.z = -vector.z;
                return vector;
            }

            @Override
            @NotNull
            public Vector3f convertAnimationPosition(@NotNull Vector3f vector) {
                vector.z = -vector.z;
                return vector.div(16.0f);
            }
        };

        private final int major;

        @NotNull
        public static FormatVersion find(int major) {
            return Arrays.stream(FormatVersion.values()).filter(v -> v.major <= major).findFirst().orElseThrow();
        }

        @NotNull
        public abstract Vector3f convertAnimationRotation(@NotNull Vector3f var1);

        @NotNull
        public abstract Vector3f convertAnimationPosition(@NotNull Vector3f var1);

        @Generated
        private FormatVersion(int major) {
            this.major = major;
        }
    }
}

