/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.data.raw;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import kr.toxicity.model.api.data.raw.ModelElement;
import kr.toxicity.model.api.data.raw.ModelGroup;
import kr.toxicity.model.api.data.raw.ModelMeta;
import kr.toxicity.model.api.data.raw.ModelPlaceholder;
import lombok.Generated;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class ModelLoadContext {
    @NotNull
    final ModelPlaceholder placeholder;
    @NotNull
    final ModelMeta meta;
    @NotNull
    final Map<String, ModelElement> elements;
    @NotNull
    final Map<String, ModelGroup> groups;
    private final boolean strict;
    private final List<String> _errors = new ArrayList<String>();
    final List<String> errors = Collections.unmodifiableList(this._errors);

    @NotNull
    <T> T trySupply(@NotNull Supplier<T> supplier, @NotNull Function<Exception, Fallback<T>> fallbackFunction) {
        if (this.strict) {
            return supplier.get();
        }
        try {
            return supplier.get();
        }
        catch (Exception e) {
            Fallback<T> fallback = fallbackFunction.apply(e);
            this._errors.add(fallback.message);
            return fallback.value;
        }
    }

    @Generated
    public ModelLoadContext(@NotNull ModelPlaceholder placeholder, @NotNull ModelMeta meta, @NotNull Map<String, ModelElement> elements, @NotNull Map<String, ModelGroup> groups, boolean strict) {
        if (placeholder == null) {
            throw new NullPointerException("placeholder is marked non-null but is null");
        }
        if (meta == null) {
            throw new NullPointerException("meta is marked non-null but is null");
        }
        if (elements == null) {
            throw new NullPointerException("elements is marked non-null but is null");
        }
        if (groups == null) {
            throw new NullPointerException("groups is marked non-null but is null");
        }
        this.placeholder = placeholder;
        this.meta = meta;
        this.elements = elements;
        this.groups = groups;
        this.strict = strict;
    }

    record Fallback<T>(@NotNull T value, @NotNull String message) {
    }
}

