/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.pack;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.google.gson.annotations.SerializedName;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import kr.toxicity.model.api.BetterModel;
import kr.toxicity.model.api.nms.NMSVersion;
import kr.toxicity.model.api.pack.PackPath;
import kr.toxicity.model.api.pack.PackResource;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record PackMeta(@NotNull Pack pack, @Nullable Overlay overlays) {
    public static final PackPath PATH = new PackPath("pack.mcmeta");
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(PackVersion.class, (json, typeOfT, context) -> {
        if (json.isJsonPrimitive()) {
            return new PackVersion(json.getAsInt());
        }
        if (json.isJsonArray()) {
            JsonArray array = json.getAsJsonArray();
            return new PackVersion(array.get(0).getAsInt(), array.size() < 2 ? 0 : array.get(1).getAsInt());
        }
        return null;
    }).registerTypeAdapter(PackVersion.class, (src, typeOfSrc, context) -> src.toJson()).registerTypeAdapter(VersionRange.class, (json, typeOfT, context) -> {
        if (json.isJsonPrimitive()) {
            return new VersionRange(json.getAsInt());
        }
        if (json.isJsonArray()) {
            JsonArray array = json.getAsJsonArray();
            return new VersionRange(array.get(0).getAsInt(), array.get(1).getAsInt());
        }
        if (json.isJsonObject()) {
            return (VersionRange)context.deserialize(json, VersionRange.class);
        }
        return null;
    }).registerTypeAdapter(VersionRange.class, (src, typeOfSrc, context) -> src.toJson()).create();

    @NotNull
    public static Builder builder() {
        return new Builder();
    }

    @NotNull
    public JsonElement toJson() {
        return GSON.toJsonTree((Object)this);
    }

    @NotNull
    public PackResource toResource() {
        String json = GSON.toJson((Object)this);
        return PackResource.of(PATH, 2L * (long)json.length(), () -> json.getBytes(StandardCharsets.UTF_8));
    }

    public record Pack(@SerializedName(value="pack_format") int packFormat, @SerializedName(value="description") @NotNull String description, @SerializedName(value="supported_formats") @NotNull VersionRange supportedFormats, @SerializedName(value="min_format") @NotNull PackVersion minFormat, @SerializedName(value="max_format") @NotNull PackVersion maxFormat) {
    }

    public record Overlay(@Nullable List<OverlayEntry> entries) {
    }

    public static final class Builder {
        private int format = BetterModel.nms().version().getMetaVersion();
        private String description = "BetterModel's default pack.";
        private final List<OverlayEntry> entries = new ArrayList<OverlayEntry>();
        private VersionRange supportedFormats = VersionRange.LEGACY;
        private PackVersion minFormat = new PackVersion(NMSVersion.first().getMetaVersion());
        private PackVersion maxFormat = new PackVersion(NMSVersion.latest().getMetaVersion());

        @NotNull
        public Builder description(@NotNull String description) {
            this.description = Objects.requireNonNull(description, "description");
            return this;
        }

        @NotNull
        public Builder format(int format) {
            this.format = format;
            return this;
        }

        @NotNull
        public Builder overlayEntry(@NotNull OverlayEntry overlayEntry) {
            this.entries.add(overlayEntry);
            return this;
        }

        @NotNull
        public Builder supportedFormats(@NotNull VersionRange range) {
            this.supportedFormats = Objects.requireNonNull(range);
            return this;
        }

        @NotNull
        public Builder minFormat(@NotNull PackVersion version) {
            this.minFormat = Objects.requireNonNull(version);
            return this;
        }

        @NotNull
        public Builder maxFormat(@NotNull PackVersion version) {
            this.maxFormat = Objects.requireNonNull(version);
            return this;
        }

        @NotNull
        public PackMeta build() {
            return new PackMeta(new Pack(this.format, this.description, this.supportedFormats, this.minFormat, this.maxFormat), this.entries.isEmpty() ? null : new Overlay(this.entries));
        }

        @Generated
        private Builder() {
        }
    }

    public record VersionRange(@SerializedName(value="min_inclusive") int minInclusive, @SerializedName(value="max_inclusive") int maxInclusive) {
        public static final VersionRange LEGACY = new VersionRange(NMSVersion.first().getMetaVersion(), 64);

        public VersionRange(int value) {
            this(value, value);
        }

        @NotNull
        public JsonElement toJson() {
            if (this.minInclusive == this.maxInclusive) {
                return new JsonPrimitive((Number)this.minInclusive);
            }
            JsonArray arr = new JsonArray(2);
            arr.add((Number)this.minInclusive);
            arr.add((Number)this.maxInclusive);
            return arr;
        }
    }

    public record PackVersion(int major, int minor) {
        public PackVersion(int major) {
            this(major, 0);
        }

        @NotNull
        public JsonElement toJson() {
            if (this.minor <= 0) {
                return new JsonPrimitive((Number)this.major);
            }
            JsonArray array = new JsonArray(2);
            array.add((Number)this.major);
            array.add((Number)this.minor);
            return array;
        }
    }

    public record OverlayEntry(@NotNull VersionRange formats, @NotNull String directory, @SerializedName(value="min_format") @NotNull PackVersion minFormat, @SerializedName(value="max_format") @NotNull PackVersion maxFormat) {
        public OverlayEntry(@NotNull VersionRange formats, @NotNull String directory) {
            this(formats, directory, new PackVersion(formats.minInclusive), new PackVersion(formats.maxInclusive));
        }
    }
}

