/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.manager;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import kr.toxicity.model.api.scheduler.ModelTask;
import kr.toxicity.model.manager.debug.ReloadIndicator;
import kr.toxicity.model.shaded.kotlin.Metadata;
import kr.toxicity.model.shaded.kotlin.Unit;
import kr.toxicity.model.shaded.kotlin.jvm.functions.Function1;
import kr.toxicity.model.shaded.kotlin.jvm.internal.Intrinsics;
import kr.toxicity.model.shaded.kotlin.jvm.internal.SourceDebugExtension;
import kr.toxicity.model.util.CollectionsKt;
import kr.toxicity.model.util.ParallelIOThreadPool;
import kr.toxicity.model.util.PluginsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00060\u0001j\u0002`\u0002:\u0001(B\u0015\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\u0019\u001a\u00020\u0013JB\u0010\u001a\u001a\u00020\u001b\"\u0004\b\u0000\u0010\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u0002H\u001c0\u00042\u0012\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u0002H\u001c\u0012\u0004\u0012\u00020 0\u001f2\u0012\u0010!\u001a\u000e\u0012\u0004\u0012\u0002H\u001c\u0012\u0004\u0012\u00020\u001b0\u001fJP\u0010\"\u001a\b\u0012\u0004\u0012\u0002H#0\u0004\"\u0004\b\u0000\u0010\u001c\"\u0004\b\u0001\u0010#2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u0002H\u001c0\u00042\u0012\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u0002H\u001c\u0012\u0004\u0012\u00020 0\u001f2\u0014\u0010!\u001a\u0010\u0012\u0004\u0012\u0002H\u001c\u0012\u0006\u0012\u0004\u0018\u0001H#0\u001fJ\b\u0010'\u001a\u00020\u001bH\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0012\u001a\u00020\u0013@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u0013\u0010$\u001a\u00070%\u00a2\u0006\u0002\b&X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lkr/toxicity/model/manager/ReloadPipeline;", "Ljava/lang/AutoCloseable;", "Lkr/toxicity/model/shaded/kotlin/AutoCloseable;", "indicators", "", "Lkr/toxicity/model/manager/debug/ReloadIndicator;", "<init>", "(Ljava/util/List;)V", "status", "", "getStatus", "()Ljava/lang/String;", "setStatus", "(Ljava/lang/String;)V", "pool", "Lkr/toxicity/model/util/ParallelIOThreadPool;", "current", "Ljava/util/concurrent/atomic/AtomicInteger;", "value", "", "goal", "getGoal", "()I", "setGoal", "(I)V", "progress", "forEachParallel", "", "T", "list", "sizeAssume", "Lkr/toxicity/model/shaded/kotlin/Function1;", "", "block", "mapParallel", "R", "task", "Lkr/toxicity/model/api/scheduler/ModelTask;", "Lorg/jetbrains/annotations/NotNull;", "close", "Status", "core"})
@SourceDebugExtension(value={"SMAP\nReloadPipeline.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReloadPipeline.kt\nkr/toxicity/model/manager/ReloadPipeline\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,70:1\n1869#2,2:71\n1869#2,2:74\n1#3:73\n*S KotlinDebug\n*F\n+ 1 ReloadPipeline.kt\nkr/toxicity/model/manager/ReloadPipeline\n*L\n67#1:71,2\n52#1:74,2\n*E\n"})
public final class ReloadPipeline
implements AutoCloseable {
    @NotNull
    private final List<ReloadIndicator> indicators;
    @NotNull
    private String status;
    @NotNull
    private final ParallelIOThreadPool pool;
    @NotNull
    private final AtomicInteger current;
    private int goal;
    @NotNull
    private final ModelTask task;

    public ReloadPipeline(@NotNull List<? extends ReloadIndicator> indicators) {
        Intrinsics.checkNotNullParameter(indicators, (String)"indicators");
        this.indicators = indicators;
        this.status = "Starting...";
        this.pool = CollectionsKt.parallelIOThreadPool();
        this.current = new AtomicInteger();
        ModelTask modelTask = PluginsKt.getPLUGIN().scheduler().asyncTaskTimer(1L, 1L, () -> ReloadPipeline.task$lambda$0(this));
        Intrinsics.checkNotNullExpressionValue((Object)modelTask, (String)"asyncTaskTimer(...)");
        this.task = modelTask;
    }

    @NotNull
    public final String getStatus() {
        return this.status;
    }

    public final void setStatus(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.status = string;
    }

    public final int getGoal() {
        return this.goal;
    }

    public final void setGoal(int value) {
        this.goal = value;
        this.current.set(0);
    }

    public final int progress() {
        return this.current.incrementAndGet();
    }

    public final <T> void forEachParallel(@NotNull List<? extends T> list, @NotNull Function1<? super T, Long> sizeAssume, @NotNull Function1<? super T, Unit> block) {
        Intrinsics.checkNotNullParameter(list, (String)"list");
        Intrinsics.checkNotNullParameter(sizeAssume, (String)"sizeAssume");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        this.pool.forEachParallel(list, sizeAssume, block);
    }

    @NotNull
    public final <T, R> List<R> mapParallel(@NotNull List<? extends T> list, @NotNull Function1<? super T, Long> sizeAssume, @NotNull Function1<? super T, ? extends R> block) {
        CopyOnWriteArrayList copyOnWriteArrayList;
        Intrinsics.checkNotNullParameter(list, (String)"list");
        Intrinsics.checkNotNullParameter(sizeAssume, (String)"sizeAssume");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        CopyOnWriteArrayList $this$mapParallel_u24lambda_u240 = copyOnWriteArrayList = new CopyOnWriteArrayList();
        boolean bl = false;
        this.forEachParallel(list, sizeAssume, arg_0 -> ReloadPipeline.mapParallel$lambda$0$0(block, $this$mapParallel_u24lambda_u240, arg_0));
        return copyOnWriteArrayList;
    }

    @Override
    public void close() {
        this.task.cancel();
        Iterable $this$forEach$iv = this.indicators;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ReloadIndicator p0 = (ReloadIndicator)element$iv;
            boolean bl = false;
            p0.close();
        }
        this.pool.close();
    }

    private static final Unit mapParallel$lambda$0$0(Function1 $block, CopyOnWriteArrayList $this_apply, Object t) {
        block0: {
            Object object = $block.invoke(t);
            if (object == null) break block0;
            Object it = object;
            boolean bl = false;
            $this_apply.add(it);
        }
        return Unit.INSTANCE;
    }

    private static final void task$lambda$0(ReloadPipeline this$0) {
        int $this$task_u24lambda_u240_u240 = this$0.current.get();
        boolean bl = false;
        Status $this$task_u24lambda_u240_u241 = new Status(this$0.goal > 0 ? (float)$this$task_u24lambda_u240_u240 / (float)this$0.goal : 0.0f, $this$task_u24lambda_u240_u240, this$0.goal, this$0.status);
        boolean bl2 = false;
        Iterable $this$forEach$iv = this$0.indicators;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ReloadIndicator it = (ReloadIndicator)element$iv;
            boolean bl3 = false;
            it.status($this$task_u24lambda_u240_u241);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\bH\u00c6\u0003J1\u0010\u0016\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\bH\u00c6\u0001J\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u001b\u001a\u00020\bH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001c"}, d2={"Lkr/toxicity/model/manager/ReloadPipeline$Status;", "", "progress", "", "current", "", "goal", "status", "", "<init>", "(FIILjava/lang/String;)V", "getProgress", "()F", "getCurrent", "()I", "getGoal", "getStatus", "()Ljava/lang/String;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "toString", "core"})
    public static final class Status {
        private final float progress;
        private final int current;
        private final int goal;
        @NotNull
        private final String status;

        public Status(float progress, int current, int goal, @NotNull String status) {
            Intrinsics.checkNotNullParameter((Object)status, (String)"status");
            this.progress = progress;
            this.current = current;
            this.goal = goal;
            this.status = status;
        }

        public final float getProgress() {
            return this.progress;
        }

        public final int getCurrent() {
            return this.current;
        }

        public final int getGoal() {
            return this.goal;
        }

        @NotNull
        public final String getStatus() {
            return this.status;
        }

        public final float component1() {
            return this.progress;
        }

        public final int component2() {
            return this.current;
        }

        public final int component3() {
            return this.goal;
        }

        @NotNull
        public final String component4() {
            return this.status;
        }

        @NotNull
        public final Status copy(float progress, int current, int goal, @NotNull String status) {
            Intrinsics.checkNotNullParameter((Object)status, (String)"status");
            return new Status(progress, current, goal, status);
        }

        public static /* synthetic */ Status copy$default(Status status, float f, int n, int n2, String string, int n3, Object object) {
            if ((n3 & 1) != 0) {
                f = status.progress;
            }
            if ((n3 & 2) != 0) {
                n = status.current;
            }
            if ((n3 & 4) != 0) {
                n2 = status.goal;
            }
            if ((n3 & 8) != 0) {
                string = status.status;
            }
            return status.copy(f, n, n2, string);
        }

        @NotNull
        public String toString() {
            return "Status(progress=" + this.progress + ", current=" + this.current + ", goal=" + this.goal + ", status=" + this.status + ")";
        }

        public int hashCode() {
            int result = Float.hashCode(this.progress);
            result = result * 31 + Integer.hashCode(this.current);
            result = result * 31 + Integer.hashCode(this.goal);
            result = result * 31 + this.status.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Status)) {
                return false;
            }
            Status status = (Status)other;
            if (Float.compare(this.progress, status.progress) != 0) {
                return false;
            }
            if (this.current != status.current) {
                return false;
            }
            if (this.goal != status.goal) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.status, (Object)status.status);
        }
    }
}

