/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.shaded.kr.toxicity.library.armormodel;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import it.unimi.dsi.fastutil.ints.Int2ObjectAVLTreeMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.awt.image.BufferedImage;
import kr.toxicity.model.shaded.kr.toxicity.library.armormodel.ArmorColor;
import kr.toxicity.model.shaded.kr.toxicity.library.armormodel.ArmorDataContext;
import kr.toxicity.model.shaded.kr.toxicity.library.armormodel.ArmorImage;
import kr.toxicity.model.shaded.kr.toxicity.library.armormodel.ArmorModelContext;
import kr.toxicity.model.shaded.kr.toxicity.library.armormodel.ArmorUtil;
import org.jetbrains.annotations.NotNull;

enum ArmorImageProcessor {
    ARMOR{

        @Override
        public void process(@NotNull ArmorImage image, @NotNull ArmorModelContext context) {
            String armorName = image.armorName();
            String leggingsName = image.leggingsName();
            context.namespace.textures.add(context.textureName(armorName) + ".png", image.armor());
            context.namespace.textures.add(context.textureName(leggingsName) + ".png", image.leggings());
            for (ArmorDataContext datum : context.data) {
                String modelName = image.name() + "_" + datum.resource.name().toLowerCase();
                context.namespace.models.add(context.modelName(modelName) + ".json", datum.data.ofTextures(context.textureNamespace(armorName), context.textureNamespace(leggingsName)));
                datum.armors.add((JsonElement)ArmorUtil.whenJson(image.name(), ArmorUtil.modelJson(context.modelNamespace(modelName), 0)));
            }
        }
    }
    ,
    ARMOR_TRIM{
        private static final int[] TRIM_PALETTE_ARRAY = new int[]{1, 2, 3, 4, 5, 6, 7, 8};

        @Override
        void process(@NotNull ArmorImage image, @NotNull ArmorModelContext context) {
            String armorName = image.armorName();
            String leggingsName = image.leggingsName();
            Int2ObjectMap<BufferedImage> armorSplit = 2.splitTrimImage(image.armor());
            Int2ObjectMap<BufferedImage> leggingsSplit = 2.splitTrimImage(image.leggings());
            for (int i : TRIM_PALETTE_ARRAY) {
                context.namespace.textures.add(context.textureName(armorName + "_" + i) + ".png", (BufferedImage)armorSplit.get(i));
                context.namespace.textures.add(context.textureName(leggingsName + "_" + i) + ".png", (BufferedImage)leggingsSplit.get(i));
            }
            Object object = context.data.iterator();
            while (object.hasNext()) {
                ArmorDataContext datum = (ArmorDataContext)object.next();
                String modelName = image.name() + "_" + datum.resource.name().toLowerCase();
                JsonArray array = new JsonArray();
                for (int i : TRIM_PALETTE_ARRAY) {
                    String subModelName = modelName + "_" + i;
                    context.namespace.models.add(context.modelName(subModelName) + ".json", datum.data.ofTextures(context.textureNamespace(armorName + "_" + i), context.textureNamespace(leggingsName + "_" + i)));
                    array.add((JsonElement)ArmorUtil.modelJson(context.modelNamespace(subModelName), i));
                }
                datum.armorTrims.add((JsonElement)ArmorUtil.whenJson(image.name(), ArmorUtil.compositeJson(array)));
            }
        }

        @NotNull
        private static Int2ObjectMap<BufferedImage> splitTrimImage(@NotNull BufferedImage image) {
            int width = image.getWidth();
            int height = image.getHeight();
            Int2ObjectAVLTreeMap map = new Int2ObjectAVLTreeMap();
            for (int i : TRIM_PALETTE_ARRAY) {
                map.put(i, (Object)new BufferedImage(width, height, 2));
            }
            int white = ArmorColor.WHITE.value();
            for (int w = 0; w < width; ++w) {
                for (int h = 0; h < height; ++h) {
                    ArmorColor color = ArmorColor.from(image.getRGB(w, h));
                    if (color.a() < 255) continue;
                    assert (color.r() % 32 == 0 && color.g() % 32 == 0 && color.b() % 32 == 0);
                    ((BufferedImage)map.get(8 - color.avg() / 32)).setRGB(w, h, white);
                }
            }
            return map;
        }
    };


    abstract void process(@NotNull ArmorImage var1, @NotNull ArmorModelContext var2);
}

