/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.animation;

import java.util.List;
import kr.toxicity.model.api.animation.Timed;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;
import org.joml.Vector3f;

public record AnimationMovement(float time, @Nullable Vector3f position, @Nullable Vector3f scale, @Nullable Vector3f rotation) implements Timed
{
    public static final AnimationMovement EMPTY = new AnimationMovement(0.0f);

    public AnimationMovement(float time) {
        this(time, null, null, null);
    }

    @NotNull
    public static @Unmodifiable List<AnimationMovement> withEmpty(float length) {
        return List.of(EMPTY, new AnimationMovement(length));
    }

    @NotNull
    public AnimationMovement empty() {
        if (!this.hasKeyframe()) {
            return this;
        }
        return this.time <= 0.0f ? EMPTY : new AnimationMovement(this.time);
    }

    public boolean hasKeyframe() {
        return this.position != null || this.scale != null || this.rotation != null;
    }

    @NotNull
    public AnimationMovement time(float newTime) {
        if (this.time == newTime) {
            return this;
        }
        return new AnimationMovement(newTime, this.position, this.scale, this.rotation);
    }
}

