/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.data.raw;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import kr.toxicity.model.api.BetterModel;
import kr.toxicity.model.api.animation.AnimationIterator;
import kr.toxicity.model.api.animation.AnimationMovement;
import kr.toxicity.model.api.bone.BoneName;
import kr.toxicity.model.api.bone.BoneTagRegistry;
import kr.toxicity.model.api.data.blueprint.AnimationGenerator;
import kr.toxicity.model.api.data.blueprint.BlueprintAnimation;
import kr.toxicity.model.api.data.blueprint.BlueprintAnimator;
import kr.toxicity.model.api.data.blueprint.BlueprintChildren;
import kr.toxicity.model.api.data.raw.ModelAnimator;
import kr.toxicity.model.api.data.raw.ModelKeyframe;
import kr.toxicity.model.api.data.raw.ModelPlaceholder;
import kr.toxicity.model.api.script.AnimationScript;
import kr.toxicity.model.api.script.BlueprintScript;
import kr.toxicity.model.api.script.TimeScript;
import kr.toxicity.model.api.util.CollectionUtil;
import kr.toxicity.model.api.util.InterpolationUtil;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public record ModelAnimation(@NotNull String name, @Nullable AnimationIterator.Type loop, boolean override, @NotNull String uuid, float length, @Nullable Map<String, ModelAnimator> animators) {
    @Nullable
    private final AnimationIterator.Type loop;
    @Nullable
    private final Map<String, ModelAnimator> animators;

    @NotNull
    public BlueprintAnimation toBlueprint(@NotNull List<BlueprintChildren> children, @NotNull ModelPlaceholder placeholder) {
        HashMap<String, ModelAnimator> map = new HashMap<String, ModelAnimator>(this.animators());
        BlueprintScript script = Optional.ofNullable(map.remove("effects")).map(a -> this.toScript((ModelAnimator)a, placeholder)).orElseGet(() -> BlueprintScript.fromEmpty(this));
        Map<BoneName, BlueprintAnimator> animators = AnimationGenerator.createMovements(this.length(), children, CollectionUtil.associate(map.values().stream().filter(ModelAnimator::hasName), e -> BoneTagRegistry.parse(e.name()), e -> {
            BlueprintAnimator.Builder builder = new BlueprintAnimator.Builder(this.length());
            e.stream().sorted().forEach(keyframe -> builder.addFrame((ModelKeyframe)keyframe, placeholder));
            return builder.build(this.name());
        }));
        return new BlueprintAnimation(this.name(), this.loop(), this.length(), this.override(), animators, script, animators.isEmpty() ? AnimationMovement.withEmpty(this.length()) : animators.values().iterator().next().keyframe().stream().map(AnimationMovement::empty).toList());
    }

    @NotNull
    private BlueprintScript toScript(@NotNull ModelAnimator animator, @NotNull ModelPlaceholder placeholder) {
        List<TimeScript> get = animator.stream().filter(f -> f.point().hasScript()).map(d -> AnimationScript.of(Arrays.stream(placeholder.parseVariable(d.point().script()).split("\n")).map(BetterModel.plugin().scriptManager()::build).filter(Objects::nonNull).toList()).time(d.time())).sorted().toList();
        ArrayList<TimeScript> list = new ArrayList<TimeScript>(get.size() + 2);
        if (get.getFirst().time() > 0.0f) {
            list.add(TimeScript.EMPTY);
        }
        float before = 0.0f;
        for (TimeScript timeScript : get) {
            float t = timeScript.time();
            list.add(timeScript.time(InterpolationUtil.roundTime(t - before)));
            before = t;
        }
        float len = InterpolationUtil.roundTime(this.length() - before);
        if (len > 0.0f) {
            list.add(AnimationScript.EMPTY.time(len));
        }
        return new BlueprintScript(this.name(), this.loop(), this.length(), list);
    }

    @NotNull
    public AnimationIterator.Type loop() {
        return this.loop != null ? this.loop : AnimationIterator.Type.PLAY_ONCE;
    }

    @NotNull
    public Map<String, ModelAnimator> animators() {
        return this.animators != null ? this.animators : Collections.emptyMap();
    }
}

