/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.data.raw;

import com.google.gson.JsonDeserializer;
import com.google.gson.annotations.SerializedName;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kr.toxicity.model.api.bone.BoneTagRegistry;
import kr.toxicity.model.api.data.blueprint.BlueprintChildren;
import kr.toxicity.model.api.data.raw.Float3;
import kr.toxicity.model.api.data.raw.ModelElement;
import kr.toxicity.model.api.util.CollectionUtil;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

@ApiStatus.Internal
public sealed interface ModelChildren {
    public static final JsonDeserializer<ModelChildren> PARSER = (json, typeOfT, context) -> {
        if (json.isJsonPrimitive()) {
            return new ModelUUID(json.getAsString());
        }
        if (json.isJsonObject()) {
            return (ModelChildren)context.deserialize(json, ModelGroup.class);
        }
        throw new RuntimeException();
    };

    @NotNull
    public BlueprintChildren toBlueprint(@NotNull @Unmodifiable Map<String, ModelElement> var1);

    public record ModelUUID(@NotNull String uuid) implements ModelChildren
    {
        @Override
        @NotNull
        public BlueprintChildren toBlueprint(@NotNull @Unmodifiable Map<String, ModelElement> elementMap) {
            return new BlueprintChildren.BlueprintElement(Objects.requireNonNull(elementMap.get(this.uuid())));
        }
    }

    public record ModelGroup(@NotNull String name, @Nullable Float3 origin, @Nullable Float3 rotation, @NotNull String uuid, @NotNull List<ModelChildren> children, @SerializedName(value="visibility") @Nullable Boolean _visibility) implements ModelChildren
    {
        @Nullable
        private final Float3 origin;
        @Nullable
        private final Float3 rotation;

        @NotNull
        public Float3 origin() {
            return this.origin != null ? this.origin : Float3.ZERO;
        }

        @NotNull
        public Float3 rotation() {
            return this.rotation != null ? this.rotation : Float3.ZERO;
        }

        public boolean visibility() {
            return !Boolean.FALSE.equals(this._visibility);
        }

        @Override
        @NotNull
        public BlueprintChildren toBlueprint(@NotNull @Unmodifiable Map<String, ModelElement> elementMap) {
            List<BlueprintChildren> child = CollectionUtil.mapToList(this.children, c2 -> c2.toBlueprint(elementMap));
            List<BlueprintChildren.BlueprintElement> filtered = CollectionUtil.filterIsInstance(child, BlueprintChildren.BlueprintElement.class).toList();
            return new BlueprintChildren.BlueprintGroup(BoneTagRegistry.parse(this.name()), this.origin(), this.rotation().invertXZ(), child, filtered.isEmpty() ? this.visibility() : filtered.stream().anyMatch(element -> element.element().visibility()));
        }
    }
}

