/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.BooleanSupplier;
import java.util.stream.Stream;
import kr.toxicity.model.AbstractBetterModelPlugin;
import kr.toxicity.model.api.BetterModel;
import kr.toxicity.model.api.util.function.BooleanConstantSupplier;
import kr.toxicity.model.shaded.net.byteflux.libby.BukkitLibraryManager;
import kr.toxicity.model.shaded.net.byteflux.libby.Library;
import kr.toxicity.model.shaded.net.byteflux.libby.relocation.Relocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public final class BetterModelLibrary {
    private static final String KOTLIN_RELOCATED = "_kotlin".substring(1);
    public static final LibraryData KOTLIN = new LibraryData("org{}jetbrains{}kotlin", KOTLIN_RELOCATED + "-stdlib", KOTLIN_RELOCATED);
    public static final LibraryData BSTATS = new LibraryData("org{}bstats", "bstats-bukkit", "org{}bstats", Set.of("bstats-base"));
    public static final LibraryData MOLANG_COMPILER = new LibraryData("gg{}moonflower", "molang-compiler", null);
    public static final LibraryData ADVENTURE_API = new LibraryData("net{}kyori", "adventure-api", null, Set.of("adventure-key", "adventure-text-logger-slf4j", "adventure-text-serializer-legacy", "adventure-nbt", "adventure-text-serializer-gson", "adventure-text-serializer-gson-legacy-impl", "adventure-text-serializer-json", "adventure-text-serializer-json-legacy-impl"), BooleanConstantSupplier.of(!BetterModel.IS_PAPER));
    public static final LibraryData EXAMINATION_API = new LibraryData("net{}kyori", "examination-api", null, Set.of("examination-string"), BooleanConstantSupplier.of(!BetterModel.IS_PAPER));
    public static final LibraryData OPTION = new LibraryData("net{}kyori", "option", null, BooleanConstantSupplier.of(!BetterModel.IS_PAPER));
    public static final LibraryData ADVENTURE_PLATFORM = new LibraryData("net{}kyori", "adventure-platform-bukkit", null, Set.of("adventure-platform-api", "adventure-platform-facet", "adventure-platform-viaversion", "adventure-text-serializer-bungeecord"), BooleanConstantSupplier.of(!BetterModel.IS_PAPER));
    private static final List<LibraryData> LIBRARY_DATA = List.of(KOTLIN, BSTATS, MOLANG_COMPILER, ADVENTURE_API, EXAMINATION_API, OPTION, ADVENTURE_PLATFORM);

    public void load(@NotNull AbstractBetterModelPlugin plugin) {
        BukkitLibraryManager manager = new BukkitLibraryManager(plugin, ".libs");
        manager.addRepository("https://maven-central.storage-download.googleapis.com/maven2/");
        manager.addRepository("https://maven.blamejared.com/");
        manager.addMavenCentral();
        LIBRARY_DATA.stream().filter(LibraryData::isLoaded).flatMap(library -> library.toLibby(plugin)).forEach(manager::loadLibrary);
    }

    public record LibraryData(@NotNull String group, @NotNull String artifact, @Nullable String relocation, @NotNull @Unmodifiable Set<String> subModules, @NotNull BooleanSupplier predicate) {
        public LibraryData(@NotNull String group, @NotNull String artifact, @Nullable String relocation) {
            this(group, artifact, relocation, Collections.emptySet(), BooleanConstantSupplier.TRUE);
        }

        public LibraryData(@NotNull String group, @NotNull String artifact, @Nullable String relocation, @NotNull BooleanSupplier predicate) {
            this(group, artifact, relocation, Collections.emptySet(), predicate);
        }

        public LibraryData(@NotNull String group, @NotNull String artifact, @Nullable String relocation, @NotNull @Unmodifiable Set<String> subModules) {
            this(group, artifact, relocation, subModules, BooleanConstantSupplier.TRUE);
        }

        public boolean isLoaded() {
            return this.predicate.getAsBoolean();
        }

        @NotNull
        private Stream<Library> toLibby(@NotNull AbstractBetterModelPlugin plugin) {
            String version = plugin.attributes().getValue("library-" + this.artifact);
            return Stream.concat(Stream.of(this.artifact), this.subModules.stream()).map(name -> {
                Library.Builder libs = Library.builder().groupId(this.group).artifactId((String)name).version(version);
                if (this.relocation != null) {
                    libs.relocate(new Relocation(this.relocation, "kr{}toxicity{}model{}shaded{}" + this.relocation));
                }
                return libs.build();
            });
        }
    }
}

