/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.pack;

import java.util.Optional;
import java.util.function.BooleanSupplier;
import kr.toxicity.model.api.BetterModel;
import kr.toxicity.model.api.pack.PackMeta;
import kr.toxicity.model.api.pack.PackPath;
import kr.toxicity.model.api.util.function.BooleanConstantSupplier;
import org.jetbrains.annotations.NotNull;

public record PackOverlay(@NotNull String packName, @NotNull Optional<PackMeta.VersionRange> range, @NotNull BooleanSupplier tester) implements Comparable<PackOverlay>
{
    public static final PackOverlay DEFAULT = new PackOverlay("", Optional.empty(), BooleanConstantSupplier.TRUE);
    public static final PackOverlay LEGACY = new PackOverlay("legacy", Optional.of(new PackMeta.VersionRange(22, 45)), BetterModel.config().pack()::generateLegacyModel);
    public static final PackOverlay MODERN = new PackOverlay("modern", Optional.of(new PackMeta.VersionRange(46, 99)), BetterModel.config().pack()::generateModernModel);

    @NotNull
    public PackPath path(@NotNull String namespace) {
        return this.packName.isEmpty() ? PackPath.EMPTY : new PackPath(namespace + "_" + this.packName);
    }

    public boolean test() {
        return this.tester.getAsBoolean();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PackOverlay)) {
            return false;
        }
        PackOverlay that = (PackOverlay)o;
        return this.packName.equals(that.packName);
    }

    @Override
    public int hashCode() {
        return this.packName.hashCode();
    }

    @Override
    public int compareTo(@NotNull PackOverlay o) {
        return this.packName.compareTo(o.packName);
    }
}

