/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.entity;

import kr.toxicity.model.api.data.blueprint.AnimationMovement;
import kr.toxicity.model.api.util.MathUtil;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public record EntityMovement(@NotNull Vector3f transform, @NotNull Vector3f scale, @NotNull Quaternionf rotation, @NotNull Vector3f rawRotation) {
    public static final EntityMovement EMPTY = new EntityMovement(new Vector3f(), new Vector3f(1.0f), new Quaternionf(), new Vector3f());

    @NotNull
    public EntityMovement plus(@NotNull AnimationMovement movement) {
        Vector3f mov = movement.transform();
        Vector3f scl = movement.scale();
        Vector3f rot = movement.rotation();
        Vector3f rawRot = rot == null ? new Vector3f((Vector3fc)this.rawRotation) : new Vector3f((Vector3fc)rot).add((Vector3fc)this.rawRotation);
        return new EntityMovement(mov == null ? new Vector3f((Vector3fc)this.transform) : new Vector3f((Vector3fc)this.transform).add((Vector3fc)mov), scl == null ? new Vector3f((Vector3fc)this.scale) : new Vector3f((Vector3fc)this.scale).mul((Vector3fc)new Vector3f((Vector3fc)scl).add(1.0f, 1.0f, 1.0f)), rot == null ? new Quaternionf((Quaternionfc)this.rotation) : MathUtil.toQuaternion(MathUtil.blockBenchToDisplay(rawRot)), rawRot);
    }

    @NotNull
    public EntityMovement plus(@NotNull Vector3f position) {
        return new EntityMovement(new Vector3f((Vector3fc)this.transform).add((Vector3fc)position), this.scale, this.rotation, this.rawRotation);
    }
}

