/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.manager;

import com.destroystokyo.paper.event.entity.EntityAddToWorldEvent;
import com.destroystokyo.paper.event.entity.EntityJumpEvent;
import com.destroystokyo.paper.event.entity.EntityRemoveFromWorldEvent;
import kr.toxicity.model.api.BetterModel;
import kr.toxicity.model.api.data.renderer.AnimationModifier;
import kr.toxicity.model.api.event.ModelInteractEvent;
import kr.toxicity.model.api.manager.EntityManager;
import kr.toxicity.model.api.nms.HitBox;
import kr.toxicity.model.api.tracker.EntityTracker;
import kr.toxicity.model.manager.EntityManagerImpl;
import kr.toxicity.model.manager.GlobalManagerImpl;
import kr.toxicity.model.shaded.kotlin.Metadata;
import kr.toxicity.model.shaded.kotlin.jvm.internal.Intrinsics;
import kr.toxicity.model.util.EventsKt;
import kr.toxicity.model.util.PluginsKt;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityDismountEvent;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.entity.EntitySpawnEvent;
import org.bukkit.event.entity.EntityTeleportEvent;
import org.bukkit.event.player.PlayerInteractAtEntityEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.world.ChunkLoadEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lkr/toxicity/model/manager/EntityManagerImpl;", "Lkr/toxicity/model/api/manager/EntityManager;", "Lkr/toxicity/model/manager/GlobalManagerImpl;", "<init>", "()V", "reload", "", "core"})
public final class EntityManagerImpl
implements EntityManager,
GlobalManagerImpl {
    @NotNull
    public static final EntityManagerImpl INSTANCE = new EntityManagerImpl();

    private EntityManagerImpl() {
    }

    @Override
    public void reload() {
        if (BetterModel.IS_PAPER) {
            EventsKt.registerListener(new Listener(){

                @EventHandler(priority=EventPriority.MONITOR)
                public final void remove(EntityRemoveFromWorldEvent $this$remove) {
                    block1: {
                        Intrinsics.checkNotNullParameter($this$remove, "<this>");
                        EntityTracker entityTracker = EntityTracker.tracker($this$remove.getEntity());
                        if (entityTracker == null) break block1;
                        EntityTracker it = entityTracker;
                        boolean bl = false;
                        if (!it.forRemoval()) {
                            it.close();
                        }
                    }
                }

                @EventHandler(priority=EventPriority.MONITOR)
                public final void add(EntityAddToWorldEvent $this$add) {
                    block0: {
                        Intrinsics.checkNotNullParameter($this$add, "<this>");
                        EntityTracker entityTracker = EntityTracker.tracker($this$add.getEntity());
                        if (entityTracker == null) break block0;
                        entityTracker.refresh();
                    }
                }

                @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
                public final void jump(EntityJumpEvent $this$jump) {
                    block0: {
                        Intrinsics.checkNotNullParameter($this$jump, "<this>");
                        EntityTracker entityTracker = EntityTracker.tracker((Entity)$this$jump.getEntity());
                        if (entityTracker == null) break block0;
                        entityTracker.animateSingle("jump");
                    }
                }
            });
        } else {
            EventsKt.registerListener(new Listener(){

                @EventHandler(priority=EventPriority.MONITOR)
                public final void remove(EntityRemoveEvent $this$remove) {
                    block1: {
                        Intrinsics.checkNotNullParameter($this$remove, "<this>");
                        EntityTracker entityTracker = EntityTracker.tracker($this$remove.getEntity());
                        if (entityTracker == null) break block1;
                        EntityTracker it = entityTracker;
                        boolean bl = false;
                        if (!it.forRemoval()) {
                            it.close();
                        }
                    }
                }

                @EventHandler(priority=EventPriority.MONITOR)
                public final void add(EntitySpawnEvent $this$add) {
                    block0: {
                        Intrinsics.checkNotNullParameter($this$add, "<this>");
                        EntityTracker entityTracker = EntityTracker.tracker($this$add.getEntity());
                        if (entityTracker == null) break block0;
                        entityTracker.refresh();
                    }
                }
            });
        }
        EventsKt.registerListener(new Listener(){

            @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
            public final void potion(EntityPotionEffectEvent $this$potion) {
                block1: {
                    Intrinsics.checkNotNullParameter($this$potion, "<this>");
                    if ($this$potion.isCancelled()) break block1;
                    EntityTracker entityTracker = EntityTracker.tracker($this$potion.getEntity());
                    if (entityTracker != null) {
                        entityTracker.forceUpdate(true);
                    }
                }
            }

            @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
            public final void interactBukkit(PlayerInteractAtEntityEvent $this$interactBukkit) {
                Intrinsics.checkNotNullParameter($this$interactBukkit, "<this>");
                if ($this$interactBukkit.getHand() != EquipmentSlot.HAND) {
                    return;
                }
                Entity previous = $this$interactBukkit.getPlayer().getVehicle();
                if (previous instanceof HitBox && Intrinsics.areEqual(((HitBox)previous).source().getUniqueId(), $this$interactBukkit.getRightClicked().getUniqueId())) {
                    ((HitBox)previous).dismount((Entity)$this$interactBukkit.getPlayer());
                }
            }

            @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
            public final void dismount(EntityDismountEvent $this$dismount) {
                Intrinsics.checkNotNullParameter($this$dismount, "<this>");
                Entity entity = $this$dismount.getDismounted();
                Intrinsics.checkNotNullExpressionValue(entity, "getDismounted(...)");
                Entity e = entity;
                $this$dismount.setCancelled(e instanceof HitBox && ((HitBox)e).mountController().canFly() && !((HitBox)e).forceDismount());
            }

            @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
            public final void interact(ModelInteractEvent $this$interact) {
                Intrinsics.checkNotNullParameter((Object)((Object)$this$interact), "<this>");
                if ($this$interact.getHand() == ModelInteractEvent.Hand.RIGHT) {
                    Entity previous = $this$interact.getPlayer().getVehicle();
                    if (previous instanceof HitBox && Intrinsics.areEqual(((HitBox)previous).source().getUniqueId(), $this$interact.getHitBox().source().getUniqueId())) {
                        $this$interact.getHitBox().dismount((Entity)$this$interact.getPlayer());
                    } else if ($this$interact.getHitBox().mountController().canMount()) {
                        $this$interact.getHitBox().mount((Entity)$this$interact.getPlayer());
                    }
                }
            }

            @EventHandler(priority=EventPriority.MONITOR)
            public final void quit(PlayerQuitEvent $this$quit) {
                block0: {
                    Intrinsics.checkNotNullParameter($this$quit, "<this>");
                    EntityTracker entityTracker = EntityTracker.tracker($this$quit.getPlayer().getUniqueId());
                    if (entityTracker == null) break block0;
                    entityTracker.close();
                }
            }

            @EventHandler(priority=EventPriority.MONITOR)
            public final void load(ChunkLoadEvent $this$load) {
                Intrinsics.checkNotNullParameter($this$load, "<this>");
                Entity[] entityArray = $this$load.getChunk().getEntities();
                Intrinsics.checkNotNullExpressionValue(entityArray, "getEntities(...)");
                Object[] $this$forEach$iv = entityArray;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Entity it = (Entity)element$iv;
                    boolean bl = false;
                    EntityTracker entityTracker = EntityTracker.tracker(it);
                    if (entityTracker == null) continue;
                    entityTracker.refresh();
                }
            }

            @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
            public final void teleport(EntityTeleportEvent $this$teleport) {
                block0: {
                    Intrinsics.checkNotNullParameter($this$teleport, "<this>");
                    EntityTracker entityTracker = EntityTracker.tracker($this$teleport.getEntity());
                    if (entityTracker == null) break block0;
                    entityTracker.refresh();
                }
            }

            @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
            public final void death(EntityDeathEvent $this$death) {
                block2: {
                    Intrinsics.checkNotNullParameter($this$death, "<this>");
                    EntityTracker entityTracker = EntityTracker.tracker((Entity)$this$death.getEntity());
                    if (entityTracker == null) break block2;
                    EntityTracker it = entityTracker;
                    boolean bl = false;
                    if (!it.animateSingle("death", AnimationModifier.DEFAULT, () -> reload.3.death$lambda$3$lambda$2($this$death, it))) {
                        it.close();
                    } else {
                        it.forRemoval(true);
                    }
                }
            }

            @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=false)
            public final void damage(EntityDamageEvent $this$damage) {
                block3: {
                    Intrinsics.checkNotNullParameter($this$damage, "<this>");
                    Entity entity = $this$damage.getEntity();
                    Intrinsics.checkNotNullExpressionValue(entity, "getEntity(...)");
                    Entity e = entity;
                    if (!(e instanceof LivingEntity)) {
                        return;
                    }
                    EntityTracker entityTracker = EntityTracker.tracker(e);
                    if (entityTracker == null) break block3;
                    EntityTracker it = entityTracker;
                    boolean bl = false;
                    if (it.animateSingle("damage", AnimationModifier.DEFAULT, () -> reload.3.damage$lambda$5$lambda$4(it))) {
                        it.tint(it.damageTintValue());
                    } else {
                        it.damageTint();
                    }
                }
            }

            private static final void death$lambda$3$lambda$2$lambda$1(EntityTracker $it) {
                $it.close();
            }

            private static final void death$lambda$3$lambda$2(EntityDeathEvent $this_death, EntityTracker $it) {
                PluginsKt.getPLUGIN().scheduler().task($this_death.getEntity().getLocation(), () -> reload.3.death$lambda$3$lambda$2$lambda$1($it));
            }

            private static final void damage$lambda$5$lambda$4(EntityTracker $it) {
                $it.tint(0xFFFFFF);
            }
        });
    }

    @Override
    public void start() {
        GlobalManagerImpl.DefaultImpls.start(this);
    }

    @Override
    public void end() {
        GlobalManagerImpl.DefaultImpls.end(this);
    }
}

