/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.data.blueprint;

import com.google.gson.JsonObject;
import java.awt.image.BufferedImage;
import kr.toxicity.model.api.BetterModel;
import kr.toxicity.model.api.data.raw.ModelResolution;
import kr.toxicity.model.api.pack.PackObfuscator;
import kr.toxicity.model.api.util.PackUtil;
import kr.toxicity.model.api.util.json.JsonObjectBuilder;
import org.jetbrains.annotations.NotNull;

public record BlueprintTexture(@NotNull String name, @NotNull BufferedImage image, int uvWidth, int uvHeight) {
    public boolean isAnimatedTexture() {
        if (this.uvWidth > 0 && this.uvHeight > 0) {
            float w;
            float h = (float)this.image.getHeight() / (float)this.uvHeight;
            return h > (w = (float)this.image.getWidth() / (float)this.uvWidth);
        }
        return this.image.getHeight() / this.image.getWidth() > 1;
    }

    public boolean canBeRendered() {
        return !this.name.startsWith("-");
    }

    @NotNull
    public JsonObject toMcmeta() {
        return JsonObjectBuilder.builder().jsonObject("animation", animation -> {
            animation.property("interpolate", true);
            animation.property("frametime", BetterModel.config().animatedTextureFrameTime());
        }).build();
    }

    @NotNull
    public String packName(@NotNull String parent) {
        return PackUtil.toPackName(parent + "_" + this.name());
    }

    @NotNull
    public String packName(@NotNull PackObfuscator obfuscator, @NotNull String parent) {
        return obfuscator.obfuscate(this.packName(parent));
    }

    @NotNull
    public String packNamespace(@NotNull PackObfuscator obfuscator, @NotNull String parentName) {
        return BetterModel.config().namespace() + ":item/" + this.packName(obfuscator, parentName);
    }

    public boolean hasUVSize() {
        return this.uvWidth > 0 && this.uvHeight > 0;
    }

    @NotNull
    public ModelResolution resolution(@NotNull ModelResolution resolution) {
        if (!this.hasUVSize()) {
            return resolution;
        }
        return resolution.width() == this.image.getWidth() && resolution.height() == this.image.getHeight() ? resolution : new ModelResolution(this.uvWidth, this.uvHeight);
    }
}

