/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.nms;

import kr.toxicity.model.api.nms.DisplayTransformer;
import kr.toxicity.model.api.nms.EntityAdapter;
import kr.toxicity.model.api.nms.Identifiable;
import kr.toxicity.model.api.nms.PacketBundler;
import kr.toxicity.model.api.tracker.ModelRotation;
import org.bukkit.Location;
import org.bukkit.entity.Display;
import org.bukkit.entity.ItemDisplay;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public interface ModelDisplay
extends Identifiable {
    public boolean invisible();

    public void invisible(boolean var1);

    public void rotate(@NotNull ModelRotation var1, @NotNull PacketBundler var2);

    public void syncEntity(@NotNull EntityAdapter var1);

    public void syncPosition(@NotNull Location var1);

    public void moveDuration(int var1);

    public void display(@NotNull ItemDisplay.ItemDisplayTransform var1);

    default public void spawn(@NotNull PacketBundler bundler) {
        this.spawn(!this.invisible(), bundler);
    }

    default public void spawnWithEntityData(@NotNull PacketBundler bundler) {
        boolean visible = !this.invisible();
        this.spawn(visible, bundler);
        this.sendEntityData(visible, bundler);
    }

    public void spawn(boolean var1, @NotNull PacketBundler var2);

    public void remove(@NotNull PacketBundler var1);

    public void teleport(@NotNull Location var1, @NotNull PacketBundler var2);

    public void item(@NotNull ItemStack var1);

    @NotNull
    public DisplayTransformer createTransformer();

    public void sendDirtyEntityData(@NotNull PacketBundler var1);

    public void sendEntityData(boolean var1, @NotNull PacketBundler var2);

    public void brightness(int var1, int var2);

    public void viewRange(float var1);

    public void shadowRadius(float var1);

    public void sendPosition(@NotNull EntityAdapter var1, @NotNull PacketBundler var2);

    public void glow(boolean var1);

    public void glowColor(int var1);

    public void billboard(@NotNull Display.Billboard var1);
}

