/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.player;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParser;
import com.mojang.authlib.properties.PropertyMap;
import com.mojang.util.UUIDTypeAdapter;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.Charset;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import kr.toxicity.model.api.player.PlayerSkinProvider;
import kr.toxicity.model.api.skin.SkinProfile;
import kr.toxicity.model.shaded.kotlin.Metadata;
import kr.toxicity.model.shaded.kotlin.Unit;
import kr.toxicity.model.shaded.kotlin.io.CloseableKt;
import kr.toxicity.model.shaded.kotlin.jvm.functions.Function1;
import kr.toxicity.model.shaded.kotlin.jvm.internal.Intrinsics;
import kr.toxicity.model.shaded.kotlin.jvm.internal.SourceDebugExtension;
import kr.toxicity.model.shaded.kotlin.text.Charsets;
import kr.toxicity.model.util.PluginsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u000fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0007\u001a\n \u0006*\u0004\u0018\u00010\b0\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\rH\u0016R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lkr/toxicity/model/player/HttpPlayerSkinProvider;", "Lkr/toxicity/model/api/player/PlayerSkinProvider;", "<init>", "()V", "serializer", "Lcom/google/gson/Gson;", "kr.toxicity.model.shaded.kotlin.jvm.PlatformType", "read", "Lkr/toxicity/model/player/HttpPlayerSkinProvider$Profile;", "reader", "Ljava/io/Reader;", "provide", "Ljava/util/concurrent/CompletableFuture;", "Lkr/toxicity/model/api/skin/SkinProfile;", "profile", "Profile", "core"})
@SourceDebugExtension(value={"SMAP\nHttpPlayerSkinProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HttpPlayerSkinProvider.kt\nkr/toxicity/model/player/HttpPlayerSkinProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,75:1\n1#2:76\n*E\n"})
public final class HttpPlayerSkinProvider
implements PlayerSkinProvider {
    private final Gson serializer = new GsonBuilder().registerTypeAdapter((Type)((Object)UUID.class), (Object)new UUIDTypeAdapter()).registerTypeAdapter((Type)((Object)PropertyMap.class), (Object)new PropertyMap.Serializer()).create();

    private final Profile read(Reader reader) {
        return (Profile)this.serializer.fromJson(reader, Profile.class);
    }

    @Override
    @NotNull
    public CompletableFuture<SkinProfile> provide(@NotNull SkinProfile profile) {
        Intrinsics.checkNotNullParameter((Object)profile, (String)"profile");
        CompletableFuture completableFuture = PluginsKt.httpClient(arg_0 -> HttpPlayerSkinProvider.provide$lambda$0(profile, this, arg_0)).orElse(arg_0 -> HttpPlayerSkinProvider.provide$lambda$1(profile, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)completableFuture, (String)"orElse(...)");
        return completableFuture;
    }

    private static final CompletableFuture provide$lambda$0(SkinProfile $profile, HttpPlayerSkinProvider this$0, HttpClient $this$httpClient) {
        Intrinsics.checkNotNullParameter((Object)$this$httpClient, (String)"$this$httpClient");
        return ((CompletableFuture)((CompletableFuture)$this$httpClient.sendAsync(PluginsKt.buildHttpRequest((Function1<? super HttpRequest.Builder, Unit>)((Function1)arg_0 -> HttpPlayerSkinProvider.provide$lambda$0$0($profile, arg_0))), HttpResponse.BodyHandlers.ofInputStream()).thenCompose(arg_0 -> HttpPlayerSkinProvider.provide$lambda$0$2(arg_0 -> HttpPlayerSkinProvider.provide$lambda$0$1($this$httpClient, arg_0), arg_0))).thenApply(arg_0 -> HttpPlayerSkinProvider.provide$lambda$0$4(arg_0 -> HttpPlayerSkinProvider.provide$lambda$0$3(this$0, arg_0), arg_0))).exceptionally(arg_0 -> HttpPlayerSkinProvider.provide$lambda$0$5($profile, arg_0));
    }

    private static final Unit provide$lambda$0$0(SkinProfile $profile, HttpRequest.Builder $this$buildHttpRequest) {
        Intrinsics.checkNotNullParameter((Object)$this$buildHttpRequest, (String)"$this$buildHttpRequest");
        $this$buildHttpRequest.GET();
        $this$buildHttpRequest.uri(URI.create("https://api.minecraftservices.com/minecraft/profile/lookup/name/" + $profile.name()));
        return Unit.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final CompletionStage provide$lambda$0$1(HttpClient $this_httpClient, HttpResponse it) {
        Reader reader;
        Closeable closeable = (Closeable)it.body();
        Throwable throwable = null;
        try {
            InputStream body = (InputStream)closeable;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)body);
            Closeable closeable2 = body;
            Object object = Charsets.UTF_8;
            Reader reader2 = new InputStreamReader((InputStream)closeable2, (Charset)object);
            int n = 8192;
            closeable2 = reader2 instanceof BufferedReader ? (BufferedReader)reader2 : new BufferedReader(reader2, n);
            object = null;
            try {
                Reader p0 = (Reader)closeable2;
                boolean bl2 = false;
                reader2 = JsonParser.parseReader((Reader)p0);
            }
            catch (Throwable throwable2) {
                object = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)object);
            }
            reader = reader2;
        }
        catch (Throwable throwable3) {
            throwable = throwable3;
            throw throwable3;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        String uuid = reader.getAsJsonObject().getAsJsonPrimitive("id").getAsString();
        return $this_httpClient.sendAsync(PluginsKt.buildHttpRequest((Function1<? super HttpRequest.Builder, Unit>)((Function1)arg_0 -> HttpPlayerSkinProvider.provide$lambda$0$1$1(uuid, arg_0))), HttpResponse.BodyHandlers.ofInputStream());
    }

    private static final Unit provide$lambda$0$1$1(String $uuid, HttpRequest.Builder $this$buildHttpRequest) {
        Intrinsics.checkNotNullParameter((Object)$this$buildHttpRequest, (String)"$this$buildHttpRequest");
        $this$buildHttpRequest.GET();
        $this$buildHttpRequest.uri(URI.create("https://sessionserver.mojang.com/session/minecraft/profile/" + $uuid));
        return Unit.INSTANCE;
    }

    private static final CompletionStage provide$lambda$0$2(Function1 $tmp0, Object p0) {
        return (CompletionStage)$tmp0.invoke(p0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final SkinProfile provide$lambda$0$3(HttpPlayerSkinProvider this$0, HttpResponse it) {
        Object body;
        Closeable closeable = (Closeable)it.body();
        Throwable throwable = null;
        try {
            body = (InputStream)closeable;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)body);
            Closeable closeable2 = body;
            Object object = Charsets.UTF_8;
            Object object2 = new InputStreamReader((InputStream)closeable2, (Charset)object);
            int n = 8192;
            closeable2 = object2 instanceof BufferedReader ? (BufferedReader)object2 : new BufferedReader((Reader)object2, n);
            object = null;
            try {
                Reader p0 = (Reader)closeable2;
                boolean bl2 = false;
                object2 = this$0.read(p0);
            }
            catch (Throwable throwable2) {
                object = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)object);
            }
            body = object2;
        }
        catch (Throwable throwable3) {
            throwable = throwable3;
            throw throwable3;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        Object p = body;
        boolean bl = false;
        return new SkinProfile(((Profile)p).getId(), ((Profile)p).getName(), ((Profile)p).getProperties().get((Object)"textures"));
    }

    private static final SkinProfile provide$lambda$0$4(Function1 $tmp0, Object p0) {
        return (SkinProfile)$tmp0.invoke(p0);
    }

    private static final SkinProfile provide$lambda$0$5(SkinProfile $profile, Throwable it) {
        Intrinsics.checkNotNull((Object)it);
        PluginsKt.handleException(it, "Unable to get " + $profile.name() + "'s skin data.");
        return null;
    }

    private static final CompletableFuture provide$lambda$1(SkinProfile $profile, Exception it) {
        Intrinsics.checkNotNull((Object)it);
        PluginsKt.handleException(it, "Unable to get " + $profile.name() + "'s user data.");
        return CompletableFuture.completedFuture(null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001a"}, d2={"Lkr/toxicity/model/player/HttpPlayerSkinProvider$Profile;", "", "id", "Ljava/util/UUID;", "name", "", "properties", "Lcom/mojang/authlib/properties/PropertyMap;", "<init>", "(Ljava/util/UUID;Ljava/lang/String;Lcom/mojang/authlib/properties/PropertyMap;)V", "getId", "()Ljava/util/UUID;", "getName", "()Ljava/lang/String;", "getProperties", "()Lcom/mojang/authlib/properties/PropertyMap;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "core"})
    private static final class Profile {
        @NotNull
        private final UUID id;
        @NotNull
        private final String name;
        @NotNull
        private final PropertyMap properties;

        public Profile(@NotNull UUID id, @NotNull String name, @NotNull PropertyMap properties) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
            this.id = id;
            this.name = name;
            this.properties = properties;
        }

        @NotNull
        public final UUID getId() {
            return this.id;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final PropertyMap getProperties() {
            return this.properties;
        }

        @NotNull
        public final UUID component1() {
            return this.id;
        }

        @NotNull
        public final String component2() {
            return this.name;
        }

        @NotNull
        public final PropertyMap component3() {
            return this.properties;
        }

        @NotNull
        public final Profile copy(@NotNull UUID id, @NotNull String name, @NotNull PropertyMap properties) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
            return new Profile(id, name, properties);
        }

        public static /* synthetic */ Profile copy$default(Profile profile, UUID uUID, String string, PropertyMap propertyMap, int n, Object object) {
            if ((n & 1) != 0) {
                uUID = profile.id;
            }
            if ((n & 2) != 0) {
                string = profile.name;
            }
            if ((n & 4) != 0) {
                propertyMap = profile.properties;
            }
            return profile.copy(uUID, string, propertyMap);
        }

        @NotNull
        public String toString() {
            return "Profile(id=" + this.id + ", name=" + this.name + ", properties=" + this.properties + ")";
        }

        public int hashCode() {
            int result = this.id.hashCode();
            result = result * 31 + this.name.hashCode();
            result = result * 31 + this.properties.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Profile)) {
                return false;
            }
            Profile profile = (Profile)other;
            if (!Intrinsics.areEqual((Object)this.id, (Object)profile.id)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.name, (Object)profile.name)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.properties, (Object)profile.properties);
        }
    }
}

