/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.shaded.dev.jorel.commandapi.arguments;

import com.mojang.brigadier.LiteralMessage;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.io.Serializable;
import kr.toxicity.model.shaded.dev.jorel.commandapi.BukkitTooltip;
import kr.toxicity.model.shaded.dev.jorel.commandapi.CommandAPIBukkit;
import kr.toxicity.model.shaded.dev.jorel.commandapi.CommandAPIHandler;
import kr.toxicity.model.shaded.dev.jorel.commandapi.arguments.Argument;
import kr.toxicity.model.shaded.dev.jorel.commandapi.arguments.CommandAPIArgumentType;
import kr.toxicity.model.shaded.dev.jorel.commandapi.arguments.LiteralArgument;
import kr.toxicity.model.shaded.dev.jorel.commandapi.arguments.MultiLiteralArgument;
import kr.toxicity.model.shaded.dev.jorel.commandapi.executors.CommandArguments;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.command.CommandSender;

public class CustomArgument<T, B>
extends Argument<T> {
    private final CustomArgumentInfoParser<T, B> infoParser;
    private final Argument<B> base;
    private static final String INPUT = "%input%";
    private static final String FULL_INPUT = "%finput%";

    public CustomArgument(Argument<B> base, CustomArgumentInfoParser<T, B> parser) {
        super(base.getNodeName(), base.getRawType());
        if (base instanceof LiteralArgument || base instanceof MultiLiteralArgument) {
            throw new IllegalArgumentException(base.getClass().getSimpleName() + " is not a suitable base argument type for a CustomArgument");
        }
        this.base = base;
        this.infoParser = parser;
    }

    @Override
    public Class<T> getPrimitiveType() {
        return null;
    }

    @Override
    public CommandAPIArgumentType getArgumentType() {
        return CommandAPIArgumentType.CUSTOM;
    }

    @Override
    public <CommandSourceStack> T parseArgument(CommandContext<CommandSourceStack> cmdCtx, String key, CommandArguments previousArgs) throws CommandSyntaxException {
        String customresult = CommandAPIHandler.getRawArgumentInput(cmdCtx, key);
        Object parsedInput = this.base.parseArgument(cmdCtx, key, previousArgs);
        try {
            return this.infoParser.apply(new CustomArgumentInfo((CommandSender)CommandAPIBukkit.get().getCommandSenderFromCommandSource(cmdCtx.getSource()).getSource(), previousArgs, customresult, parsedInput));
        }
        catch (CustomArgumentException e) {
            throw e.toCommandSyntax(customresult, cmdCtx);
        }
        catch (Exception e) {
            String errorMsg = new MessageBuilder("Error in executing command ").appendFullInput().append(" - ").appendArgInput().appendHere().toString().replace(INPUT, customresult).replace(FULL_INPUT, cmdCtx.getInput());
            throw new SimpleCommandExceptionType(() -> errorMsg).create();
        }
    }

    @FunctionalInterface
    public static interface CustomArgumentInfoParser<T, B> {
        public T apply(CustomArgumentInfo<B> var1) throws CustomArgumentException;
    }

    public record CustomArgumentInfo<B>(CommandSender sender, CommandArguments previousArgs, String input, B currentInput) {
    }

    public static class CustomArgumentException
    extends Exception {
        private ComponentLike errorComponent = null;
        private String errorMessage = null;
        private MessageBuilder errorMessageBuilder = null;

        private CustomArgumentException() {
        }

        public static CustomArgumentException fromString(String errorMessage) {
            CustomArgumentException exception = new CustomArgumentException();
            exception.errorMessage = errorMessage;
            return exception;
        }

        public static CustomArgumentException fromAdventureComponent(ComponentLike errorMessage) {
            CustomArgumentException exception = new CustomArgumentException();
            exception.errorComponent = errorMessage;
            return exception;
        }

        public static CustomArgumentException fromMessageBuilder(MessageBuilder errorMessage) {
            CustomArgumentException exception = new CustomArgumentException();
            exception.errorMessageBuilder = errorMessage;
            return exception;
        }

        public CommandSyntaxException toCommandSyntax(String result, CommandContext<?> cmdCtx) {
            if (this.errorComponent != null) {
                Message brigadierMessage = BukkitTooltip.messageFromAdventureComponent(this.errorComponent);
                return new SimpleCommandExceptionType(brigadierMessage).create();
            }
            if (this.errorMessageBuilder != null) {
                String errorMsg = this.errorMessageBuilder.toString().replace(CustomArgument.INPUT, result).replace(CustomArgument.FULL_INPUT, cmdCtx.getInput());
                return new SimpleCommandExceptionType((Message)new LiteralMessage(errorMsg)).create();
            }
            if (this.errorMessage != null) {
                TextComponent component = LegacyComponentSerializer.legacyAmpersand().deserialize(this.errorMessage);
                return new SimpleCommandExceptionType(BukkitTooltip.messageFromAdventureComponent((ComponentLike)component)).create();
            }
            throw new IllegalStateException("No error component, error message creator or error message specified");
        }
    }

    public static class MessageBuilder
    implements Serializable {
        private static final long serialVersionUID = 838497662821791798L;
        StringBuilder builder;

        public MessageBuilder() {
            this.builder = new StringBuilder();
        }

        public MessageBuilder(String str) {
            this.builder = new StringBuilder(str);
        }

        public MessageBuilder appendArgInput() {
            this.builder.append(CustomArgument.INPUT);
            return this;
        }

        public MessageBuilder appendFullInput() {
            this.builder.append(CustomArgument.FULL_INPUT);
            return this;
        }

        public MessageBuilder appendHere() {
            this.builder.append("<--[HERE]");
            return this;
        }

        public MessageBuilder append(String str) {
            this.builder.append(str);
            return this;
        }

        public MessageBuilder append(Object obj) {
            this.builder.append(obj);
            return this;
        }

        public String toString() {
            return this.builder.toString();
        }
    }
}

