/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.data.blueprint;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kr.toxicity.model.api.data.blueprint.AnimationMovement;
import kr.toxicity.model.api.data.raw.Datapoint;
import kr.toxicity.model.api.data.raw.ModelKeyframe;
import kr.toxicity.model.api.util.MathUtil;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public record BlueprintAnimator(@NotNull String name, float length, @NotNull @Unmodifiable List<AnimationMovement> keyFrame) {
    @NotNull
    public AnimatorIterator singleIterator() {
        return new SingleIterator();
    }

    @NotNull
    public AnimatorIterator loopIterator() {
        return new LoopIterator();
    }

    private class SingleIterator
    implements AnimatorIterator {
        private int index = 0;

        private SingleIterator() {
        }

        @Override
        @NotNull
        public AnimationMovement first() {
            return BlueprintAnimator.this.keyFrame.getFirst();
        }

        @Override
        public int index() {
            return this.index;
        }

        @Override
        public int lastIndex() {
            return BlueprintAnimator.this.keyFrame.size() - 1;
        }

        @Override
        public int length() {
            return Math.round(BlueprintAnimator.this.length * 20.0f);
        }

        @Override
        public void clear() {
            this.index = Integer.MAX_VALUE;
        }

        @Override
        public boolean hasNext() {
            return this.index < BlueprintAnimator.this.keyFrame.size();
        }

        @Override
        public AnimationMovement next() {
            return BlueprintAnimator.this.keyFrame.get(this.index++);
        }
    }

    private class LoopIterator
    implements AnimatorIterator {
        private int index = 0;

        private LoopIterator() {
        }

        @Override
        @NotNull
        public AnimationMovement first() {
            return BlueprintAnimator.this.keyFrame.getFirst();
        }

        @Override
        public int index() {
            return this.index;
        }

        @Override
        public int lastIndex() {
            return BlueprintAnimator.this.keyFrame.size() - 1;
        }

        @Override
        public int length() {
            return Math.round(BlueprintAnimator.this.length * 20.0f);
        }

        @Override
        public void clear() {
            this.index = 0;
        }

        @Override
        public boolean hasNext() {
            return true;
        }

        @Override
        public AnimationMovement next() {
            if (this.index >= BlueprintAnimator.this.keyFrame.size()) {
                this.index = 0;
            }
            return BlueprintAnimator.this.keyFrame.get(this.index++);
        }
    }

    public static interface AnimatorIterator
    extends Iterator<AnimationMovement> {
        @NotNull
        public AnimationMovement first();

        public void clear();

        public int length();

        public int index();

        public int lastIndex();
    }

    public static final class Builder {
        private final float length;
        private final List<TimeVector> transform = new ArrayList<TimeVector>();
        private final List<TimeVector> scale = new ArrayList<TimeVector>();
        private final List<TimeVector> rotation = new ArrayList<TimeVector>();

        private static int checkSplit(float angle) {
            return (int)Math.floor(Math.toDegrees(angle) / 45.0) + 1;
        }

        @NotNull
        public Builder addFrame(@NotNull ModelKeyframe keyframe) {
            for (Datapoint dataPoint : keyframe.dataPoints()) {
                Vector3f vec = dataPoint.toVector();
                switch (keyframe.channel()) {
                    case POSITION: {
                        this.transform.add(new TimeVector(keyframe.time(), MathUtil.transformToDisplay(vec.div(16.0f))));
                        break;
                    }
                    case ROTATION: {
                        TimeVector rot = new TimeVector(keyframe.time(), MathUtil.animationToDisplay(vec));
                        TimeVector last = this.rotation.isEmpty() ? TimeVector.EMPTY : this.rotation.getLast();
                        int split = Builder.checkSplit(MathUtil.toQuaternion(MathUtil.blockBenchToDisplay(rot.vector3f)).mul((Quaternionfc)MathUtil.toQuaternion(MathUtil.blockBenchToDisplay(last.vector3f)).invert()).angle());
                        if (split > 1) {
                            for (int i = 1; i < split; ++i) {
                                float t = (rot.time - last.time) / (float)split * (float)i + last.time;
                                this.rotation.add(new TimeVector(t, this.get(t, last, rot)));
                            }
                        }
                        this.rotation.add(rot);
                        break;
                    }
                    case SCALE: {
                        this.scale.add(new TimeVector(keyframe.time(), vec.sub(1.0f, 1.0f, 1.0f)));
                    }
                }
            }
            return this;
        }

        private Vector3f get(float min, TimeVector last, TimeVector newVec) {
            if (newVec.time == 0.0f || newVec.time - last.time == 0.0f) {
                return newVec.vector3f;
            }
            return new Vector3f((Vector3fc)last.vector3f).add((Vector3fc)new Vector3f((Vector3fc)newVec.vector3f).sub((Vector3fc)last.vector3f).mul(min - last.time).div(newVec.time - last.time));
        }

        @NotNull
        private List<AnimationMovement> toAnimation() {
            ArrayList<AnimationMovement> list = new ArrayList<AnimationMovement>();
            int ti = 0;
            int si = 0;
            int ri = 0;
            float beforeTime = 0.0f;
            TimeVector t = !this.transform.isEmpty() ? this.transform.getFirst() : null;
            TimeVector s = !this.scale.isEmpty() ? this.scale.getFirst() : null;
            TimeVector r = !this.rotation.isEmpty() ? this.rotation.getFirst() : null;
            TimeVector lastP = TimeVector.EMPTY;
            TimeVector lastS = TimeVector.EMPTY;
            TimeVector lastR = TimeVector.EMPTY;
            while (t != null || s != null || r != null) {
                float min = Math.min(t != null ? t.time : 9.223372E18f, Math.min(s != null ? s.time : 9.223372E18f, r != null ? r.time : 9.223372E18f));
                list.add(new AnimationMovement(min, t != null ? this.get(min, lastP, t) : lastP.vector3f, s != null ? this.get(min, lastS, s) : lastS.vector3f, r != null ? this.get(min, lastR, r) : lastR.vector3f));
                if (t != null && t.time <= min) {
                    lastP = t;
                    ++ti;
                }
                if (s != null && s.time <= min) {
                    lastS = s;
                    ++si;
                }
                if (r != null && r.time <= min) {
                    lastR = r;
                    ++ri;
                }
                t = this.transform.size() > ti ? this.transform.get(ti) : null;
                s = this.scale.size() > si ? this.scale.get(si) : null;
                r = this.rotation.size() > ri ? this.rotation.get(ri) : null;
                beforeTime = min;
            }
            if (beforeTime < this.length && !list.isEmpty()) {
                AnimationMovement last = (AnimationMovement)list.getLast();
                list.add(new AnimationMovement(this.length, last.transform(), last.scale(), last.rotation()));
            }
            return list.isEmpty() ? List.of(new AnimationMovement(1.0f, null, null, null)) : list;
        }

        @NotNull
        public BlueprintAnimator build(@NotNull String name) {
            return new BlueprintAnimator(name, this.length, this.toAnimation());
        }

        @Generated
        public Builder(float length) {
            this.length = length;
        }
    }

    private record TimeVector(float time, @NotNull Vector3f vector3f) {
        private static final TimeVector EMPTY = new TimeVector(0.0f, new Vector3f());
    }
}

