/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.data.raw;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public record Datapoint(float x, float y, float z, @Nullable String script) {
    public static final Function<JsonElement, Datapoint> PARSER = element -> {
        JsonObject array = element.getAsJsonObject();
        JsonPrimitive script = array.getAsJsonPrimitive("script");
        return new Datapoint(Datapoint.parse(array.getAsJsonPrimitive("x")), Datapoint.parse(array.getAsJsonPrimitive("y")), Datapoint.parse(array.getAsJsonPrimitive("z")), script != null ? script.getAsString() : null);
    };

    private static float parse(@Nullable JsonPrimitive primitive) {
        if (primitive == null) {
            return 0.0f;
        }
        try {
            float f = primitive.getAsFloat();
            return Float.isNaN(f) ? 0.0f : f;
        }
        catch (NumberFormatException e) {
            return 0.0f;
        }
    }

    @NotNull
    public Vector3f toVector() {
        return new Vector3f(this.x, this.y, this.z);
    }
}

