/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.tracker;

import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import kr.toxicity.model.api.BetterModel;
import kr.toxicity.model.api.data.renderer.AnimationModifier;
import kr.toxicity.model.api.data.renderer.RenderInstance;
import kr.toxicity.model.api.entity.RenderedEntity;
import kr.toxicity.model.api.entity.TrackerMovement;
import kr.toxicity.model.api.nms.ModelDisplay;
import kr.toxicity.model.api.nms.PacketBundler;
import kr.toxicity.model.api.scheduler.ModelTask;
import kr.toxicity.model.api.tracker.ModelRotation;
import kr.toxicity.model.api.tracker.TrackerModifier;
import kr.toxicity.model.api.util.EntityUtil;
import lombok.Generated;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public abstract class Tracker
implements AutoCloseable {
    public static final NamespacedKey TRACKING_ID = Objects.requireNonNull(NamespacedKey.fromString((String)"bettermodel_tracker"));
    protected final RenderInstance instance;
    private final ModelTask task;
    private final AtomicBoolean runningSingle = new AtomicBoolean();
    private TrackerMovement before;
    private final TrackerModifier modifier;
    private Supplier<TrackerMovement> movement;
    private Consumer<Tracker> consumer = t -> {};

    public Tracker(@NotNull RenderInstance instance, @NotNull TrackerModifier modifier) {
        this.instance = instance;
        this.modifier = modifier;
        this.movement = () -> new TrackerMovement(new Vector3f(), new Vector3f(modifier.scale()), new Vector3f());
        this.task = BetterModel.inst().scheduler().asyncTaskTimer(1L, 1L, () -> {
            this.consumer.accept(this);
            PacketBundler bundle = BetterModel.inst().nms().createBundler();
            instance.move(this.rotation(), this.isRunningSingleAnimation() && this.before != null && BetterModel.inst().configManager().lockOnPlayAnimation() ? this.before : (this.before = this.movement.get()), bundle);
            if (!bundle.isEmpty()) {
                for (Player player : instance.viewedPlayer()) {
                    bundle.send(player);
                }
            }
        });
        this.tint(false);
        if (modifier.sightTrace()) {
            instance.filter(p -> EntityUtil.canSee(p.getEyeLocation(), this.location()));
        }
        this.tick(t -> t.instance.getScriptProcessor().tick());
    }

    @NotNull
    public abstract ModelRotation rotation();

    public void tick(@NotNull Consumer<Tracker> consumer) {
        this.consumer = this.consumer.andThen(consumer);
    }

    @NotNull
    public String name() {
        return this.instance.getParent().name();
    }

    public double height() {
        return this.instance.height();
    }

    @Override
    public void close() throws Exception {
        this.task.cancel();
        this.instance.close();
    }

    public void setMovement(Supplier<TrackerMovement> movement) {
        this.instance.lastMovement(movement.get());
        this.movement = movement;
    }

    @NotNull
    public TrackerModifier modifier() {
        return this.modifier;
    }

    public boolean isRunningSingleAnimation() {
        return this.runningSingle.get();
    }

    protected void spawn(@NotNull Player player, @NotNull PacketBundler bundler) {
        this.instance.spawn(player, bundler);
    }

    public void remove(@NotNull Player player) {
        this.instance.remove(player);
    }

    public int viewedPlayerSize() {
        return this.instance.viewedPlayerSize();
    }

    @NotNull
    public List<Player> viewedPlayer() {
        return this.instance.viewedPlayer();
    }

    public void tint(boolean toggle) {
        this.instance.tint(toggle);
    }

    @NotNull
    public abstract Location location();

    @NotNull
    public abstract UUID uuid();

    public boolean animateLoop(@NotNull String animation) {
        return this.animateLoop(animation, AnimationModifier.DEFAULT_LOOP);
    }

    public boolean animateLoop(@NotNull String animation, AnimationModifier modifier) {
        return this.animateLoop(animation, modifier, () -> {});
    }

    public boolean animateLoop(@NotNull String animation, AnimationModifier modifier, Runnable removeTask) {
        return this.animateLoop(e -> true, animation, modifier, removeTask);
    }

    public boolean animateLoop(@NotNull Predicate<RenderedEntity> filter, @NotNull String animation, AnimationModifier modifier, Runnable removeTask) {
        return this.instance.animateLoop(filter, animation, modifier, removeTask);
    }

    public boolean animateSingle(@NotNull String animation) {
        return this.animateSingle(animation, AnimationModifier.DEFAULT);
    }

    public boolean animateSingle(@NotNull String animation, AnimationModifier modifier) {
        return this.animateSingle(animation, modifier, () -> {});
    }

    public boolean animateSingle(@NotNull String animation, AnimationModifier modifier, Runnable removeTask) {
        return this.animateSingle(e -> true, animation, modifier, removeTask);
    }

    public boolean animateSingle(@NotNull Predicate<RenderedEntity> filter, @NotNull String animation, AnimationModifier modifier, Runnable removeTask) {
        boolean success = this.instance.animateSingle(filter, animation, modifier, this.wrapToSingle(removeTask));
        if (success) {
            this.runningSingle.set(true);
        }
        return success;
    }

    public void stopAnimation(@NotNull String animation) {
        this.stopAnimation(e -> true, animation);
    }

    public void stopAnimation(@NotNull Predicate<RenderedEntity> filter, @NotNull String animation) {
        this.instance.stopAnimation(filter, animation);
    }

    private Runnable wrapToSingle(@NotNull Runnable runnable) {
        return () -> {
            runnable.run();
            this.runningSingle.set(false);
        };
    }

    public boolean replaceLoop(@NotNull String target, @NotNull String animation) {
        return this.replaceLoop(e -> true, target, animation);
    }

    public boolean replaceSingle(@NotNull String target, @NotNull String animation) {
        return this.replaceSingle(e -> true, target, animation);
    }

    public boolean replaceLoop(@NotNull Predicate<RenderedEntity> filter, @NotNull String target, @NotNull String animation) {
        return this.instance.replaceLoop(filter, target, animation);
    }

    public boolean replaceSingle(@NotNull Predicate<RenderedEntity> filter, @NotNull String target, @NotNull String animation) {
        boolean success = this.instance.replaceSingle(filter, target, animation);
        if (success) {
            this.runningSingle.set(true);
        }
        return success;
    }

    public void togglePart(@NotNull Predicate<RenderedEntity> predicate, boolean toggle) {
        this.instance.togglePart(predicate, toggle);
    }

    @Nullable
    public RenderedEntity entity(@NotNull String name) {
        return this.instance.renderers().stream().filter(r -> r.getName().equals(name)).findFirst().orElse(null);
    }

    @NotNull
    public List<RenderedEntity> entity() {
        return this.instance.renderers();
    }

    @NotNull
    public List<ModelDisplay> displays() {
        return this.instance.renderers().stream().map(RenderedEntity::getDisplay).filter(Objects::nonNull).toList();
    }

    @Generated
    public Supplier<TrackerMovement> getMovement() {
        return this.movement;
    }
}

