/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.manager;

import com.destroystokyo.paper.event.entity.EntityAddToWorldEvent;
import com.destroystokyo.paper.event.entity.EntityRemoveFromWorldEvent;
import kr.toxicity.model.api.BetterModel;
import kr.toxicity.model.api.data.renderer.AnimationModifier;
import kr.toxicity.model.api.event.ModelInteractEvent;
import kr.toxicity.model.api.manager.EntityManager;
import kr.toxicity.model.api.scheduler.ModelTask;
import kr.toxicity.model.api.tracker.EntityTracker;
import kr.toxicity.model.manager.EntityManagerImpl;
import kr.toxicity.model.manager.GlobalManagerImpl;
import kr.toxicity.model.shaded.kotlin.Metadata;
import kr.toxicity.model.shaded.kotlin.jvm.internal.Intrinsics;
import kr.toxicity.model.shaded.kotlin.text.StringsKt;
import kr.toxicity.model.util.EventsKt;
import kr.toxicity.model.util.PluginsKt;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.entity.EntitySpawnEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.world.ChunkLoadEvent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lkr/toxicity/model/manager/EntityManagerImpl;", "Lkr/toxicity/model/api/manager/EntityManager;", "Lkr/toxicity/model/manager/GlobalManagerImpl;", "<init>", "()V", "reload", "", "core"})
public final class EntityManagerImpl
implements EntityManager,
GlobalManagerImpl {
    @NotNull
    public static final EntityManagerImpl INSTANCE = new EntityManagerImpl();

    private EntityManagerImpl() {
    }

    @Override
    public void reload() {
        if (BetterModel.IS_PAPER) {
            EventsKt.registerListener(new Listener(){

                @EventHandler
                public final void remove(EntityRemoveFromWorldEvent $this$remove) {
                    block1: {
                        Intrinsics.checkNotNullParameter($this$remove, "<this>");
                        EntityTracker entityTracker = EntityTracker.tracker($this$remove.getEntity());
                        if (entityTracker == null) break block1;
                        EntityTracker it = entityTracker;
                        boolean bl = false;
                        if (!it.forRemoval()) {
                            it.close();
                        }
                    }
                }

                @EventHandler
                public final void add(EntityAddToWorldEvent $this$add) {
                    block0: {
                        Intrinsics.checkNotNullParameter($this$add, "<this>");
                        EntityTracker entityTracker = EntityTracker.tracker($this$add.getEntity());
                        if (entityTracker == null) break block0;
                        entityTracker.refresh();
                    }
                }
            });
        } else {
            EventsKt.registerListener(new Listener(){

                @EventHandler
                public final void remove(EntityRemoveEvent $this$remove) {
                    block1: {
                        Intrinsics.checkNotNullParameter($this$remove, "<this>");
                        EntityTracker entityTracker = EntityTracker.tracker($this$remove.getEntity());
                        if (entityTracker == null) break block1;
                        EntityTracker it = entityTracker;
                        boolean bl = false;
                        if (!it.forRemoval()) {
                            it.close();
                        }
                    }
                }

                @EventHandler
                public final void add(EntitySpawnEvent $this$add) {
                    block0: {
                        Intrinsics.checkNotNullParameter($this$add, "<this>");
                        EntityTracker entityTracker = EntityTracker.tracker($this$add.getEntity());
                        if (entityTracker == null) break block0;
                        entityTracker.refresh();
                    }
                }
            });
        }
        EventsKt.registerListener(new Listener(){

            @EventHandler
            public final void interact(ModelInteractEvent $this$interact) {
                Intrinsics.checkNotNullParameter((Object)((Object)$this$interact), "<this>");
                String string = $this$interact.getHitBox().name();
                Intrinsics.checkNotNullExpressionValue(string, "name(...)");
                if (StringsKt.startsWith$default(string, "p_", false, 2, null)) {
                    $this$interact.getHitBox().addPassenger((Entity)$this$interact.getPlayer());
                }
            }

            @EventHandler
            public final void quit(PlayerQuitEvent $this$quit) {
                block0: {
                    Intrinsics.checkNotNullParameter($this$quit, "<this>");
                    EntityTracker entityTracker = EntityTracker.tracker($this$quit.getPlayer().getUniqueId());
                    if (entityTracker == null) break block0;
                    entityTracker.close();
                }
            }

            @EventHandler
            public final void load(ChunkLoadEvent $this$load) {
                Intrinsics.checkNotNullParameter($this$load, "<this>");
                Entity[] entityArray = $this$load.getChunk().getEntities();
                Intrinsics.checkNotNullExpressionValue(entityArray, "getEntities(...)");
                Object[] $this$forEach$iv = entityArray;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Entity it = (Entity)element$iv;
                    boolean bl = false;
                    EntityTracker entityTracker = EntityTracker.tracker(it);
                    if (entityTracker == null) continue;
                    entityTracker.refresh();
                }
            }

            @EventHandler
            public final void death(EntityDeathEvent $this$death) {
                block2: {
                    Intrinsics.checkNotNullParameter($this$death, "<this>");
                    EntityTracker entityTracker = EntityTracker.tracker((Entity)$this$death.getEntity());
                    if (entityTracker == null) break block2;
                    EntityTracker it = entityTracker;
                    boolean bl = false;
                    if (!it.animateSingle("death", AnimationModifier.DEFAULT, () -> reload.3.death$lambda$3$lambda$2($this$death, it))) {
                        it.close();
                    } else {
                        it.forRemoval(true);
                    }
                }
            }

            @EventHandler(ignoreCancelled=false)
            public final void damage(EntityDamageEvent $this$damage) {
                block3: {
                    Intrinsics.checkNotNullParameter($this$damage, "<this>");
                    Entity entity = $this$damage.getEntity();
                    Intrinsics.checkNotNullExpressionValue(entity, "getEntity(...)");
                    Entity e = entity;
                    if (!(e instanceof LivingEntity)) break block3;
                    EntityTracker entityTracker = EntityTracker.tracker(e);
                    if (entityTracker != null) {
                        EntityTracker it = entityTracker;
                        boolean bl = false;
                        if (it.animateSingle("damage", AnimationModifier.DEFAULT, () -> reload.3.damage$lambda$6$lambda$4(it))) {
                            it.tint(true);
                        } else {
                            it.tint(true);
                            ModelTask modelTask = PluginsKt.getPLUGIN().scheduler().asyncTaskLater((long)((LivingEntity)e).getMaximumNoDamageTicks() / (long)2, () -> reload.3.damage$lambda$6$lambda$5(it));
                            Intrinsics.checkNotNull(modelTask);
                        }
                    }
                }
            }

            private static final void death$lambda$3$lambda$2$lambda$1(EntityTracker $it) {
                $it.close();
            }

            private static final void death$lambda$3$lambda$2(EntityDeathEvent $this_death, EntityTracker $it) {
                PluginsKt.getPLUGIN().scheduler().task($this_death.getEntity().getLocation(), () -> reload.3.death$lambda$3$lambda$2$lambda$1($it));
            }

            private static final void damage$lambda$6$lambda$4(EntityTracker $it) {
                $it.tint(false);
            }

            private static final void damage$lambda$6$lambda$5(EntityTracker $it) {
                $it.tint(false);
            }
        });
    }

    @Override
    public void start() {
        GlobalManagerImpl.DefaultImpls.start(this);
    }

    @Override
    public void end() {
        GlobalManagerImpl.DefaultImpls.end(this);
    }
}

