/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.animation;

import java.util.function.BooleanSupplier;
import kr.toxicity.model.api.animation.AnimationIterator;
import kr.toxicity.model.api.util.FunctionUtil;
import kr.toxicity.model.api.util.function.FloatSupplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record AnimationModifier(@NotNull BooleanSupplier predicate, int start, int end, @Nullable AnimationIterator.Type type, @NotNull SpeedModifier speed) {
    public static final AnimationModifier DEFAULT = new AnimationModifier(1, 0, 1.0f);
    public static final AnimationModifier DEFAULT_WITH_PLAY_ONCE = new AnimationModifier(() -> true, 1, 0, AnimationIterator.Type.PLAY_ONCE, 1.0f);

    public AnimationModifier(int start2, int end, float speed) {
        this(() -> true, start2, end, null, speed);
    }

    public AnimationModifier(@NotNull BooleanSupplier predicate, int start2, int end, float speed) {
        this(predicate, start2, end, null, AnimationModifier.speed(speed));
    }

    public AnimationModifier(@NotNull BooleanSupplier predicate, int start2, int end, @NotNull FloatSupplier supplier) {
        this(predicate, start2, end, null, new SpeedModifier(supplier));
    }

    public AnimationModifier(@NotNull BooleanSupplier predicate, int start2, int end, @Nullable AnimationIterator.Type type, float speed) {
        this(predicate, start2, end, type, AnimationModifier.speed(speed));
    }

    public AnimationModifier(@NotNull BooleanSupplier predicate, int start2, int end, @Nullable AnimationIterator.Type type, @NotNull FloatSupplier speed) {
        this(predicate, start2, end, type, new SpeedModifier(speed));
    }

    public AnimationModifier(@NotNull BooleanSupplier predicate, int start2, int end, @Nullable AnimationIterator.Type type, @NotNull SpeedModifier speed) {
        this.predicate = FunctionUtil.throttleTickBoolean(predicate);
        this.start = start2;
        this.end = end;
        this.type = type;
        this.speed = speed;
    }

    @NotNull
    public static SpeedModifier speed(float speed) {
        return new SpeedModifier(speed);
    }

    @NotNull
    public static SpeedModifier speed(@NotNull FloatSupplier supplier) {
        return new SpeedModifier(supplier);
    }

    public float speedValue() {
        return this.speed.speed();
    }

    @NotNull
    public AnimationIterator.Type type(@NotNull AnimationIterator.Type defaultType) {
        return this.type != null ? this.type : defaultType;
    }

    public record SpeedModifier(@NotNull FloatSupplier supplier) {
        public SpeedModifier(@NotNull FloatSupplier supplier) {
            this.supplier = FunctionUtil.throttleTickFloat(supplier);
        }

        public SpeedModifier(float speed) {
            this(() -> speed);
        }

        public float speed() {
            return this.supplier.getAsFloat();
        }
    }
}

