/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.tracker;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import kr.toxicity.model.api.BetterModel;
import kr.toxicity.model.api.config.DebugConfig;
import kr.toxicity.model.api.nms.EntityAdapter;
import kr.toxicity.model.api.nms.ModelDisplay;
import kr.toxicity.model.api.nms.PacketBundler;
import kr.toxicity.model.api.nms.PlayerChannelHandler;
import kr.toxicity.model.api.tracker.EntityTracker;
import kr.toxicity.model.api.tracker.Tracker;
import kr.toxicity.model.api.tracker.TrackerData;
import kr.toxicity.model.api.util.LogUtil;
import kr.toxicity.model.api.util.entity.EntityId;
import lombok.Generated;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.persistence.PersistentDataType;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public final class EntityTrackerRegistry {
    private static final Map<UUID, EntityTrackerRegistry> UUID_REGISTRY_MAP = new ConcurrentHashMap<UUID, EntityTrackerRegistry>();
    private static final Map<EntityId, EntityTrackerRegistry> ID_REGISTRY_MAP = new ConcurrentHashMap<EntityId, EntityTrackerRegistry>();
    public static final NamespacedKey TRACKING_ID = Objects.requireNonNull(NamespacedKey.fromString((String)"bettermodel_tracker"));
    public static final Collection<EntityTrackerRegistry> REGISTRIES = Collections.unmodifiableCollection(UUID_REGISTRY_MAP.values());
    private final AtomicBoolean closed = new AtomicBoolean();
    private final AtomicBoolean autoSpawn = new AtomicBoolean(true);
    private final Entity entity;
    private final EntityId id;
    private final EntityAdapter adapter;
    private final ConcurrentNavigableMap<String, EntityTracker> trackerMap = new ConcurrentSkipListMap<String, EntityTracker>();
    private final Collection<EntityTracker> trackers = Collections.unmodifiableCollection(this.trackerMap.values());
    private final Map<UUID, PlayerChannelHandler> viewedPlayerMap = new ConcurrentHashMap<UUID, PlayerChannelHandler>();
    private Predicate<Player> spawnFilter = p -> this.autoSpawn() && p.getWorld() == this.entity().getWorld();
    private HideOption hideOption = HideOption.DEFAULT;

    @Nullable
    public static EntityTrackerRegistry registry(@NotNull UUID uuid) {
        return UUID_REGISTRY_MAP.get(uuid);
    }

    @Nullable
    public static EntityTrackerRegistry registry(@NotNull EntityId id) {
        return ID_REGISTRY_MAP.get(id);
    }

    @ApiStatus.Internal
    @NotNull
    public static EntityTrackerRegistry registry(@NotNull Entity entity) {
        EntityTrackerRegistry get = EntityTrackerRegistry.registry(entity.getUniqueId());
        if (get != null) {
            return get;
        }
        EntityTrackerRegistry registry = new EntityTrackerRegistry(entity);
        EntityTrackerRegistry put = UUID_REGISTRY_MAP.putIfAbsent(entity.getUniqueId(), registry);
        if (put != null) {
            return put;
        }
        ID_REGISTRY_MAP.put(registry.id, registry);
        registry.load();
        Stream<Object> stream = entity.getTrackedBy().stream();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            stream = Stream.concat(Stream.of(player), stream);
        }
        stream.map(p -> BetterModel.player(p.getUniqueId()).orElse(null)).filter(Objects::nonNull).forEach(h -> registry.viewedPlayerMap.put(h.player().getUniqueId(), (PlayerChannelHandler)h));
        return registry;
    }

    @NotNull
    private static Collection<JsonElement> deserialize(@Nullable String raw) {
        if (raw == null) {
            return Collections.emptyList();
        }
        JsonElement json = JsonParser.parseString((String)raw);
        return json.isJsonArray() ? json.getAsJsonArray().asList() : Collections.singletonList(json);
    }

    public static boolean hasModelData(@NotNull Entity entity) {
        return entity.getPersistentDataContainer().has(TRACKING_ID);
    }

    private EntityTrackerRegistry(@NotNull Entity entity) {
        this.entity = entity;
        this.id = EntityId.of(entity);
        this.adapter = BetterModel.plugin().nms().adapt(entity);
    }

    @NotNull
    public Entity entity() {
        return this.entity;
    }

    @NotNull
    public UUID uuid() {
        return this.entity().getUniqueId();
    }

    @NotNull
    public EntityId id() {
        return this.id;
    }

    @NotNull
    public EntityAdapter adapter() {
        return this.adapter;
    }

    @NotNull
    public @Unmodifiable Collection<EntityTracker> trackers() {
        return this.trackers;
    }

    @Nullable
    public EntityTracker tracker(@Nullable String key) {
        return key == null ? this.first() : (EntityTracker)this.trackerMap.get(key);
    }

    @Nullable
    public EntityTracker first() {
        Map.Entry entry = this.trackerMap.firstEntry();
        return entry != null ? (EntityTracker)entry.getValue() : null;
    }

    @ApiStatus.Internal
    @NotNull
    public EntityTracker create(@NotNull String key, @NotNull Function<EntityTrackerRegistry, EntityTracker> supplier) {
        EntityTracker created = supplier.apply(this);
        if (this.putTracker(key, created)) {
            this.refreshSpawn();
            this.save();
        }
        return created;
    }

    @NotNull
    public EntityTracker getOrCreate(@NotNull String key, @NotNull Function<EntityTrackerRegistry, EntityTracker> supplier) {
        EntityTracker get = (EntityTracker)this.trackerMap.get(key);
        return get != null ? get : this.create(key, supplier);
    }

    private boolean putTracker(@NotNull String key, @NotNull EntityTracker created) {
        if (created.isClosed()) {
            return false;
        }
        created.handleCloseEvent(t -> {
            if (this.isClosed()) {
                return;
            }
            if (this.trackerMap.compute(key, (k, v) -> v == created ? null : v) == null) {
                LogUtil.debug(DebugConfig.DebugOption.TRACKER, () -> String.valueOf(this.entity.getUniqueId()) + "'s tracker " + key + " has been removed. (" + this.trackerMap.size() + ")");
            }
            if (this.trackerMap.isEmpty()) {
                this.close0();
                LogUtil.debug(DebugConfig.DebugOption.TRACKER, () -> String.valueOf(this.entity.getUniqueId()) + "'s tracker registry has been removed. (" + REGISTRIES.size() + ")");
            }
        });
        EntityTracker previous = this.trackerMap.put(key, created);
        if (previous != null) {
            previous.close();
        }
        return true;
    }

    private void refreshSpawn() {
        for (PlayerChannelHandler value : this.viewedPlayerMap.values()) {
            this.spawn(value.player());
        }
    }

    public boolean remove(@NotNull String key) {
        try (EntityTracker removed = (EntityTracker)this.trackerMap.remove(key);){
            this.save();
            boolean bl = removed != null;
            return bl;
        }
    }

    public boolean isClosed() {
        return this.closed.get();
    }

    public boolean close() {
        if (this.closed.compareAndSet(false, true)) {
            this.close0();
            return true;
        }
        return false;
    }

    private void close0() {
        for (PlayerChannelHandler playerChannelHandler : this.viewedPlayerMap.values()) {
            playerChannelHandler.sendEntityData(this);
        }
        this.viewedPlayerMap.clear();
        for (EntityTracker entityTracker : this.trackerMap.values()) {
            entityTracker.close();
        }
        this.entity.getPersistentDataContainer().remove(TRACKING_ID);
        if (UUID_REGISTRY_MAP.remove(this.entity.getUniqueId()) != null) {
            ID_REGISTRY_MAP.remove(this.id);
        }
    }

    public void reload() {
        this.closed.set(true);
        ArrayList<TrackerData> data = new ArrayList<TrackerData>(this.trackerMap.size());
        for (EntityTracker value : this.trackerMap.values()) {
            data.add(value.asTrackerData());
            value.close();
        }
        this.trackerMap.clear();
        this.closed.set(false);
        this.load(data.stream());
    }

    public void refresh() {
        if (this.adapter.dead()) {
            return;
        }
        for (EntityTracker value : this.trackerMap.values()) {
            value.refresh();
        }
    }

    public void despawn() {
        for (EntityTracker value : this.trackerMap.values()) {
            if (value.forRemoval()) continue;
            value.despawn();
        }
    }

    public void load(@NotNull Stream<TrackerData> stream) {
        stream.forEach(parsed -> BetterModel.model(parsed.id()).ifPresent(model -> model.create(this.entity, parsed.modifier(), t -> {
            t.scaler(parsed.scaler());
            t.rotator(parsed.rotator());
        })));
        this.save();
    }

    public void load() {
        this.load(EntityTrackerRegistry.deserialize((String)this.entity.getPersistentDataContainer().get(TRACKING_ID, PersistentDataType.STRING)).stream().map(TrackerData::deserialize));
    }

    public void save() {
        this.entity.getPersistentDataContainer().set(TRACKING_ID, PersistentDataType.STRING, (Object)this.serialize().toString());
    }

    @NotNull
    public Stream<ModelDisplay> displays() {
        return this.trackerMap.values().stream().flatMap(Tracker::displays);
    }

    @NotNull
    public JsonArray serialize() {
        JsonArray array = new JsonArray(this.trackerMap.size());
        for (EntityTracker value : this.trackerMap.values()) {
            array.add(value.asTrackerData().serialize());
        }
        return array;
    }

    public boolean autoSpawn() {
        return this.autoSpawn.get();
    }

    public void autoSpawn(boolean spawn) {
        this.autoSpawn.set(spawn);
    }

    public boolean canBeSpawnedAt(@NotNull Player player) {
        return this.spawnFilter.test(player);
    }

    public void spawnFilter(@NotNull Predicate<Player> predicate) {
        this.spawnFilter = this.spawnFilter.and(predicate);
    }

    public boolean isSpawned(@NotNull Player player) {
        return this.isSpawned(player.getUniqueId());
    }

    public boolean isSpawned(@NotNull UUID uuid) {
        return this.viewedPlayerMap.containsKey(uuid);
    }

    public boolean spawnIfMatched(@NotNull Player player) {
        return !this.isClosed() && this.canBeSpawnedAt(player) && this.spawn(player);
    }

    public boolean spawn(@NotNull Player player) {
        PlayerChannelHandler handler = BetterModel.plugin().playerManager().player(player.getUniqueId());
        if (handler == null) {
            return false;
        }
        this.viewedPlayerMap.put(player.getUniqueId(), handler);
        if (this.trackerMap.isEmpty()) {
            return false;
        }
        PacketBundler bundler = BetterModel.plugin().nms().createBundler(10);
        for (EntityTracker value : this.trackerMap.values()) {
            value.spawn(player, bundler);
        }
        BetterModel.plugin().nms().mount(this, bundler);
        bundler.send(player, () -> BetterModel.plugin().nms().hide(player, this, () -> this.viewedPlayerMap.containsKey(player.getUniqueId())));
        return true;
    }

    public boolean remove(@NotNull Player player) {
        PlayerChannelHandler handler = this.viewedPlayerMap.remove(player.getUniqueId());
        if (handler == null) {
            return false;
        }
        handler.sendEntityData(this);
        for (EntityTracker value : this.trackerMap.values()) {
            if (value.forRemoval()) continue;
            value.remove(handler.player());
        }
        return true;
    }

    @NotNull
    public HideOption hideOption() {
        return this.hideOption;
    }

    public void hideOption(@NotNull HideOption hideOption) {
        this.hideOption = Objects.requireNonNull(hideOption);
    }

    public record HideOption(boolean equipment, boolean fire, boolean visibility, boolean glowing) {
        public static final HideOption DEFAULT = new HideOption(true, true, true, true);

        @Generated
        public static HideOptionBuilder builder() {
            return new HideOptionBuilder();
        }

        @Generated
        public static class HideOptionBuilder {
            @Generated
            private boolean equipment;
            @Generated
            private boolean fire;
            @Generated
            private boolean visibility;
            @Generated
            private boolean glowing;

            @Generated
            HideOptionBuilder() {
            }

            @Generated
            public HideOptionBuilder equipment(boolean equipment) {
                this.equipment = equipment;
                return this;
            }

            @Generated
            public HideOptionBuilder fire(boolean fire) {
                this.fire = fire;
                return this;
            }

            @Generated
            public HideOptionBuilder visibility(boolean visibility) {
                this.visibility = visibility;
                return this;
            }

            @Generated
            public HideOptionBuilder glowing(boolean glowing) {
                this.glowing = glowing;
                return this;
            }

            @Generated
            public HideOption build() {
                return new HideOption(this.equipment, this.fire, this.visibility, this.glowing);
            }

            @Generated
            public String toString() {
                return "EntityTrackerRegistry.HideOption.HideOptionBuilder(equipment=" + this.equipment + ", fire=" + this.fire + ", visibility=" + this.visibility + ", glowing=" + this.glowing + ")";
            }
        }
    }
}

