/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.data.blueprint;

import com.google.common.util.concurrent.AtomicDouble;
import it.unimi.dsi.fastutil.floats.Float2ObjectMap;
import it.unimi.dsi.fastutil.floats.Float2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.floats.FloatAVLTreeSet;
import it.unimi.dsi.fastutil.floats.FloatBidirectionalIterator;
import it.unimi.dsi.fastutil.floats.FloatCollection;
import it.unimi.dsi.fastutil.floats.FloatSet;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Stream;
import kr.toxicity.model.api.animation.AnimationMovement;
import kr.toxicity.model.api.animation.AnimationPoint;
import kr.toxicity.model.api.animation.VectorPoint;
import kr.toxicity.model.api.bone.BoneName;
import kr.toxicity.model.api.data.blueprint.BlueprintAnimator;
import kr.toxicity.model.api.data.blueprint.BlueprintChildren;
import kr.toxicity.model.api.util.CollectionUtil;
import kr.toxicity.model.api.util.InterpolationUtil;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public final class AnimationGenerator {
    private static final Vector3f EMPTY = new Vector3f();
    private final Map<BoneName, BlueprintAnimator.AnimatorData> pointMap;
    private final List<AnimationTree> trees;
    private float firstTime = 0.0f;
    private float secondTime = 0.0f;

    @NotNull
    public static Map<BoneName, BlueprintAnimator> createMovements(@NotNull List<BlueprintChildren> children, @NotNull Map<BoneName, BlueprintAnimator.AnimatorData> pointMap) {
        FloatAVLTreeSet floatSet = CollectionUtil.mapFloat(pointMap.values().stream().flatMap(d2 -> d2.points().stream()), p -> InterpolationUtil.roundTime(p.position().time()), FloatAVLTreeSet::new);
        InterpolationUtil.insertLerpFrame((FloatCollection)floatSet);
        new AnimationGenerator(pointMap, children).interpolateRotation((FloatSet)floatSet);
        return CollectionUtil.mapValue(pointMap, v -> {
            AtomicDouble doubleCache = new AtomicDouble();
            return new BlueprintAnimator(v.name(), InterpolationUtil.putAnimationPoint(v.points(), (FloatSet)floatSet).stream().map(point -> {
                AnimationMovement animation = point.toMovement();
                return animation.time(InterpolationUtil.roundTime(animation.time() - (float)doubleCache.getAndSet((double)animation.time())));
            }).toList());
        });
    }

    private AnimationGenerator(@NotNull Map<BoneName, BlueprintAnimator.AnimatorData> pointMap, @NotNull List<BlueprintChildren> children) {
        this.pointMap = pointMap;
        this.trees = CollectionUtil.filterIsInstance(children, BlueprintChildren.BlueprintGroup.class).map(g -> {
            BlueprintAnimator.AnimatorData get = (BlueprintAnimator.AnimatorData)pointMap.get(g.name());
            return new AnimationTree((BlueprintChildren.BlueprintGroup)g, get != null ? get.points() : Collections.emptyList());
        }).flatMap(AnimationTree::flatten).toList();
    }

    public void interpolateRotation(@NotNull FloatSet floats) {
        FloatBidirectionalIterator iterator2 = new FloatAVLTreeSet((FloatCollection)floats).iterator();
        while (iterator2.hasNext()) {
            double max;
            double minus2;
            float length;
            this.firstTime = this.secondTime;
            this.secondTime = iterator2.nextFloat();
            if (this.secondTime - this.firstTime <= 0.0f || (length = (float)Math.ceil(Math.max((minus2 = this.trees.stream().mapToDouble(t -> t.addTree(this.firstTime, this.secondTime, AnimationPoint::rotation)).max().orElse(0.0)) / 90.0, (max = this.trees.stream().mapToDouble(t -> t.maxTree(this.firstTime, this.secondTime, AnimationPoint::rotation)).max().orElse(0.0)) / 60.0))) < 2.0f) continue;
            float last = this.firstTime;
            for (float f = 1.0f; f < length; f += 1.0f) {
                float addTime = InterpolationUtil.roundTime(InterpolationUtil.lerp(this.firstTime, this.secondTime, f / length));
                if ((double)(addTime - last) < 0.01 || (double)(this.secondTime - addTime) < 0.01) continue;
                last = addTime;
                floats.add(last);
            }
        }
    }

    private static float max(@NotNull Vector3f vector3f) {
        return Math.max(Math.abs(vector3f.x), Math.max(Math.abs(vector3f.y), Math.abs(vector3f.z)));
    }

    private class AnimationTree {
        private final AnimationTree parent;
        private final List<AnimationTree> children;
        private final List<AnimationPoint> points;
        private int searchCache = 0;
        private final Float2ObjectMap<Vector3f> valueCache = new Float2ObjectOpenHashMap();

        AnimationTree(@NotNull BlueprintChildren.BlueprintGroup group, List<AnimationPoint> points) {
            this(null, group, points);
        }

        AnimationTree(@NotNull AnimationTree parent, @NotNull BlueprintChildren.BlueprintGroup group, List<AnimationPoint> points) {
            this.parent = parent;
            this.points = points;
            this.children = CollectionUtil.filterIsInstance(group.children(), BlueprintChildren.BlueprintGroup.class).map(g -> {
                BlueprintAnimator.AnimatorData get = AnimationGenerator.this.pointMap.get(g.name());
                return new AnimationTree(this, (BlueprintChildren.BlueprintGroup)g, get != null ? get.points() : Collections.emptyList());
            }).toList();
        }

        @NotNull
        Stream<AnimationTree> flatten() {
            return this.children.isEmpty() ? Stream.of(this) : this.children.stream().flatMap(AnimationTree::flatten);
        }

        private float addTree(float first, float second, @NotNull Function<AnimationPoint, VectorPoint> mapper) {
            return AnimationGenerator.max(this.findTree(first, second, mapper));
        }

        private float maxTree(float first, float second, @NotNull Function<AnimationPoint, VectorPoint> mapper) {
            float get = AnimationGenerator.max(this.find(first, second, mapper));
            return this.parent != null ? Math.max(this.parent.maxTree(first, second, mapper), get) : get;
        }

        @NotNull
        private Vector3f findTree(float first, float second, @NotNull Function<AnimationPoint, VectorPoint> mapper) {
            Vector3f get = this.find(first, second, mapper);
            return this.parent != null ? this.parent.findTree(first, second, mapper).add((Vector3fc)get) : get;
        }

        @NotNull
        private Vector3f find(float first, float second, @NotNull Function<AnimationPoint, VectorPoint> mapper) {
            return this.find(second, mapper).sub((Vector3fc)this.find(first, mapper), new Vector3f());
        }

        @NotNull
        private Vector3f find(float time, @NotNull Function<AnimationPoint, VectorPoint> mapper) {
            return (Vector3f)this.valueCache.computeIfAbsent(time, f -> {
                int i;
                if (this.points.isEmpty()) {
                    return EMPTY;
                }
                if (this.points.size() == 1) {
                    return EMPTY;
                }
                for (i = this.searchCache; i < this.points.size() && !(((VectorPoint)mapper.apply(this.points.get(i))).time() >= time); ++i) {
                }
                this.searchCache = i;
                if (i == 0) {
                    return EMPTY;
                }
                if (i == this.points.size()) {
                    return EMPTY;
                }
                VectorPoint first = (VectorPoint)mapper.apply(this.points.get(i - 1));
                VectorPoint second = (VectorPoint)mapper.apply(this.points.get(i));
                return second.time() == time ? second.vector() : InterpolationUtil.lerp(first.vector(), second.vector(), InterpolationUtil.alpha(first.time(), second.time(), time));
            });
        }
    }
}

