/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.data.raw;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import java.util.function.Function;
import kr.toxicity.model.api.util.MathUtil;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public record Float3(float x, float y, float z) {
    public static final Float3 CENTER = new Float3(8.0f, 8.0f, 8.0f);
    public static final Float3 ZERO = new Float3(0.0f, 0.0f, 0.0f);
    public static final Function<JsonElement, Float3> PARSER = element -> {
        if (element == null) {
            return new Float3(0.0f, 0.0f, 0.0f);
        }
        JsonArray array = element.getAsJsonArray();
        return new Float3(array.get(0).getAsFloat(), array.get(1).getAsFloat(), array.get(2).getAsFloat());
    };

    public Float3(float value) {
        this(value, value, value);
    }

    @NotNull
    public Float3 plus(@NotNull Float3 other) {
        return new Float3(this.x + other.x, this.y + other.y, this.z + other.z);
    }

    @NotNull
    public Float3 convertToMinecraftDegree() {
        Vector3f vec = MathUtil.toMinecraftVector(this.toVector());
        return new Float3(vec.x, vec.y, vec.z);
    }

    @NotNull
    public Float3 rotate(@NotNull Quaternionf quaternionf) {
        Vector3f vec = this.toVector().rotate((Quaternionfc)quaternionf);
        return new Float3(vec.x, vec.y, vec.z);
    }

    @NotNull
    public Float3 minus(@NotNull Float3 other) {
        return new Float3(this.x - other.x, this.y - other.y, this.z - other.z);
    }

    @NotNull
    public Float3 times(float value) {
        return new Float3(this.x * value, this.y * value, this.z * value);
    }

    @NotNull
    public Float3 div(float value) {
        return new Float3(this.x / value, this.y / value, this.z / value);
    }

    @NotNull
    public JsonArray toJson() {
        JsonArray array = new JsonArray();
        array.add((Number)Float.valueOf(this.x));
        array.add((Number)Float.valueOf(this.y));
        array.add((Number)Float.valueOf(this.z));
        return array;
    }

    @NotNull
    public Vector3f toVector() {
        return new Vector3f(this.x, this.y, this.z);
    }
}

