/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.data.renderer;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import kr.toxicity.model.api.BetterModel;
import kr.toxicity.model.api.data.blueprint.AnimationMovement;
import kr.toxicity.model.api.data.blueprint.BlueprintAnimation;
import kr.toxicity.model.api.data.renderer.AnimationModifier;
import kr.toxicity.model.api.data.renderer.BlueprintRenderer;
import kr.toxicity.model.api.entity.RenderedEntity;
import kr.toxicity.model.api.entity.TrackerMovement;
import kr.toxicity.model.api.nms.EntityAdapter;
import kr.toxicity.model.api.nms.HitBoxListener;
import kr.toxicity.model.api.nms.PacketBundler;
import kr.toxicity.model.api.nms.PlayerChannelHandler;
import kr.toxicity.model.api.script.ScriptProcessor;
import kr.toxicity.model.api.tracker.ModelRotation;
import kr.toxicity.model.api.util.FunctionUtil;
import lombok.Generated;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import org.joml.Vector3fc;

@ApiStatus.Internal
public final class RenderInstance
implements AutoCloseable {
    private final BlueprintRenderer parent;
    private final Map<String, RenderedEntity> entityMap;
    private final Map<String, BlueprintAnimation> animationMap;
    private final Map<UUID, PlayerChannelHandler> playerMap = new ConcurrentHashMap<UUID, PlayerChannelHandler>();
    private Predicate<Player> filter = p -> true;
    private Predicate<Player> spawnFilter = p -> !this.playerMap.containsKey(p.getUniqueId());
    private ModelRotation rotation = ModelRotation.EMPTY;
    private final ScriptProcessor scriptProcessor = new ScriptProcessor();

    public RenderInstance(@NotNull BlueprintRenderer parent, @NotNull Map<String, RenderedEntity> entityMap, @NotNull Map<String, BlueprintAnimation> animationMap) {
        this.parent = parent;
        this.entityMap = entityMap;
        this.animationMap = animationMap;
        this.animateLoop("idle");
    }

    public void filter(@NotNull Predicate<Player> filter) {
        this.filter = this.filter.and(FunctionUtil.throttleTick(filter));
    }

    @NotNull
    public Predicate<Player> spawnFilter() {
        return this.spawnFilter;
    }

    public void spawnFilter(@NotNull Predicate<Player> spawnFilter) {
        this.spawnFilter = this.spawnFilter.and(spawnFilter);
    }

    public void createHitBox(@NotNull EntityAdapter entity, @NotNull Predicate<RenderedEntity> predicate, @Nullable HitBoxListener listener) {
        for (RenderedEntity value : this.entityMap.values()) {
            value.createHitBox(entity, predicate, listener);
        }
    }

    @Override
    public void close() throws Exception {
        for (RenderedEntity renderedEntity : this.entityMap.values()) {
            renderedEntity.close();
        }
        for (PlayerChannelHandler playerChannelHandler : this.playerMap.values()) {
            this.remove0(playerChannelHandler.player());
        }
        this.playerMap.clear();
    }

    public void teleport(@NotNull Location location, @NotNull PacketBundler bundler) {
        this.entityMap.values().forEach(e -> e.teleport(location, bundler));
    }

    public void move(@Nullable ModelRotation rotation, @NotNull TrackerMovement movement, @NotNull PacketBundler bundler) {
        ModelRotation rot = rotation == null || rotation.equals(this.rotation) ? null : (this.rotation = rotation);
        this.entityMap.values().forEach(e -> e.move(rot, movement, bundler));
    }

    public void defaultPosition(@NotNull Vector3f movement) {
        for (RenderedEntity value : this.entityMap.values()) {
            value.defaultPosition(new Vector3f((Vector3fc)movement).add((Vector3fc)value.getGroup().getPosition()));
        }
    }

    public void forceUpdate(@NotNull PacketBundler bundler) {
        for (RenderedEntity value : this.entityMap.values()) {
            value.forceUpdate(bundler);
        }
    }

    public void itemStack(@NotNull Predicate<RenderedEntity> predicate, @NotNull ItemStack itemStack) {
        for (RenderedEntity value : this.entityMap.values()) {
            value.itemStack(predicate, itemStack);
        }
    }

    public boolean addAnimationMovementModifier(@NotNull Consumer<AnimationMovement> consumer) {
        return this.addAnimationMovementModifier(r -> true, consumer);
    }

    public boolean addAnimationMovementModifier(@NotNull Predicate<RenderedEntity> predicate, @NotNull Consumer<AnimationMovement> consumer) {
        boolean ret = false;
        for (RenderedEntity value : this.entityMap.values()) {
            if (!value.addAnimationMovementModifier(predicate, consumer)) continue;
            ret = true;
        }
        return ret;
    }

    @NotNull
    public List<RenderedEntity> renderers() {
        ArrayList<RenderedEntity> list = new ArrayList<RenderedEntity>();
        this.entityMap.values().forEach(e -> e.renderers(list));
        return list;
    }

    public double height() {
        double h = 0.0;
        for (RenderedEntity renderer : this.renderers()) {
            float lt = renderer.worldPosition().y;
            if (renderer.getName().startsWith("h_")) {
                return lt;
            }
            if (!(h < (double)lt)) continue;
            h = lt;
        }
        return h;
    }

    public void tint(@NotNull Predicate<RenderedEntity> predicate, int rgb) {
        PacketBundler bundler = BetterModel.inst().nms().createBundler();
        this.entityMap.values().forEach(e -> e.tint(predicate, rgb, bundler));
        if (!bundler.isEmpty()) {
            this.viewedPlayer().forEach(bundler::send);
        }
    }

    public boolean animateLoop(@NotNull String animation) {
        return this.animateLoop(e -> true, animation, AnimationModifier.DEFAULT_LOOP, () -> {});
    }

    public boolean animateSingle(@NotNull String animation) {
        return this.animateSingle(e -> true, animation, AnimationModifier.DEFAULT, () -> {});
    }

    public boolean animateLoop(@NotNull String animation, AnimationModifier modifier) {
        return this.animateLoop(e -> true, animation, modifier, () -> {});
    }

    public boolean animateSingle(@NotNull String animation, AnimationModifier modifier) {
        return this.animateSingle(e -> true, animation, modifier, () -> {});
    }

    public boolean animateLoop(@NotNull Predicate<RenderedEntity> filter, @NotNull String animation, AnimationModifier modifier, Runnable removeTask) {
        BlueprintAnimation get = this.animationMap.get(animation);
        if (get == null) {
            return false;
        }
        this.scriptProcessor.animateLoop(get.script(), modifier);
        for (RenderedEntity value : this.entityMap.values()) {
            value.addLoop(filter, animation, get, modifier, FunctionUtil.throttleTick(removeTask));
        }
        return true;
    }

    public boolean animateSingle(@NotNull Predicate<RenderedEntity> filter, @NotNull String animation, AnimationModifier modifier, Runnable removeTask) {
        BlueprintAnimation get = this.animationMap.get(animation);
        if (get == null) {
            return false;
        }
        this.scriptProcessor.animateSingle(get.script(), modifier);
        for (RenderedEntity value : this.entityMap.values()) {
            value.addSingle(filter, animation, get, modifier, FunctionUtil.throttleTick(removeTask));
        }
        return true;
    }

    public boolean replaceLoop(@NotNull Predicate<RenderedEntity> filter, @NotNull String target, @NotNull String animation) {
        BlueprintAnimation get = this.animationMap.get(animation);
        if (get == null) {
            return false;
        }
        this.scriptProcessor.replaceLoop(get.script(), AnimationModifier.DEFAULT_LOOP);
        for (RenderedEntity value : this.entityMap.values()) {
            value.replaceLoop(filter, target, animation, get);
        }
        return true;
    }

    public boolean replaceSingle(@NotNull Predicate<RenderedEntity> filter, @NotNull String target, @NotNull String animation) {
        BlueprintAnimation get = this.animationMap.get(animation);
        if (get == null) {
            return false;
        }
        this.scriptProcessor.replaceSingle(get.script(), AnimationModifier.DEFAULT);
        for (RenderedEntity value : this.entityMap.values()) {
            value.replaceSingle(filter, target, animation, get);
        }
        return true;
    }

    public void replaceModifier(@NotNull Predicate<RenderedEntity> filter, @NotNull Function<AnimationModifier, AnimationModifier> function) {
        for (RenderedEntity value : this.entityMap.values()) {
            value.replaceModifier(filter, function);
        }
    }

    public void stopAnimation(@NotNull Predicate<RenderedEntity> filter, @NotNull String target) {
        this.scriptProcessor.stopAnimation(target);
        for (RenderedEntity value : this.entityMap.values()) {
            value.stopAnimation(filter, target);
        }
    }

    public void spawn(@NotNull Player player, @NotNull PacketBundler bundler) {
        PlayerChannelHandler get = BetterModel.inst().playerManager().player(player.getUniqueId());
        if (get == null) {
            return;
        }
        this.playerMap.computeIfAbsent(player.getUniqueId(), u -> {
            this.entityMap.values().forEach(e -> e.spawn(bundler));
            return get;
        });
    }

    public void remove(@NotNull Player player) {
        if (this.playerMap.remove(player.getUniqueId()) == null) {
            return;
        }
        this.remove0(player);
    }

    private void remove0(@NotNull Player player) {
        PacketBundler bundler = BetterModel.inst().nms().createBundler();
        this.entityMap.values().forEach(e -> e.remove(bundler));
        bundler.send(player);
    }

    public void togglePart(@NotNull Predicate<RenderedEntity> predicate, boolean toggle) {
        PacketBundler bundler = BetterModel.inst().nms().createBundler();
        this.entityMap.values().forEach(e -> e.togglePart(bundler, predicate, toggle));
        if (!bundler.isEmpty()) {
            this.viewedPlayer().forEach(bundler::send);
        }
    }

    public int viewedPlayerSize() {
        return this.playerMap.size();
    }

    @NotNull
    public Stream<PlayerChannelHandler> allPlayer() {
        return this.playerMap.values().stream();
    }

    @NotNull
    public Stream<Player> viewedPlayer() {
        return this.viewedPlayer(this.filter);
    }

    @NotNull
    public Stream<Player> viewedPlayer(@NotNull Predicate<Player> predicate) {
        return this.allPlayer().map(PlayerChannelHandler::player).filter(predicate);
    }

    @Generated
    public BlueprintRenderer getParent() {
        return this.parent;
    }

    @Generated
    public ModelRotation getRotation() {
        return this.rotation;
    }

    @Generated
    public ScriptProcessor getScriptProcessor() {
        return this.scriptProcessor;
    }
}

