/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.data.renderer;

import java.util.Map;
import java.util.stream.Collectors;
import kr.toxicity.model.api.data.blueprint.BlueprintChildren;
import kr.toxicity.model.api.data.blueprint.NamedBoundingBox;
import kr.toxicity.model.api.entity.EntityMovement;
import kr.toxicity.model.api.entity.RenderedEntity;
import kr.toxicity.model.api.mount.MountController;
import kr.toxicity.model.api.mount.MountControllers;
import kr.toxicity.model.api.player.PlayerLimb;
import kr.toxicity.model.api.util.MathUtil;
import lombok.Generated;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.ItemDisplay;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public final class RendererGroup {
    private final String name;
    private final BlueprintChildren.BlueprintGroup parent;
    private final Vector3f scale;
    private final Vector3f position;
    private final Vector3f rotation;
    private final ItemStack itemStack;
    private final @Unmodifiable Map<String, RendererGroup> children;
    @Nullable
    private final NamedBoundingBox hitBox;
    private final Vector3f center;
    @Nullable
    private final PlayerLimb limb;
    @NotNull
    private final MountController mountController;

    public RendererGroup(@NotNull String name, float scale, @Nullable ItemStack itemStack, @NotNull BlueprintChildren.BlueprintGroup group, @NotNull Map<String, RendererGroup> children, @Nullable NamedBoundingBox box, @Nullable PlayerLimb limb) {
        this.name = name;
        this.limb = limb;
        this.scale = limb != null ? new Vector3f((Vector3fc)limb.getSlimScale()) : new Vector3f(scale);
        this.parent = group;
        this.children = children;
        this.itemStack = itemStack;
        this.position = MathUtil.blockBenchToDisplay(group.origin().toVector().div(16.0f));
        this.hitBox = box;
        this.rotation = group.rotation().toVector();
        Vector3f vector3f = this.center = this.hitBox != null ? this.hitBox.centerVector() : new Vector3f();
        this.mountController = name.startsWith("p_") ? MountControllers.DEFAULT : (name.startsWith("sp_") ? MountControllers.NONE : MountControllers.INVALID);
    }

    @NotNull
    public RenderedEntity create(@Nullable Player player, @NotNull Location location) {
        return this.create(player, null, location);
    }

    @NotNull
    private RenderedEntity create(@Nullable Player player, @Nullable RenderedEntity entityParent, @NotNull Location location) {
        RenderedEntity entity = new RenderedEntity(this, entityParent, this.getItem(player), this.limb != null ? this.limb.getTransform() : ItemDisplay.ItemDisplayTransform.FIXED, location, new EntityMovement(entityParent != null ? new Vector3f((Vector3fc)this.position).sub((Vector3fc)entityParent.getGroup().position) : new Vector3f(), new Vector3f(1.0f), MathUtil.toQuaternion(MathUtil.blockBenchToDisplay(this.rotation)), this.rotation));
        entity.setChildren(this.children.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((RendererGroup)e.getValue()).create(player, entity, location))));
        return entity;
    }

    @Nullable
    private ItemStack getItem(@Nullable Player player) {
        if (player != null) {
            return this.limb != null ? this.limb.createItem(player) : null;
        }
        return this.itemStack;
    }

    @NotNull
    public ItemStack getItemStack() {
        return this.itemStack != null ? this.itemStack.clone() : new ItemStack(Material.AIR);
    }

    @Generated
    public RendererGroup(String name, BlueprintChildren.BlueprintGroup parent, Vector3f scale, Vector3f position, Vector3f rotation, ItemStack itemStack, Map<String, RendererGroup> children, @Nullable NamedBoundingBox hitBox, Vector3f center, @Nullable PlayerLimb limb, @NotNull MountController mountController) {
        if (mountController == null) {
            throw new NullPointerException("mountController is marked non-null but is null");
        }
        this.name = name;
        this.parent = parent;
        this.scale = scale;
        this.position = position;
        this.rotation = rotation;
        this.itemStack = itemStack;
        this.children = children;
        this.hitBox = hitBox;
        this.center = center;
        this.limb = limb;
        this.mountController = mountController;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public BlueprintChildren.BlueprintGroup getParent() {
        return this.parent;
    }

    @Generated
    public Vector3f getScale() {
        return this.scale;
    }

    @Generated
    public Vector3f getPosition() {
        return this.position;
    }

    @Generated
    public Map<String, RendererGroup> getChildren() {
        return this.children;
    }

    @Nullable
    @Generated
    public NamedBoundingBox getHitBox() {
        return this.hitBox;
    }

    @Generated
    public Vector3f getCenter() {
        return this.center;
    }

    @Nullable
    @Generated
    public PlayerLimb getLimb() {
        return this.limb;
    }

    @NotNull
    @Generated
    public MountController getMountController() {
        return this.mountController;
    }
}

