/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.tracker;

import com.google.gson.annotations.SerializedName;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Supplier;
import kr.toxicity.model.api.nms.EntityAdapter;
import kr.toxicity.model.api.tracker.EntityTrackerRegistry;
import kr.toxicity.model.api.tracker.ModelRotation;
import kr.toxicity.model.api.util.FunctionUtil;
import kr.toxicity.model.api.util.MathUtil;
import kr.toxicity.model.api.util.lazy.LazyFloatProvider;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;

public final class EntityBodyRotator {
    private final EntityTrackerRegistry registry;
    private final EntityAdapter adapter;
    private final LazyFloatProvider provider;
    private final Supplier<Vector3f> headSupplier;
    private final Supplier<ModelRotation> bodySupplier;
    private final AtomicBoolean rotationLock = new AtomicBoolean();
    private int tick;
    private ModelRotation rotation;
    private volatile boolean headUneven;
    private volatile boolean bodyUneven;
    private volatile boolean playerMode;
    private volatile float minBody;
    private volatile float maxBody;
    private volatile float minHead;
    private volatile float maxHead;
    private volatile float stable;
    private volatile int rotationDuration;
    private volatile int rotationDelay;

    EntityBodyRotator(@NotNull EntityTrackerRegistry registry) {
        this.registry = registry;
        this.adapter = registry.adapter();
        this.rotation = new ModelRotation(this.adapter.pitch(), this.adapter.bodyYaw());
        this.provider = new LazyFloatProvider(this.adapter.bodyYaw(), () -> this.rotationDuration * MathUtil.MINECRAFT_TICK_MILLS);
        this.headSupplier = LazyFloatProvider.ofVector(10L, () -> 4 * MathUtil.MINECRAFT_TICK_MILLS, () -> {
            float value = this.bodyRotation().y() - this.adapter.headYaw();
            if (value > 180.0f) {
                value -= 360.0f;
            } else if (value < -180.0f) {
                value += 360.0f;
            }
            return new Vector3f(this.clampHead(this.adapter.pitch()), this.clampHead(value), 0.0f);
        });
        this.bodySupplier = FunctionUtil.throttleTick(() -> new ModelRotation(this.adapter.pitch(), this.bodyRotation0()));
        this.reset();
    }

    private float clampHead(float value) {
        return Math.clamp(value, this.headUneven ? this.minHead : -this.maxHead, this.maxHead);
    }

    private float clampBody(float value, float compare) {
        return Math.clamp(value, compare + (this.bodyUneven ? this.minBody : -this.maxBody), compare + this.maxBody);
    }

    public boolean lockRotation(boolean lock) {
        return this.rotationLock.compareAndSet(!lock, lock);
    }

    @NotNull
    ModelRotation bodyRotation() {
        return this.rotationLock.get() ? this.rotation : (this.rotation = this.bodySupplier.get());
    }

    private float bodyRotation0() {
        if (this.playerMode) {
            return this.adapter.headYaw();
        }
        if (this.registry.hasControllingPassenger()) {
            return this.adapter.bodyYaw();
        }
        float headYaw = this.adapter.headYaw();
        if (EntityBodyRotator.isSimilar(headYaw, this.rotation.y())) {
            this.tick = 0;
        }
        if (this.adapter.onWalk()) {
            this.tick = 0;
            return this.stableBodyYaw();
        }
        if (++this.tick > this.rotationDelay) {
            float providedYaw = this.provider.updateAndGet(headYaw);
            return this.clampBody(providedYaw, headYaw);
        }
        this.provider.storedValue(this.rotation.y());
        return this.rotation.y();
    }

    private float stableBodyYaw() {
        float yaw = this.adapter.bodyYaw();
        float headYaw = this.adapter.headYaw();
        float minStable = EntityBodyRotator.correctYaw(headYaw - this.stable);
        float maxStable = EntityBodyRotator.correctYaw(headYaw + this.stable);
        return Math.clamp(yaw, Math.min(minStable, maxStable), Math.max(minStable, maxStable));
    }

    private static float correctYaw(float target) {
        if (target < 0.0f) {
            target += 360.0f;
        }
        return target % 360.0f;
    }

    private static boolean isSimilar(float a, float b) {
        return Math.abs(a - b) < 0.001f;
    }

    @NotNull
    Vector3f headRotation() {
        return this.headSupplier.get();
    }

    public void setValue(@NotNull Consumer<RotatorData> consumer) {
        Objects.requireNonNull(consumer);
        RotatorData data = this.createData();
        consumer.accept(data);
        this.setValue(data);
    }

    synchronized void setValue(@NotNull RotatorData data) {
        data.set(this);
    }

    public void reset() {
        this.setValue(RotatorData.defaultData());
    }

    @NotNull
    synchronized RotatorData createData() {
        return new RotatorData(this.headUneven, this.bodyUneven, this.playerMode, this.minBody, this.maxBody, this.minHead, this.maxHead, this.stable, this.rotationDuration, this.rotationDelay);
    }

    public static final class RotatorData {
        @SerializedName(value="head_uneven")
        private boolean headUneven;
        @SerializedName(value="body_uneven")
        private boolean bodyUneven;
        @SerializedName(value="player_mode")
        private boolean playerMode;
        @SerializedName(value="min_body")
        private float minBody;
        @SerializedName(value="max_body")
        private float maxBody;
        @SerializedName(value="min_head")
        private float minHead;
        @SerializedName(value="max_head")
        private float maxHead;
        @SerializedName(value="stable")
        private float stable;
        @SerializedName(value="rotation_duration")
        private int rotationDuration;
        @SerializedName(value="rotation_delay")
        private int rotationDelay;

        @NotNull
        static RotatorData defaultData() {
            return new RotatorData(false, false, false, -75.0f, 75.0f, -75.0f, 75.0f, 15.0f, 10, 10);
        }

        private void set(@NotNull EntityBodyRotator rotator) {
            rotator.headUneven = this.headUneven;
            rotator.bodyUneven = this.bodyUneven;
            rotator.playerMode = this.playerMode;
            rotator.minBody = Math.min(this.minBody, this.maxBody);
            rotator.maxBody = Math.max(this.minBody, this.maxBody);
            rotator.minHead = Math.min(this.minHead, this.maxHead);
            rotator.maxHead = Math.max(this.minBody, this.maxHead);
            rotator.stable = Math.max(this.stable, 0.0f);
            rotator.rotationDuration = Math.max(this.rotationDuration, 0);
            rotator.rotationDelay = Math.max(this.rotationDelay, 0);
        }

        @Generated
        public void setHeadUneven(boolean headUneven) {
            this.headUneven = headUneven;
        }

        @Generated
        public void setBodyUneven(boolean bodyUneven) {
            this.bodyUneven = bodyUneven;
        }

        @Generated
        public void setPlayerMode(boolean playerMode) {
            this.playerMode = playerMode;
        }

        @Generated
        public void setMinBody(float minBody) {
            this.minBody = minBody;
        }

        @Generated
        public void setMaxBody(float maxBody) {
            this.maxBody = maxBody;
        }

        @Generated
        public void setMinHead(float minHead) {
            this.minHead = minHead;
        }

        @Generated
        public void setMaxHead(float maxHead) {
            this.maxHead = maxHead;
        }

        @Generated
        public void setStable(float stable) {
            this.stable = stable;
        }

        @Generated
        public void setRotationDuration(int rotationDuration) {
            this.rotationDuration = rotationDuration;
        }

        @Generated
        public void setRotationDelay(int rotationDelay) {
            this.rotationDelay = rotationDelay;
        }

        @Generated
        public RotatorData(boolean headUneven, boolean bodyUneven, boolean playerMode, float minBody, float maxBody, float minHead, float maxHead, float stable, int rotationDuration, int rotationDelay) {
            this.headUneven = headUneven;
            this.bodyUneven = bodyUneven;
            this.playerMode = playerMode;
            this.minBody = minBody;
            this.maxBody = maxBody;
            this.minHead = minHead;
            this.maxHead = maxHead;
            this.stable = stable;
            this.rotationDuration = rotationDuration;
            this.rotationDelay = rotationDelay;
        }
    }
}

