/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.tracker;

import java.util.List;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import kr.toxicity.model.api.BetterModel;
import kr.toxicity.model.api.BetterModelConfig;
import kr.toxicity.model.api.animation.AnimationIterator;
import kr.toxicity.model.api.animation.AnimationModifier;
import kr.toxicity.model.api.animation.RunningAnimation;
import kr.toxicity.model.api.bone.BoneName;
import kr.toxicity.model.api.bone.RenderedBone;
import kr.toxicity.model.api.config.DebugConfig;
import kr.toxicity.model.api.data.blueprint.BlueprintAnimation;
import kr.toxicity.model.api.data.renderer.ModelRenderer;
import kr.toxicity.model.api.data.renderer.RenderPipeline;
import kr.toxicity.model.api.event.CloseTrackerEvent;
import kr.toxicity.model.api.event.ModelDespawnAtPlayerEvent;
import kr.toxicity.model.api.event.ModelSpawnAtPlayerEvent;
import kr.toxicity.model.api.event.PlayerHideTrackerEvent;
import kr.toxicity.model.api.event.PlayerShowTrackerEvent;
import kr.toxicity.model.api.nms.ModelDisplay;
import kr.toxicity.model.api.nms.PacketBundler;
import kr.toxicity.model.api.tracker.ModelRotation;
import kr.toxicity.model.api.tracker.ModelRotator;
import kr.toxicity.model.api.tracker.ModelScaler;
import kr.toxicity.model.api.tracker.TrackerData;
import kr.toxicity.model.api.tracker.TrackerModifier;
import kr.toxicity.model.api.util.EntityUtil;
import kr.toxicity.model.api.util.EventUtil;
import kr.toxicity.model.api.util.LogUtil;
import kr.toxicity.model.api.util.MathUtil;
import kr.toxicity.model.api.util.TransformedItemStack;
import kr.toxicity.model.api.util.function.BonePredicate;
import lombok.Generated;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public abstract class Tracker
implements AutoCloseable {
    private static final ScheduledExecutorService EXECUTOR = Executors.newScheduledThreadPool(256, new ThreadFactory(){
        private final AtomicInteger integer = new AtomicInteger();

        @Override
        public Thread newThread(@NotNull Runnable r) {
            Thread thread2 = new Thread(r);
            thread2.setDaemon(true);
            thread2.setName("BetterModel-Worker-" + this.integer.getAndIncrement());
            thread2.setUncaughtExceptionHandler((t, e) -> LogUtil.handleException("Exception has occurred in " + t.getName(), e));
            return thread2;
        }
    });
    public static final int TRACKER_TICK_INTERVAL = 10;
    public static final int MINECRAFT_TICK_MULTIPLIER = MathUtil.MINECRAFT_TICK_MILLS / 10;
    protected final RenderPipeline pipeline;
    private volatile ScheduledFuture<?> task;
    private long frame = 0L;
    private final Queue<Runnable> queuedTask = new ConcurrentLinkedQueue<Runnable>();
    private final AtomicBoolean isClosed = new AtomicBoolean();
    private final AtomicBoolean readyForForceUpdate = new AtomicBoolean();
    private final AtomicBoolean forRemoval = new AtomicBoolean();
    private final AtomicBoolean rotationLock = new AtomicBoolean();
    private final TrackerModifier modifier;
    private final Runnable updater;
    private final BundlerSet bundlerSet;
    private ModelRotator rotator = ModelRotator.YAW;
    private ModelScaler scaler = ModelScaler.entity();
    private Supplier<ModelRotation> rotationSupplier = () -> ModelRotation.EMPTY;
    private BiConsumer<Tracker, CloseReason> closeEventHandler = (t, r) -> EventUtil.call(new CloseTrackerEvent((Tracker)t, (CloseReason)((Object)r)));
    private ScheduledPacketHandler handler = (t, s) -> t.pipeline.tick(s.viewBundler);

    public Tracker(@NotNull RenderPipeline pipeline, @NotNull TrackerModifier modifier) {
        this.pipeline = pipeline;
        this.modifier = modifier;
        this.bundlerSet = new BundlerSet();
        BetterModelConfig config = BetterModel.config();
        this.updater = () -> {
            boolean isMinecraftTickTime;
            boolean bl = isMinecraftTickTime = this.frame % (long)MINECRAFT_TICK_MULTIPLIER == 0L;
            if (isMinecraftTickTime) {
                Runnable task;
                while ((task = this.queuedTask.poll()) != null) {
                    task.run();
                }
            }
            this.handler.handle(this, this.bundlerSet);
            this.bundlerSet.send();
        };
        if (modifier.sightTrace()) {
            pipeline.viewFilter(p -> EntityUtil.canSee(p.getEyeLocation(), this.location()));
        }
        this.frame((t, s) -> {
            if (this.readyForForceUpdate.compareAndSet(true, false)) {
                t.pipeline.forceUpdate(s.dataBundler);
            }
        });
        this.tick((t, s) -> pipeline.rotate(t.isRunningSingleAnimation() && config.lockOnPlayAnimation() ? t.pipeline.getRotation() : t.rotation(), s.tickBundler));
        this.frame((t, s) -> t.pipeline.getScriptProcessor().tick());
        pipeline.spawnPacketHandler(p -> this.start());
    }

    public boolean isScheduled() {
        return this.task != null && !this.task.isCancelled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void start() {
        if (this.isScheduled()) {
            return;
        }
        Tracker tracker = this;
        synchronized (tracker) {
            if (this.isScheduled()) {
                return;
            }
            this.task = EXECUTOR.scheduleAtFixedRate(() -> {
                if (this.playerCount() == 0 && !this.forRemoval.get()) {
                    this.shutdown();
                    return;
                }
                this.updater.run();
                ++this.frame;
            }, 10L, 10L, TimeUnit.MILLISECONDS);
            LogUtil.debug(DebugConfig.DebugOption.TRACKER, () -> this.getClass().getSimpleName() + " scheduler started: " + this.name());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shutdown() {
        if (!this.isScheduled()) {
            return;
        }
        Tracker tracker = this;
        synchronized (tracker) {
            if (!this.isScheduled()) {
                return;
            }
            this.task.cancel(true);
            this.task = null;
            this.frame = 0L;
            LogUtil.debug(DebugConfig.DebugOption.TRACKER, () -> this.getClass().getSimpleName() + " scheduler shutdown: " + this.name());
        }
    }

    @NotNull
    public ModelRotation rotation() {
        return this.rotationLock.get() ? this.pipeline.getRotation() : this.rotator.apply(this, this.rotationSupplier.get());
    }

    public boolean lockRotation(boolean lock) {
        return this.rotationLock.compareAndSet(!lock, lock);
    }

    public final void rotation(@NotNull Supplier<ModelRotation> supplier) {
        this.rotationSupplier = Objects.requireNonNull(supplier);
    }

    public final void rotator(@NotNull ModelRotator rotator) {
        this.rotator = Objects.requireNonNull(rotator);
    }

    @NotNull
    public ModelScaler scaler() {
        return this.scaler;
    }

    public void scaler(@NotNull ModelScaler scaler) {
        this.scaler = Objects.requireNonNull(scaler);
    }

    @NotNull
    public TrackerData asTrackerData() {
        return new TrackerData(this.name(), this.scaler, this.rotator, this.modifier);
    }

    public void task(@NotNull Runnable runnable) {
        this.queuedTask.add(Objects.requireNonNull(runnable));
    }

    public void frame(@NotNull ScheduledPacketHandler handler) {
        this.handler = this.handler.then(Objects.requireNonNull(handler));
    }

    public void tick(@NotNull ScheduledPacketHandler handler) {
        this.tick(1L, handler);
    }

    public void tick(long tick, @NotNull ScheduledPacketHandler handler) {
        this.schedule((long)MINECRAFT_TICK_MULTIPLIER * tick, handler);
    }

    public void schedule(long period, @NotNull ScheduledPacketHandler handler) {
        Objects.requireNonNull(handler);
        if (period <= 0L) {
            throw new RuntimeException("period cannot be <= 0");
        }
        this.frame((t, s) -> {
            if (this.frame % period == 0L) {
                handler.handle(t, s);
            }
        });
    }

    protected void update() {
        this.updater.run();
    }

    @NotNull
    public String name() {
        return this.pipeline.name();
    }

    public double height() {
        return this.pipeline.height();
    }

    public boolean isClosed() {
        return this.isClosed.get();
    }

    @Override
    public void close() {
        this.close(CloseReason.REMOVE);
    }

    protected void close(@NotNull CloseReason reason) {
        if (this.isClosed.compareAndSet(false, true)) {
            this.closeEventHandler.accept(this, reason);
            this.shutdown();
            this.pipeline.despawn();
            LogUtil.debug(DebugConfig.DebugOption.TRACKER, () -> this.getClass().getSimpleName() + " closed: " + this.name());
        }
    }

    public void despawn() {
        if (!this.isClosed()) {
            this.pipeline.despawn();
            LogUtil.debug(DebugConfig.DebugOption.TRACKER, () -> this.getClass().getSimpleName() + " despawned: " + this.name());
        }
    }

    @NotNull
    public TrackerModifier modifier() {
        return this.modifier;
    }

    public boolean forceUpdate(boolean force) {
        return this.readyForForceUpdate.compareAndSet(!force, force);
    }

    public boolean isRunningSingleAnimation() {
        RunningAnimation runningAnimation = this.pipeline.runningAnimation();
        return runningAnimation != null && runningAnimation.type() == AnimationIterator.Type.PLAY_ONCE;
    }

    protected boolean spawn(@NotNull Player player, @NotNull PacketBundler bundler) {
        if (this.isClosed()) {
            return false;
        }
        if (!EventUtil.call(new ModelSpawnAtPlayerEvent(player, this))) {
            return false;
        }
        boolean result = this.pipeline.spawn(player, bundler);
        if (result) {
            LogUtil.debug(DebugConfig.DebugOption.TRACKER, () -> this.getClass().getSimpleName() + " is spawned at player " + player.getName() + ": " + this.name());
        }
        return result;
    }

    public boolean remove(@NotNull Player player) {
        if (this.isClosed()) {
            return false;
        }
        EventUtil.call(new ModelDespawnAtPlayerEvent(player, this));
        boolean result = this.pipeline.remove(player);
        if (result) {
            LogUtil.debug(DebugConfig.DebugOption.TRACKER, () -> this.getClass().getSimpleName() + " is despawned at player " + player.getName() + ": " + this.name());
        }
        return result;
    }

    public int playerCount() {
        return this.pipeline.playerCount();
    }

    @NotNull
    public Stream<Player> viewedPlayer() {
        return this.pipeline.viewedPlayer();
    }

    public void tint(int rgb) {
        this.tint(BonePredicate.TRUE, rgb);
    }

    public void tint(@NotNull BonePredicate predicate, int rgb) {
        if (this.pipeline.tint(predicate, rgb)) {
            this.forceUpdate(true);
        }
    }

    @NotNull
    public abstract Location location();

    public boolean animate(@NotNull String animation) {
        return this.animate(animation, AnimationModifier.DEFAULT);
    }

    public boolean animate(@NotNull String animation, AnimationModifier modifier) {
        return this.animate(animation, modifier, () -> {});
    }

    public boolean animate(@NotNull String animation, AnimationModifier modifier, Runnable removeTask) {
        return this.animate((RenderedBone e) -> true, animation, modifier, removeTask);
    }

    public boolean animate(@NotNull Predicate<RenderedBone> filter, @NotNull String animation, @NotNull AnimationModifier modifier, @NotNull Runnable removeTask) {
        return this.pipeline.animate(filter, animation, modifier, removeTask);
    }

    public void animate(@NotNull Predicate<RenderedBone> filter, @NotNull BlueprintAnimation animation, @NotNull AnimationModifier modifier, @NotNull Runnable removeTask) {
        this.pipeline.animate(filter, animation, modifier, removeTask);
    }

    public void stopAnimation(@NotNull String animation) {
        this.stopAnimation(e -> true, animation);
    }

    public void stopAnimation(@NotNull Predicate<RenderedBone> filter, @NotNull String animation) {
        this.pipeline.stopAnimation(filter, animation);
    }

    public boolean replace(@NotNull String target, @NotNull String animation, @NotNull AnimationModifier modifier) {
        return this.replace((RenderedBone t) -> true, target, animation, modifier);
    }

    public boolean replace(@NotNull Predicate<RenderedBone> filter, @NotNull String target, @NotNull String animation, @NotNull AnimationModifier modifier) {
        return this.pipeline.replace(filter, target, animation, modifier);
    }

    public void replace(@NotNull Predicate<RenderedBone> filter, @NotNull String target, @NotNull BlueprintAnimation animation, @NotNull AnimationModifier modifier) {
        this.pipeline.replace(filter, target, animation, modifier);
    }

    public boolean togglePart(@NotNull BonePredicate predicate, boolean toggle) {
        return this.pipeline.togglePart(predicate, toggle);
    }

    public boolean itemStack(@NotNull BonePredicate predicate, @NotNull TransformedItemStack itemStack) {
        return this.pipeline.itemStack(predicate, itemStack);
    }

    public boolean glow(@NotNull BonePredicate predicate, boolean glow, int glowColor) {
        return this.pipeline.glow(predicate, glow, glowColor);
    }

    public boolean enchant(@NotNull BonePredicate predicate, boolean enchant) {
        return this.pipeline.enchant(predicate, enchant);
    }

    public boolean brightness(@NotNull BonePredicate predicate, int block, int sky) {
        return this.pipeline.brightness(predicate, block, sky);
    }

    public boolean updateItem(@NotNull BonePredicate predicate) {
        return this.pipeline.updateItem(predicate);
    }

    @Nullable
    public RenderedBone bone(@NotNull BoneName name) {
        return this.bone((RenderedBone b2) -> b2.getName().equals(name));
    }

    @Nullable
    public RenderedBone bone(@NotNull String name) {
        return this.bone((RenderedBone b2) -> b2.getName().name().equals(name));
    }

    @Nullable
    public RenderedBone bone(@NotNull Predicate<RenderedBone> predicate) {
        return this.pipeline.boneOf(predicate);
    }

    @NotNull
    public @Unmodifiable List<RenderedBone> bones() {
        return this.pipeline.bones();
    }

    @NotNull
    public Stream<ModelDisplay> displays() {
        return this.bones().stream().map(RenderedBone::getDisplay).filter(Objects::nonNull);
    }

    public boolean hide(@NotNull Player player) {
        return EventUtil.call(new PlayerHideTrackerEvent(this, player)) && this.pipeline.hide(player);
    }

    public boolean isHide(@NotNull Player player) {
        return this.pipeline.isHide(player);
    }

    public boolean show(@NotNull Player player) {
        return EventUtil.call(new PlayerShowTrackerEvent(this, player)) && this.pipeline.show(player);
    }

    public void handleCloseEvent(@NotNull BiConsumer<Tracker, CloseReason> consumer) {
        this.closeEventHandler = this.closeEventHandler.andThen(Objects.requireNonNull(consumer));
    }

    @NotNull
    public ModelRenderer renderer() {
        return this.pipeline.getParent();
    }

    @ApiStatus.Internal
    public void forRemoval(boolean removal) {
        this.forRemoval.set(removal);
    }

    @ApiStatus.Internal
    public boolean forRemoval() {
        return this.forRemoval.get();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Tracker)) {
            return false;
        }
        Tracker tracker = (Tracker)o;
        return this.name().equals(tracker.name());
    }

    public int hashCode() {
        return this.name().hashCode();
    }

    @Generated
    public RenderPipeline getPipeline() {
        return this.pipeline;
    }

    @FunctionalInterface
    public static interface ScheduledPacketHandler {
        public void handle(@NotNull Tracker var1, @NotNull BundlerSet var2);

        @NotNull
        default public ScheduledPacketHandler then(@NotNull ScheduledPacketHandler other) {
            return (t, s) -> {
                this.handle(t, s);
                other.handle(t, s);
            };
        }
    }

    public class BundlerSet {
        private PacketBundler tickBundler;
        private PacketBundler viewBundler;
        private PacketBundler dataBundler;

        private BundlerSet() {
            this.tickBundler = Tracker.this.pipeline.createBundler();
            this.viewBundler = Tracker.this.pipeline.createBundler();
            this.dataBundler = Tracker.this.pipeline.createBundler();
        }

        private void send() {
            if (!this.tickBundler.isEmpty()) {
                Tracker.this.pipeline.allPlayer().forEach(this.tickBundler::send);
                this.tickBundler = Tracker.this.pipeline.createBundler();
            }
            if (!this.dataBundler.isEmpty()) {
                Tracker.this.pipeline.nonHidePlayer().forEach(this.dataBundler::send);
                this.dataBundler = Tracker.this.pipeline.createBundler();
            }
            if (!this.viewBundler.isEmpty()) {
                Tracker.this.pipeline.viewedPlayer().forEach(this.viewBundler::send);
                this.viewBundler = Tracker.this.pipeline.createBundler();
            }
        }

        @Generated
        public PacketBundler getTickBundler() {
            return this.tickBundler;
        }

        @Generated
        public PacketBundler getViewBundler() {
            return this.viewBundler;
        }

        @Generated
        public PacketBundler getDataBundler() {
            return this.dataBundler;
        }
    }

    public static enum CloseReason {
        REMOVE(false),
        DESPAWN(true);

        private final boolean save;

        public boolean shouldBeSave() {
            return this.save;
        }

        @Generated
        private CloseReason(boolean save) {
            this.save = save;
        }
    }
}

