/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.data.raw;

import com.google.gson.JsonDeserializer;
import com.google.gson.JsonPrimitive;
import com.google.gson.annotations.SerializedName;
import kr.toxicity.model.api.data.raw.Float3;
import kr.toxicity.model.api.data.raw.ModelFace;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public sealed interface ModelElement {
    public static final JsonDeserializer<ModelElement> PARSER = (json, type, context) -> {
        String select;
        JsonPrimitive t = json.getAsJsonObject().getAsJsonPrimitive("type");
        return switch (select = t != null ? t.getAsString() : "cube") {
            case "null_object" -> (ModelElement)context.deserialize(json, NullObject.class);
            case "locator" -> (ModelElement)context.deserialize(json, Locator.class);
            case "cube" -> (ModelElement)context.deserialize(json, Cube.class);
            default -> new Unsupported(select);
        };
    };

    @NotNull
    public String name();

    @NotNull
    public String uuid();

    @NotNull
    public String type();

    default public boolean isSupported() {
        return true;
    }

    public record NullObject(@NotNull String name, @NotNull String uuid, @SerializedName(value="ik_target") @Nullable String ikTarget, @SerializedName(value="ik_source") @Nullable String ikSource, @Nullable Float3 position) implements ModelElement
    {
        @Nullable
        private final Float3 position;

        @Override
        @NotNull
        public String type() {
            return "null_object";
        }

        @NotNull
        public Float3 position() {
            return this.position != null ? this.position : Float3.ZERO;
        }
    }

    public record Locator(@NotNull String name, @NotNull String uuid, @Nullable Float3 position) implements ModelElement
    {
        @Nullable
        private final Float3 position;

        @Override
        @NotNull
        public String type() {
            return "locator";
        }

        @NotNull
        public Float3 position() {
            return this.position != null ? this.position : Float3.ZERO;
        }
    }

    public record Cube(@NotNull String name, @NotNull String uuid, @Nullable Float3 from, @Nullable Float3 to, float inflate, @Nullable Float3 rotation, @NotNull Float3 origin, @Nullable ModelFace faces, @SerializedName(value="visibility") @Nullable Boolean _visibility) implements ModelElement
    {
        @Nullable
        private final Float3 from;
        @Nullable
        private final Float3 to;
        @Nullable
        private final Float3 rotation;

        @Override
        @NotNull
        public String type() {
            return "cube";
        }

        @NotNull
        public Float3 from() {
            return this.from != null ? this.from : Float3.ZERO;
        }

        @NotNull
        public Float3 to() {
            return this.to != null ? this.to : Float3.ZERO;
        }

        public boolean visibility() {
            return !Boolean.FALSE.equals(this._visibility);
        }

        @NotNull
        public Float3 rotation() {
            return this.rotation != null ? this.rotation : Float3.ZERO;
        }
    }

    public record Unsupported(@NotNull String type) implements ModelElement
    {
        @Override
        @NotNull
        public String name() {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public String uuid() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isSupported() {
            return false;
        }
    }
}

