/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.animation;

import kr.toxicity.model.api.animation.Timed;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public record AnimationMovement(float time, @Nullable Vector3f transform, @Nullable Vector3f scale, @Nullable Vector3f rotation) implements Timed
{
    public static final AnimationMovement EMPTY = new AnimationMovement(0.0f);

    public AnimationMovement(float time) {
        this(time, null, null, null);
    }

    @NotNull
    public AnimationMovement time(float newTime) {
        return new AnimationMovement(newTime, this.transform, this.scale, this.rotation);
    }

    @NotNull
    public AnimationMovement plus(@NotNull AnimationMovement other) {
        return new AnimationMovement(this.time + other.time, this.plus(this.transform, other.transform), this.plus(this.scale, other.scale), this.plus(this.rotation, other.rotation));
    }

    @NotNull
    public AnimationMovement minus(@NotNull AnimationMovement other) {
        return new AnimationMovement(this.time - other.time(), this.minus(this.transform, other.transform), this.minus(this.scale, other.scale), this.minus(this.rotation, other.rotation));
    }

    @Nullable
    private Vector3f plus(@Nullable Vector3f one, @Nullable Vector3f two) {
        if (one != null && two != null) {
            return new Vector3f((Vector3fc)one).add((Vector3fc)two);
        }
        if (one != null) {
            return one;
        }
        return two;
    }

    @Nullable
    private Vector3f minus(@Nullable Vector3f one, @Nullable Vector3f two) {
        if (one != null && two != null) {
            return new Vector3f((Vector3fc)one).sub((Vector3fc)two);
        }
        if (one != null) {
            return one;
        }
        return two;
    }
}

