/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.nms;

import java.util.Optional;
import kr.toxicity.model.api.BetterModel;
import kr.toxicity.model.api.tracker.EntityTrackerRegistry;
import org.bukkit.entity.Entity;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;

public interface EntityAdapter {
    @NotNull
    public Entity entity();

    @NotNull
    public Object handle();

    public int id();

    public boolean dead();

    public boolean ground();

    public boolean invisible();

    public boolean glow();

    public boolean onWalk();

    public boolean fly();

    public double scale();

    public float pitch();

    public float bodyYaw();

    public float headYaw();

    public float damageTick();

    public float walkSpeed();

    @NotNull
    public Vector3f passengerPosition();

    @NotNull
    default public Optional<EntityTrackerRegistry> registry() {
        return BetterModel.registry(this.entity().getUniqueId());
    }

    default public boolean hasControllingPassenger() {
        EntityTrackerRegistry registry = this.registry().orElse(null);
        return registry != null && registry.hasControllingPassenger();
    }
}

