/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.annotations.SerializedName;
import com.vdurmont.semver4j.Semver;
import java.lang.runtime.SwitchBootstraps;
import java.net.http.HttpClient;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executors;
import java.util.function.Function;
import kr.toxicity.model.api.BetterModel;
import kr.toxicity.model.api.util.LogUtil;
import kr.toxicity.model.api.version.MinecraftVersion;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class HttpUtil {
    private static final HttpClient CLIENT = HttpClient.newBuilder().connectTimeout(Duration.of(5L, ChronoUnit.SECONDS)).executor(Executors.newVirtualThreadPerTaskExecutor()).build();
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(MinecraftVersion.class, (json, typeOfT, context) -> new MinecraftVersion(json.getAsString())).registerTypeAdapter(Semver.class, (json, typeOfT, context) -> new Semver(json.getAsString(), Semver.SemverType.LOOSE)).create();

    private HttpUtil() {
        throw new RuntimeException();
    }

    @NotNull
    public static LatestVersion versionList() {
        return HttpUtil.versionList(BetterModel.plugin().version());
    }

    @NotNull
    public static LatestVersion versionList(@NotNull MinecraftVersion version) {
        return HttpUtil.client(client -> {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }).orElse(e -> {
            LogUtil.handleException("Unable to get BetterModel's version info.", e);
            return new LatestVersion(null, null);
        });
    }

    @NotNull
    public static LatestVersion latestOf(@NotNull List<PluginVersion> versions) {
        PluginVersion release = null;
        PluginVersion snapshot = null;
        for (PluginVersion version : versions) {
            if (version.versionType.equals("release")) {
                if (release != null) continue;
                release = version;
                continue;
            }
            if (snapshot != null) continue;
            snapshot = version;
        }
        return new LatestVersion(release, snapshot);
    }

    @NotNull
    public static <T> Result<T> client(@NotNull HttpClientConsumer<T> consumer) {
        try {
            return new Result.Success<T>(consumer.accept(CLIENT));
        }
        catch (Exception e) {
            return new Result.Failure(e);
        }
    }

    private static /* synthetic */ Semver lambda$versionList$4(PluginVersion v) {
        return v.versionNumber;
    }

    private static /* synthetic */ boolean lambda$versionList$3(MinecraftVersion version, PluginVersion v) {
        return v.versions.contains(version);
    }

    private static /* synthetic */ PluginVersion lambda$versionList$2(JsonElement e) {
        return (PluginVersion)GSON.fromJson(e, PluginVersion.class);
    }

    public record LatestVersion(@Nullable PluginVersion release, @Nullable PluginVersion snapshot) {
    }

    @FunctionalInterface
    public static interface HttpClientConsumer<T> {
        @NotNull
        public T accept(@NotNull HttpClient var1) throws Exception;
    }

    public static sealed interface Result<T> {
        @NotNull
        default public T orElse(@NotNull Function<Exception, T> function) {
            Result result = this;
            Objects.requireNonNull(result);
            Result result2 = result;
            int n = 0;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Failure.class, Success.class}, (Object)result2, n)) {
                default -> throw new MatchException(null, null);
                case 0 -> {
                    Failure failure = (Failure)result2;
                    yield function.apply(failure.exception);
                }
                case 1 -> {
                    Success success = (Success)result2;
                    yield success.result;
                }
            };
        }

        public record Failure<T>(@NotNull Exception exception) implements Result<T>
        {
        }

        public record Success<T>(@NotNull T result) implements Result<T>
        {
        }
    }

    public record PluginVersion(@SerializedName(value="version_number") @NotNull Semver versionNumber, @SerializedName(value="version_type") @NotNull String versionType, @SerializedName(value="game_versions") @NotNull List<MinecraftVersion> versions) {
        @NotNull
        public Component toURLComponent() {
            String url = "https://modrinth.com/plugin/bettermodel/version/" + this.versionNumber.getOriginalValue();
            return ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().content(this.versionNumber.getOriginalValue()).color((TextColor)NamedTextColor.AQUA)).hoverEvent((HoverEventSource)HoverEvent.showText((ComponentLike)((TextComponent.Builder)((TextComponent.Builder)Component.text().append(Component.text((String)url).color((TextColor)NamedTextColor.DARK_AQUA))).appendNewline()).append((Component)Component.text((String)"Click to download link."))))).clickEvent(ClickEvent.openUrl((String)url))).build();
        }
    }
}

