/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.util.interpolator;

import java.util.List;
import kr.toxicity.model.api.animation.VectorPoint;
import kr.toxicity.model.api.util.InterpolationUtil;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;

@ApiStatus.Internal
public enum VectorInterpolator {
    LINEAR{

        @Override
        @NotNull
        public Vector3f interpolate(@NotNull List<VectorPoint> points, int p2Index, float time) {
            VectorPoint p1 = p2Index > 0 ? points.get(p2Index - 1) : points.getFirst();
            VectorPoint p2 = points.get(p2Index);
            float t1 = p1.time();
            float t2 = p2.time();
            float a = InterpolationUtil.alpha(t1, t2, time);
            return InterpolationUtil.lerp(p1.vector(InterpolationUtil.lerp(t1, t2, a)), p2.vector(), a);
        }
    }
    ,
    CATMULLROM{

        @NotNull
        private static VectorPoint indexOf(@NotNull List<VectorPoint> list, int index, int relative) {
            int i2;
            for (i2 = index + relative; i2 < 0; i2 += list.size()) {
            }
            return list.get(i2 % list.size());
        }

        @Override
        @NotNull
        public Vector3f interpolate(@NotNull List<VectorPoint> points, int p2Index, float time) {
            VectorPoint p0 = 2.indexOf(points, p2Index, -2);
            VectorPoint p1 = 2.indexOf(points, p2Index, -1);
            VectorPoint p2 = points.get(p2Index);
            VectorPoint p3 = 2.indexOf(points, p2Index, 1);
            float t1 = p1.time();
            float t2 = p2.time();
            float a = InterpolationUtil.alpha(t1, t2, time);
            return InterpolationUtil.catmull_rom(p0.vector(), p1.vector(InterpolationUtil.lerp(t1, t2, a)), p2.vector(), p3.vector(), a);
        }
    }
    ,
    BEZIER{

        @Override
        @NotNull
        public Vector3f interpolate(@NotNull List<VectorPoint> points, int p2Index, float time) {
            VectorPoint p1 = p2Index > 0 ? points.get(p2Index - 1) : points.getFirst();
            VectorPoint p2 = points.get(p2Index);
            float t1 = p1.time();
            float t2 = p2.time();
            float a = InterpolationUtil.alpha(t1, t2, time);
            return InterpolationUtil.bezier(a, p1.vector(InterpolationUtil.lerp(t1, t2, a)), p2.vector(), p1.bezier().rightTime(), p1.bezier().rightValue(), p2.bezier().leftTime(), p2.bezier().leftValue());
        }
    }
    ,
    STEP{

        @Override
        @NotNull
        public Vector3f interpolate(@NotNull List<VectorPoint> points, int p2Index, float time) {
            return (p2Index > 0 ? points.get(p2Index - 1) : points.getFirst()).vector(time);
        }

        @Override
        public boolean isContinuous() {
            return false;
        }
    };


    public abstract Vector3f interpolate(@NotNull List<VectorPoint> var1, int var2, float var3);

    public boolean isContinuous() {
        return true;
    }
}

