/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.animation;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import java.util.Iterator;
import java.util.List;
import kr.toxicity.model.api.animation.Timed;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;

public interface AnimationIterator<T extends Timed>
extends Iterator<T> {
    public void clear();

    public int index();

    public int lastIndex();

    @NotNull
    public Type type();

    public static final class Loop<T extends Timed>
    implements AnimationIterator<T> {
        private final List<T> keyFrame;
        private int index = 0;

        @Override
        public int index() {
            return this.index;
        }

        @Override
        public int lastIndex() {
            return this.keyFrame.size() - 1;
        }

        @Override
        public void clear() {
            this.index = 0;
        }

        @Override
        public boolean hasNext() {
            return true;
        }

        @Override
        @NotNull
        public T next() {
            if (this.index >= this.keyFrame.size()) {
                this.index = 0;
            }
            return (T)((Timed)this.keyFrame.get(this.index++));
        }

        @Override
        @NotNull
        public Type type() {
            return Type.LOOP;
        }

        @Generated
        private Loop(List<T> keyFrame) {
            this.keyFrame = keyFrame;
        }
    }

    public static final class HoldOnLast<T extends Timed>
    implements AnimationIterator<T> {
        private final List<T> keyFrame;
        private int index = 0;
        private boolean finished = false;

        @Override
        public int index() {
            return this.index;
        }

        @Override
        public int lastIndex() {
            return this.keyFrame.size() - 1;
        }

        @Override
        public void clear() {
            this.index = 0;
            this.finished = false;
        }

        @Override
        public boolean hasNext() {
            return true;
        }

        @Override
        @NotNull
        public T next() {
            if (this.finished) {
                return (T)((Timed)this.keyFrame.getLast());
            }
            Timed nextFrame = (Timed)this.keyFrame.get(this.index++);
            if (this.index >= this.keyFrame.size()) {
                this.finished = true;
            }
            return (T)nextFrame;
        }

        @Override
        @NotNull
        public Type type() {
            return Type.HOLD_ON_LAST;
        }

        @Generated
        private HoldOnLast(List<T> keyFrame) {
            this.keyFrame = keyFrame;
        }
    }

    public static final class PlayOnce<T extends Timed>
    implements AnimationIterator<T> {
        private final List<T> keyFrame;
        private int index = 0;

        @Override
        public int index() {
            return this.index;
        }

        @Override
        public int lastIndex() {
            return this.keyFrame.size() - 1;
        }

        @Override
        public void clear() {
            this.index = Integer.MAX_VALUE;
        }

        @Override
        public boolean hasNext() {
            return this.index < this.keyFrame.size();
        }

        @Override
        @NotNull
        public T next() {
            return (T)((Timed)this.keyFrame.get(this.index++));
        }

        @Override
        @NotNull
        public Type type() {
            return Type.PLAY_ONCE;
        }

        @Generated
        private PlayOnce(List<T> keyFrame) {
            this.keyFrame = keyFrame;
        }
    }

    public static enum Type {
        PLAY_ONCE{

            @Override
            @NotNull
            public <T extends Timed> AnimationIterator<T> create(@NotNull List<T> keyFrames) {
                return new PlayOnce<T>(keyFrames);
            }
        }
        ,
        LOOP{

            @Override
            @NotNull
            public <T extends Timed> AnimationIterator<T> create(@NotNull List<T> keyFrames) {
                return new Loop<T>(keyFrames);
            }
        }
        ,
        HOLD_ON_LAST{

            @Override
            @NotNull
            public <T extends Timed> AnimationIterator<T> create(@NotNull List<T> keyFrames) {
                return new HoldOnLast<T>(keyFrames);
            }
        };

        public static final JsonDeserializer<Type> DESERIALIZER;

        @NotNull
        public abstract <T extends Timed> AnimationIterator<T> create(@NotNull List<T> var1);

        @Generated
        private Type() {
        }

        static {
            DESERIALIZER = new JsonDeserializer<Type>(){

                public Type deserialize(JsonElement json, java.lang.reflect.Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                    if (json.isJsonPrimitive()) {
                        return switch (json.getAsString()) {
                            case "loop" -> LOOP;
                            case "hold" -> HOLD_ON_LAST;
                            default -> PLAY_ONCE;
                        };
                    }
                    return PLAY_ONCE;
                }
            };
        }
    }
}

