/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.shaded.kr.toxicity.library.dynamicuv;

import org.jetbrains.annotations.NotNull;

public class UVNamespace {
    private final String namespace;
    private final String directory;
    private final String textures;
    private final String models;
    private final String items;

    public UVNamespace(@NotNull String namespace, @NotNull String directory) {
        this.namespace = namespace;
        this.directory = directory;
        Object dirString = directory.isEmpty() ? "" : "/" + directory;
        this.textures = "assets/" + namespace + "/textures/item" + (String)dirString;
        this.models = "assets/" + namespace + "/models" + (String)dirString;
        this.items = "assets/" + namespace + "/items" + (String)dirString;
    }

    @NotNull
    public String asset(@NotNull String assetName) {
        return this.namespace + ":" + this.directory + (this.directory.isEmpty() ? "" : "/") + assetName;
    }

    @NotNull
    public String textureAssets(@NotNull String assetName) {
        return this.namespace + ":item/" + this.directory + (this.directory.isEmpty() ? "" : "/") + assetName;
    }

    @NotNull
    public String item(@NotNull String assetName) {
        return this.items + "/" + assetName + ".json";
    }

    @NotNull
    public String model(@NotNull String assetName) {
        return this.models + "/" + assetName + ".json";
    }

    @NotNull
    public String texture(@NotNull String assetName) {
        return this.textures + "/" + assetName + ".png";
    }
}

