/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.bone;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import kr.toxicity.model.api.bone.BoneName;
import kr.toxicity.model.api.bone.BoneTag;
import org.jetbrains.annotations.NotNull;

public final class BoneTagRegistry {
    private static final Map<String, BoneTag> BY_NAME = new HashMap<String, BoneTag>();

    private BoneTagRegistry() {
        throw new RuntimeException();
    }

    public static void addTag(@NotNull BoneTag tag) {
        for (String s : tag.tags()) {
            BoneTag checkDuplicate = BY_NAME.put(s, tag);
            if (checkDuplicate == null) continue;
            throw new RuntimeException("Duplicated tags: " + tag.name() + " between " + checkDuplicate.name());
        }
    }

    @NotNull
    public static Optional<BoneTag> byTagName(@NotNull String tag) {
        return Optional.ofNullable(BY_NAME.get(tag));
    }

    @NotNull
    public static BoneName parse(@NotNull String rawName) {
        List<String> tagArray = List.of((rawName = rawName.toLowerCase(Locale.ROOT)).split("_"));
        if (tagArray.size() < 2) {
            return new BoneName(Collections.emptySet(), rawName, rawName);
        }
        HashSet<BoneTag> set = new HashSet<BoneTag>();
        for (String s : tagArray) {
            BoneTag tag = BoneTagRegistry.byTagName(s).orElse(null);
            if (tag != null && set.size() < tagArray.size()) {
                set.add(tag);
                continue;
            }
            return new BoneName(Collections.unmodifiableSet(set), String.join((CharSequence)"_", tagArray.subList(set.size(), tagArray.size())), rawName);
        }
        return new BoneName(Collections.unmodifiableSet(set), String.join((CharSequence)"_", tagArray.subList(set.size(), tagArray.size())), rawName);
    }
}

