/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.animation;

import java.util.Objects;
import java.util.function.BooleanSupplier;
import kr.toxicity.model.api.animation.AnimationIterator;
import kr.toxicity.model.api.util.MathUtil;
import kr.toxicity.model.api.util.function.FloatConstantSupplier;
import kr.toxicity.model.api.util.function.FloatSupplier;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record AnimationModifier(@Nullable BooleanSupplier predicate, int start, int end, @Nullable AnimationIterator.Type type, @Nullable FloatSupplier speed, @Nullable Boolean override, @Nullable Player player) {
    @NotNull
    public static final AnimationModifier DEFAULT = AnimationModifier.builder().build();
    public static final AnimationModifier DEFAULT_WITH_PLAY_ONCE = AnimationModifier.builder().type(AnimationIterator.Type.PLAY_ONCE).build();

    public AnimationModifier(int start2, int end) {
        this(start2, end, null, null);
    }

    public AnimationModifier(int start2, int end, float speedValue) {
        this(start2, end, null, FloatConstantSupplier.of(speedValue));
    }

    public AnimationModifier(int start2, int end, @Nullable FloatSupplier supplier) {
        this(start2, end, null, supplier);
    }

    public AnimationModifier(int start2, int end, @Nullable AnimationIterator.Type type) {
        this(start2, end, type, null);
    }

    public AnimationModifier(int start2, int end, @Nullable AnimationIterator.Type type, @Nullable FloatSupplier speed) {
        this(null, start2, end, type, speed);
    }

    public AnimationModifier(@Nullable BooleanSupplier predicate, int start2, int end, @Nullable AnimationIterator.Type type, @Nullable FloatSupplier speed) {
        this(predicate, start2, end, type, speed, null, null);
    }

    @NotNull
    public static Builder builder() {
        return new Builder();
    }

    @NotNull
    public Builder toBuilder() {
        return AnimationModifier.builder().predicate(this.predicate).start(this.start).end(this.end).type(this.type).speed(this.speed).override(this.override).player(this.player);
    }

    @NotNull
    public AnimationIterator.Type type(@NotNull AnimationIterator.Type defaultType) {
        return this.type != null ? this.type : defaultType;
    }

    public float speedValue() {
        return this.speed != null ? this.speed.getAsFloat() : 1.0f;
    }

    public boolean predicateValue() {
        return this.predicate == null || this.predicate.getAsBoolean();
    }

    public boolean override(boolean original) {
        return this.override != null ? this.override : original;
    }

    @Nullable
    private static FloatConstantSupplier toSupplier(float speed) {
        return MathUtil.isSimilar(speed, 1.0f) ? null : FloatConstantSupplier.of(speed);
    }

    public static final class Builder {
        private BooleanSupplier predicate = null;
        private int start = 1;
        private int end = 0;
        private AnimationIterator.Type type = null;
        private FloatSupplier speed = null;
        private Boolean override = null;
        private Player player = null;

        private Builder() {
        }

        @NotNull
        public Builder predicate(@Nullable BooleanSupplier predicate) {
            this.predicate = Objects.requireNonNull(predicate);
            return this;
        }

        @NotNull
        public Builder start(int start2) {
            this.start = start2;
            return this;
        }

        @NotNull
        public Builder end(int end) {
            this.end = end;
            return this;
        }

        @NotNull
        public Builder type(@Nullable AnimationIterator.Type type) {
            this.type = type;
            return this;
        }

        @NotNull
        public Builder speed(float speed) {
            this.speed = AnimationModifier.toSupplier(speed);
            return this;
        }

        @NotNull
        public Builder speed(@Nullable FloatSupplier speed) {
            this.speed = speed;
            return this;
        }

        @NotNull
        public Builder override(@Nullable Boolean override) {
            this.override = override;
            return this;
        }

        @NotNull
        public Builder player(@Nullable Player player) {
            this.player = player;
            return this;
        }

        @NotNull
        public Builder mergeNotDefault(@NotNull AnimationModifier modifier) {
            if (modifier.predicate != null) {
                this.predicate(modifier.predicate);
            }
            if (modifier.start >= 0) {
                this.start(modifier.start);
            }
            if (modifier.end >= 0) {
                this.end(modifier.end);
            }
            if (modifier.type != null) {
                this.type(modifier.type);
            }
            if (modifier.speed != null) {
                this.speed(modifier.speed);
            }
            if (modifier.override != null) {
                this.override(modifier.override);
            }
            if (modifier.player != null) {
                this.player(modifier.player);
            }
            return this;
        }

        @NotNull
        public AnimationModifier build() {
            return new AnimationModifier(this.predicate, this.start, this.end, this.type, this.speed, this.override, this.player);
        }
    }
}

